/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.util.apache.cocoon.xml;

import fr.gouv.culture.util.apache.cocoon.xml.AbstractSynchronizedXMLProducer;
import fr.gouv.culture.util.apache.cocoon.xml.SynchronizedXMLPipe;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class AbstractSynchronizedXMLPipe
extends AbstractSynchronizedXMLProducer
implements SynchronizedXMLPipe {
    protected boolean synchronizedXmlConsumerAcquired = false;

    protected void acquireSynchronizedXMLConsumer() throws SAXException {
        if (this.synchronizedXmlConsumer != null && !this.synchronizedXmlConsumerAcquired) {
            try {
                this.synchronizedXmlConsumer.acquire();
                this.synchronizedXmlConsumerAcquired = true;
            }
            catch (InterruptedException e) {
                throw new SAXException(e.getMessage(), e);
            }
        }
    }

    protected void releaseSynchronizedXMLConsumer() {
        if (this.synchronizedXmlConsumer != null) {
            this.synchronizedXmlConsumer.release();
        }
        this.synchronizedXmlConsumerAcquired = false;
    }

    public void setDocumentLocator(Locator locator) {
        try {
            if (this.isAcquired()) {
                this.acquireSynchronizedXMLConsumer();
                if (this.synchronizedXmlConsumer != null) {
                    this.synchronizedXmlConsumer.setDocumentLocator(locator);
                }
            }
        }
        catch (SAXException e) {
            this.releaseSynchronizedXMLConsumer();
            e.printStackTrace();
        }
    }

    public void startDocument() throws SAXException {
        try {
            if (this.isAcquired()) {
                this.acquireSynchronizedXMLConsumer();
                if (this.synchronizedXmlConsumer != null) {
                    this.synchronizedXmlConsumer.startDocument();
                }
            }
        }
        catch (SAXException e) {
            this.releaseSynchronizedXMLConsumer();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endDocument() throws SAXException {
        try {
            if (this.isAcquired() && this.synchronizedXmlConsumer != null) {
                this.synchronizedXmlConsumer.endDocument();
            }
        }
        finally {
            this.releaseSynchronizedXMLConsumer();
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        try {
            if (this.isAcquired() && this.synchronizedXmlConsumer != null) {
                this.synchronizedXmlConsumer.startPrefixMapping(prefix, uri);
            }
        }
        catch (SAXException e) {
            this.releaseSynchronizedXMLConsumer();
            throw e;
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        try {
            if (this.isAcquired() && this.synchronizedXmlConsumer != null) {
                this.synchronizedXmlConsumer.endPrefixMapping(prefix);
            }
        }
        catch (SAXException e) {
            this.releaseSynchronizedXMLConsumer();
            throw e;
        }
    }

    public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
        try {
            if (this.isAcquired() && this.synchronizedXmlConsumer != null) {
                this.synchronizedXmlConsumer.startElement(uri, loc, raw, a);
            }
        }
        catch (SAXException e) {
            this.releaseSynchronizedXMLConsumer();
            throw e;
        }
    }

    public void endElement(String uri, String loc, String raw) throws SAXException {
        try {
            if (this.isAcquired() && this.synchronizedXmlConsumer != null) {
                this.synchronizedXmlConsumer.endElement(uri, loc, raw);
            }
        }
        catch (SAXException e) {
            this.releaseSynchronizedXMLConsumer();
            throw e;
        }
    }

    public void characters(char[] c, int start, int len) throws SAXException {
        try {
            if (this.isAcquired() && this.synchronizedXmlConsumer != null) {
                this.synchronizedXmlConsumer.characters(c, start, len);
            }
        }
        catch (SAXException e) {
            this.releaseSynchronizedXMLConsumer();
            throw e;
        }
    }

    public void ignorableWhitespace(char[] c, int start, int len) throws SAXException {
        try {
            if (this.isAcquired() && this.synchronizedXmlConsumer != null) {
                this.synchronizedXmlConsumer.ignorableWhitespace(c, start, len);
            }
        }
        catch (SAXException e) {
            this.releaseSynchronizedXMLConsumer();
            throw e;
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        try {
            if (this.isAcquired() && this.synchronizedXmlConsumer != null) {
                this.synchronizedXmlConsumer.processingInstruction(target, data);
            }
        }
        catch (SAXException e) {
            this.releaseSynchronizedXMLConsumer();
            throw e;
        }
    }

    public void skippedEntity(String name) throws SAXException {
        try {
            if (this.isAcquired() && this.synchronizedXmlConsumer != null) {
                this.synchronizedXmlConsumer.skippedEntity(name);
            }
        }
        catch (SAXException e) {
            this.releaseSynchronizedXMLConsumer();
            throw e;
        }
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        try {
            if (this.isAcquired() && this.synchronizedXmlConsumer != null) {
                this.synchronizedXmlConsumer.startDTD(name, publicId, systemId);
            }
        }
        catch (SAXException e) {
            this.releaseSynchronizedXMLConsumer();
            throw e;
        }
    }

    public void endDTD() throws SAXException {
        try {
            if (this.isAcquired() && this.synchronizedXmlConsumer != null) {
                this.synchronizedXmlConsumer.endDTD();
            }
        }
        catch (SAXException e) {
            this.releaseSynchronizedXMLConsumer();
            throw e;
        }
    }

    public void startEntity(String name) throws SAXException {
        try {
            if (this.isAcquired() && this.synchronizedXmlConsumer != null) {
                this.synchronizedXmlConsumer.startEntity(name);
            }
        }
        catch (SAXException e) {
            this.releaseSynchronizedXMLConsumer();
            throw e;
        }
    }

    public void endEntity(String name) throws SAXException {
        try {
            if (this.isAcquired() && this.synchronizedXmlConsumer != null) {
                this.synchronizedXmlConsumer.endEntity(name);
            }
        }
        catch (SAXException e) {
            this.releaseSynchronizedXMLConsumer();
            throw e;
        }
    }

    public void startCDATA() throws SAXException {
        try {
            if (this.isAcquired() && this.synchronizedXmlConsumer != null) {
                this.synchronizedXmlConsumer.startCDATA();
            }
        }
        catch (SAXException e) {
            this.releaseSynchronizedXMLConsumer();
            throw e;
        }
    }

    public void endCDATA() throws SAXException {
        try {
            if (this.isAcquired() && this.synchronizedXmlConsumer != null) {
                this.synchronizedXmlConsumer.endCDATA();
            }
        }
        catch (SAXException e) {
            this.releaseSynchronizedXMLConsumer();
            throw e;
        }
    }

    public void comment(char[] ch, int start, int len) throws SAXException {
        try {
            if (this.isAcquired() && this.synchronizedXmlConsumer != null) {
                this.synchronizedXmlConsumer.comment(ch, start, len);
            }
        }
        catch (SAXException e) {
            this.releaseSynchronizedXMLConsumer();
            throw e;
        }
    }

    public void recycle() {
        super.recycle();
        this.synchronizedXmlConsumerAcquired = false;
    }
}

