/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.utils.lucene;

import fr.gouv.culture.sdx.search.lucene.DateField;
import fr.gouv.culture.sdx.utils.Date;
import fr.gouv.culture.sdx.utils.database.Property;
import org.apache.lucene.document.Field;

public class LuceneDataField
extends Property {
    protected int fieldType;
    protected boolean store = true;
    public static final String FIELD_TYPE_WORD = "WORD";
    public static final String FIELD_TYPE_FIELD = "FIELD";
    public static final String FIELD_TYPE_DATE = "DATE";
    public static final String FIELD_TYPE_UNINDEXED = "UNINDEXED";
    public static final int WORD = 0;
    public static final int FIELD = 1;
    public static final int DATE = 2;
    public static final int UNINDEXED = 3;

    public void setFieldType(String type) {
        this.fieldType = type.equalsIgnoreCase(FIELD_TYPE_WORD) ? 0 : (type.equalsIgnoreCase(FIELD_TYPE_FIELD) ? 1 : (type.equalsIgnoreCase(FIELD_TYPE_DATE) ? 2 : (type.equalsIgnoreCase(FIELD_TYPE_UNINDEXED) ? 3 : 0)));
    }

    public void setFieldType(boolean store, boolean index, boolean token) {
        this.setStore(store);
        if (index & !token) {
            this.fieldType = 1;
        } else if (!index & !token) {
            this.fieldType = 3;
        } else if (index & token) {
            this.fieldType = 0;
        }
    }

    public String getTypeName() {
        if (this.fieldType == 0) {
            return FIELD_TYPE_WORD.toLowerCase();
        }
        if (this.fieldType == 1) {
            return FIELD_TYPE_FIELD.toLowerCase();
        }
        if (this.fieldType == 2) {
            return FIELD_TYPE_DATE.toLowerCase();
        }
        if (this.fieldType == 3) {
            return FIELD_TYPE_UNINDEXED.toLowerCase();
        }
        return null;
    }

    public Field getLuceneField(String content) {
        switch (this.fieldType) {
            case 2: {
                java.util.Date date = Date.parseDate(content);
                if (date != null) {
                    return new Field(this.name, DateField.dateToString(date), this.store, true, false, false);
                }
                return new Field(this.name, content, this.store, true, false, false);
            }
            case 1: {
                return new Field(this.name, content, this.store, true, false, false);
            }
            case 0: {
                return new Field(this.name, content, this.store, true, true);
            }
            case 3: {
                return new Field(this.name, content, this.store, false, false, false);
            }
        }
        return new Field(this.name, content, false, true, true, false);
    }

    public void setStore(boolean store) {
        this.store = store;
    }
}

