/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.util;

import java.io.IOException;
import java.io.Writer;
import org.apache.batik.dom.util.HashTable;
import org.apache.batik.xml.XMLUtilities;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMUtilities
extends XMLUtilities {
    protected DOMUtilities() {
    }

    public static void writeDocument(Document document, Writer writer) throws IOException {
        for (Node node = document.getFirstChild(); node != null; node = node.getNextSibling()) {
            DOMUtilities.writeNode(node, writer);
        }
    }

    public static void writeNode(Node node, Writer writer) throws IOException {
        switch (node.getNodeType()) {
            case 1: {
                Object object;
                writer.write("<");
                writer.write(node.getNodeName());
                if (node.hasAttributes()) {
                    object = node.getAttributes();
                    int n = object.getLength();
                    for (int i = 0; i < n; ++i) {
                        Attr attr = (Attr)object.item(i);
                        writer.write(" ");
                        writer.write(attr.getNodeName());
                        writer.write("=\"");
                        writer.write(DOMUtilities.contentToString(attr.getNodeValue()));
                        writer.write("\"");
                    }
                }
                if ((object = node.getFirstChild()) != null) {
                    writer.write(">");
                    while (object != null) {
                        DOMUtilities.writeNode((Node)object, writer);
                        object = object.getNextSibling();
                    }
                    writer.write("</");
                    writer.write(node.getNodeName());
                    writer.write(">");
                    break;
                }
                writer.write("/>");
                break;
            }
            case 3: {
                writer.write(DOMUtilities.contentToString(node.getNodeValue()));
                break;
            }
            case 4: {
                writer.write("<![CDATA[");
                writer.write(node.getNodeValue());
                writer.write("]]>");
                break;
            }
            case 5: {
                writer.write("&");
                writer.write(node.getNodeName());
                writer.write(";");
                break;
            }
            case 7: {
                writer.write("<?");
                writer.write(node.getNodeName());
                writer.write(" ");
                writer.write(node.getNodeValue());
                writer.write("?>");
                break;
            }
            case 8: {
                writer.write("<!--");
                writer.write(node.getNodeValue());
                writer.write("-->");
                break;
            }
            case 10: {
                break;
            }
            default: {
                throw new Error("Internal error (" + node.getNodeType() + ")");
            }
        }
    }

    public static String contentToString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block7;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    continue block7;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static Document deepCloneDocument(Document document, DOMImplementation dOMImplementation) {
        Element element = document.getDocumentElement();
        Document document2 = dOMImplementation.createDocument(element.getNamespaceURI(), element.getNodeName(), null);
        Element element2 = document2.getDocumentElement();
        boolean bl = true;
        for (Node node = document.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == element) {
                Object object;
                bl = false;
                if (element.hasAttributes()) {
                    object = element.getAttributes();
                    int n = object.getLength();
                    for (int i = 0; i < n; ++i) {
                        element2.setAttributeNode((Attr)document2.importNode(object.item(i), true));
                    }
                }
                for (object = element.getFirstChild(); object != null; object = object.getNextSibling()) {
                    element2.appendChild(document2.importNode((Node)object, true));
                }
                continue;
            }
            if (node.getNodeType() == 10) continue;
            if (bl) {
                document2.insertBefore(document2.importNode(node, true), element2);
                continue;
            }
            document2.appendChild(document2.importNode(node, true));
        }
        return document2;
    }

    public static boolean isValidName(String string) {
        int n;
        char c = string.charAt(0);
        int n2 = c / 32;
        if ((NAME_FIRST_CHARACTER[n2] & 1 << (n = c % 32)) == 0) {
            return false;
        }
        int n3 = string.length();
        for (int i = 1; i < n3; ++i) {
            c = string.charAt(i);
            n2 = c / 32;
            if ((NAME_CHARACTER[n2] & 1 << (n = c % 32)) != 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidPrefix(String string) {
        return string.indexOf(58) == -1;
    }

    public static String getPrefix(String string) {
        int n = string.indexOf(58);
        return n == -1 || n == string.length() - 1 ? null : string.substring(0, n);
    }

    public static String getLocalName(String string) {
        int n = string.indexOf(58);
        return n == -1 || n == string.length() - 1 ? string : string.substring(n + 1);
    }

    public static void parseStyleSheetPIData(String string, HashTable hashTable) {
        char c;
        int n;
        for (n = 0; n < string.length() && XMLUtilities.isXMLSpace(c = string.charAt(n)); ++n) {
        }
        while (n < string.length()) {
            int n2;
            c = string.charAt(n);
            int n3 = c / 32;
            if ((NAME_FIRST_CHARACTER[n3] & 1 << (n2 = c % 32)) == 0) {
                throw new DOMException(5, "Wrong name initial:  " + c);
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(c);
            while (++n < string.length() && (NAME_CHARACTER[n3 = (c = string.charAt(n)) / 32] & 1 << (n2 = c % 32)) != 0) {
                stringBuffer.append(c);
            }
            if (n >= string.length()) {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + string);
            }
            while (n < string.length() && XMLUtilities.isXMLSpace(c = string.charAt(n))) {
                ++n;
            }
            if (n >= string.length()) {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + string);
            }
            if (string.charAt(n) != '=') {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + string);
            }
            ++n;
            while (n < string.length() && XMLUtilities.isXMLSpace(c = string.charAt(n))) {
                ++n;
            }
            if (n >= string.length()) {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + string);
            }
            c = string.charAt(n);
            ++n;
            StringBuffer stringBuffer2 = new StringBuffer();
            if (c == '\'') {
                while (n < string.length() && (c = string.charAt(n)) != '\'') {
                    stringBuffer2.append(c);
                    ++n;
                }
                if (n >= string.length()) {
                    throw new DOMException(12, "Wrong xml-stylesheet data: " + string);
                }
            } else if (c == '\"') {
                while (n < string.length() && (c = string.charAt(n)) != '\"') {
                    stringBuffer2.append(c);
                    ++n;
                }
                if (n >= string.length()) {
                    throw new DOMException(12, "Wrong xml-stylesheet data: " + string);
                }
            } else {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + string);
            }
            hashTable.put(stringBuffer.toString().intern(), stringBuffer2.toString());
            ++n;
            while (n < string.length() && XMLUtilities.isXMLSpace(c = string.charAt(n))) {
                ++n;
            }
        }
    }
}

