/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestResult;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.optional.junit.BaseTest;
import org.apache.tools.ant.taskdefs.optional.junit.BatchTest;
import org.apache.tools.ant.taskdefs.optional.junit.Enumerations;
import org.apache.tools.ant.taskdefs.optional.junit.FormatterElement;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner;
import org.apache.tools.ant.taskdefs.optional.junit.SummaryJUnitResultFormatter;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;

public class JUnitTask
extends Task {
    private CommandlineJava commandline = new CommandlineJava();
    private Vector tests = new Vector();
    private Vector batchTests = new Vector();
    private Vector formatters = new Vector();
    private File dir = null;
    private Integer timeout = null;
    private boolean summary = false;
    private String summaryValue = "";
    private JUnitTestRunner runner = null;
    private boolean newEnvironment = false;
    private Environment env = new Environment();
    private boolean includeAntRuntime = true;
    private Path antRuntimeClasses = null;
    private boolean showOutput = false;

    public void setFiltertrace(boolean value) {
        Enumeration enumeration = this.allTests();
        while (enumeration.hasMoreElements()) {
            BaseTest test = (BaseTest)enumeration.nextElement();
            test.setFiltertrace(value);
        }
    }

    public void setHaltonerror(boolean value) {
        Enumeration enumeration = this.allTests();
        while (enumeration.hasMoreElements()) {
            BaseTest test = (BaseTest)enumeration.nextElement();
            test.setHaltonerror(value);
        }
    }

    public void setErrorProperty(String propertyName) {
        Enumeration enumeration = this.allTests();
        while (enumeration.hasMoreElements()) {
            BaseTest test = (BaseTest)enumeration.nextElement();
            test.setErrorProperty(propertyName);
        }
    }

    public void setHaltonfailure(boolean value) {
        Enumeration enumeration = this.allTests();
        while (enumeration.hasMoreElements()) {
            BaseTest test = (BaseTest)enumeration.nextElement();
            test.setHaltonfailure(value);
        }
    }

    public void setFailureProperty(String propertyName) {
        Enumeration enumeration = this.allTests();
        while (enumeration.hasMoreElements()) {
            BaseTest test = (BaseTest)enumeration.nextElement();
            test.setFailureProperty(propertyName);
        }
    }

    public void setFork(boolean value) {
        Enumeration enumeration = this.allTests();
        while (enumeration.hasMoreElements()) {
            BaseTest test = (BaseTest)enumeration.nextElement();
            test.setFork(value);
        }
    }

    public void setPrintsummary(SummaryAttribute value) {
        this.summaryValue = value.getValue();
        this.summary = value.asBoolean();
    }

    public void setTimeout(Integer value) {
        this.timeout = value;
    }

    public void setMaxmemory(String max) {
        this.commandline.setMaxmemory(max);
    }

    public void setJvm(String value) {
        this.commandline.setVm(value);
    }

    public Commandline.Argument createJvmarg() {
        return this.commandline.createVmArgument();
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public void addSysproperty(Environment.Variable sysp) {
        this.commandline.addSysproperty(sysp);
    }

    public Path createClasspath() {
        return this.commandline.createClasspath(this.getProject()).createPath();
    }

    public void addEnv(Environment.Variable var) {
        this.env.addVariable(var);
    }

    public void setNewenvironment(boolean newenv) {
        this.newEnvironment = newenv;
    }

    public void addTest(JUnitTest test) {
        this.tests.addElement(test);
    }

    public BatchTest createBatchTest() {
        BatchTest test = new BatchTest(this.getProject());
        this.batchTests.addElement(test);
        return test;
    }

    public void addFormatter(FormatterElement fe) {
        this.formatters.addElement(fe);
    }

    public void setIncludeantruntime(boolean b) {
        this.includeAntRuntime = b;
    }

    public void setShowOutput(boolean showOutput) {
        this.showOutput = showOutput;
    }

    public JUnitTask() throws Exception {
        this.commandline.setClassname("org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner");
    }

    public void init() {
        this.antRuntimeClasses = new Path(this.getProject());
        this.addClasspathEntry("/junit/framework/TestCase.class");
        this.addClasspathEntry("/org/apache/tools/ant/Task.class");
        this.addClasspathEntry("/org/apache/tools/ant/taskdefs/optional/junit/JUnitTestRunner.class");
    }

    public void execute() throws BuildException {
        Enumeration list = this.getIndividualTests();
        while (list.hasMoreElements()) {
            JUnitTest test = (JUnitTest)list.nextElement();
            if (!test.shouldRun(this.getProject())) continue;
            this.execute(test);
        }
    }

    protected void execute(JUnitTest arg) throws BuildException {
        boolean failureOccurredHere;
        JUnitTest test = (JUnitTest)arg.clone();
        if (test.getTodir() == null) {
            test.setTodir(this.getProject().resolveFile("."));
        }
        if (test.getOutfile() == null) {
            test.setOutfile("TEST-" + test.getName());
        }
        int exitValue = 2;
        boolean wasKilled = false;
        if (!test.getFork()) {
            exitValue = this.executeInVM(test);
        } else {
            ExecuteWatchdog watchdog = this.createWatchdog();
            exitValue = this.executeAsForked(test, watchdog);
            if (watchdog != null) {
                wasKilled = watchdog.killedProcess();
            }
        }
        boolean errorOccurredHere = exitValue == 2;
        boolean bl = failureOccurredHere = exitValue != 0;
        if (errorOccurredHere || failureOccurredHere) {
            if (errorOccurredHere && test.getHaltonerror() || failureOccurredHere && test.getHaltonfailure()) {
                throw new BuildException("Test " + test.getName() + " failed" + (wasKilled ? " (timeout)" : ""), this.getLocation());
            }
            this.log("TEST " + test.getName() + " FAILED" + (wasKilled ? " (timeout)" : ""), 0);
            if (errorOccurredHere && test.getErrorProperty() != null) {
                this.getProject().setNewProperty(test.getErrorProperty(), "true");
            }
            if (failureOccurredHere && test.getFailureProperty() != null) {
                this.getProject().setNewProperty(test.getFailureProperty(), "true");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int executeAsForked(JUnitTest test, ExecuteWatchdog watchdog) throws BuildException {
        String[] environment;
        CommandlineJava cmd = (CommandlineJava)this.commandline.clone();
        cmd.setClassname("org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner");
        cmd.createArgument().setValue(test.getName());
        cmd.createArgument().setValue("filtertrace=" + test.getFiltertrace());
        cmd.createArgument().setValue("haltOnError=" + test.getHaltonerror());
        cmd.createArgument().setValue("haltOnFailure=" + test.getHaltonfailure());
        if (this.includeAntRuntime) {
            this.log("Implicitly adding " + this.antRuntimeClasses + " to CLASSPATH", 3);
            cmd.createClasspath(this.getProject()).createPath().append(this.antRuntimeClasses);
        }
        if (this.summary) {
            this.log("Running " + test.getName(), 2);
            cmd.createArgument().setValue("formatter=org.apache.tools.ant.taskdefs.optional.junit.SummaryJUnitResultFormatter");
        }
        cmd.createArgument().setValue("showoutput=" + String.valueOf(this.showOutput));
        StringBuffer formatterArg = new StringBuffer(128);
        FormatterElement[] feArray = this.mergeFormatters(test);
        int i = 0;
        while (i < feArray.length) {
            FormatterElement fe = feArray[i];
            formatterArg.append("formatter=");
            formatterArg.append(fe.getClassname());
            File outFile = this.getOutput(fe, test);
            if (outFile != null) {
                formatterArg.append(",");
                formatterArg.append(outFile);
            }
            cmd.createArgument().setValue(formatterArg.toString());
            formatterArg.setLength(0);
            ++i;
        }
        File propsFile = FileUtils.newFileUtils().createTempFile("junit", ".properties", this.getProject().getBaseDir());
        cmd.createArgument().setValue("propsfile=" + propsFile.getAbsolutePath());
        Hashtable p = this.getProject().getProperties();
        Properties props = new Properties();
        Enumeration enumeration = p.keys();
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            ((Hashtable)props).put(key, p.get(key));
        }
        try {
            FileOutputStream outstream = new FileOutputStream(propsFile);
            props.save(outstream, "Ant JUnitTask generated properties file");
            outstream.close();
        }
        catch (IOException e) {
            propsFile.delete();
            throw new BuildException("Error creating temporary properties file.", (Throwable)e, this.getLocation());
        }
        Execute execute = new Execute((ExecuteStreamHandler)new LogStreamHandler((Task)this, 2, 1), watchdog);
        execute.setCommandline(cmd.getCommandline());
        execute.setAntRun(this.getProject());
        if (this.dir != null) {
            execute.setWorkingDirectory(this.dir);
        }
        if ((environment = this.env.getVariables()) != null) {
            int i2 = 0;
            while (i2 < environment.length) {
                this.log("Setting environment variable: " + environment[i2], 3);
                ++i2;
            }
        }
        execute.setNewenvironment(this.newEnvironment);
        execute.setEnvironment(environment);
        this.log(cmd.describeCommand(), 3);
        try {
            int retVal;
            try {
                retVal = execute.execute();
            }
            catch (IOException e) {
                throw new BuildException("Process fork failed.", (Throwable)e, this.getLocation());
            }
            Object var16_15 = null;
            if (watchdog != null && watchdog.killedProcess()) {
                this.logTimeout(feArray, test);
            }
            if (propsFile.delete()) return retVal;
            throw new BuildException("Could not delete temporary properties file.");
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            if (watchdog != null && watchdog.killedProcess()) {
                this.logTimeout(feArray, test);
            }
            if (propsFile.delete()) throw throwable;
            throw new BuildException("Could not delete temporary properties file.");
        }
    }

    protected void handleOutput(String line) {
        if (this.runner != null) {
            this.runner.handleOutput(line);
            if (this.showOutput) {
                super.handleOutput(line);
            }
        } else {
            super.handleOutput(line);
        }
    }

    protected void handleFlush(String line) {
        if (this.runner != null) {
            this.runner.handleFlush(line);
            if (this.showOutput) {
                super.handleFlush(line);
            }
        } else {
            super.handleFlush(line);
        }
    }

    public void handleErrorOutput(String line) {
        if (this.runner != null) {
            this.runner.handleErrorOutput(line);
            if (this.showOutput) {
                super.handleErrorOutput(line);
            }
        } else {
            super.handleErrorOutput(line);
        }
    }

    public void handleErrorFlush(String line) {
        if (this.runner != null) {
            this.runner.handleErrorFlush(line);
            if (this.showOutput) {
                super.handleErrorFlush(line);
            }
        } else {
            super.handleErrorFlush(line);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int executeInVM(JUnitTest arg) throws BuildException {
        int n;
        AntClassLoader cl;
        block12: {
            CommandlineJava.SysProperties sysProperties;
            JUnitTest test = (JUnitTest)arg.clone();
            test.setProperties(this.getProject().getProperties());
            if (this.dir != null) {
                this.log("dir attribute ignored if running in the same VM", 1);
            }
            if (this.newEnvironment || null != this.env.getVariables()) {
                this.log("Changes to environment variables are ignored if running in the same VM.", 1);
            }
            if ((sysProperties = this.commandline.getSystemProperties()) != null) {
                sysProperties.setSystem();
            }
            cl = null;
            try {
                Path classpath;
                this.log("Using System properties " + System.getProperties(), 3);
                Path userClasspath = this.commandline.getClasspath();
                Path path = classpath = userClasspath == null ? null : (Path)userClasspath.clone();
                if (classpath != null) {
                    if (this.includeAntRuntime) {
                        this.log("Implicitly adding " + this.antRuntimeClasses + " to CLASSPATH", 3);
                        classpath.append(this.antRuntimeClasses);
                    }
                    cl = new AntClassLoader(null, this.getProject(), classpath, false);
                    this.log("Using CLASSPATH " + cl.getClasspath(), 3);
                    cl.addSystemPackageRoot("junit");
                    cl.addSystemPackageRoot("org.apache.tools.ant");
                    cl.setThreadContextLoader();
                }
                this.runner = new JUnitTestRunner(test, test.getHaltonerror(), test.getFiltertrace(), test.getHaltonfailure(), (ClassLoader)cl);
                if (this.summary) {
                    this.log("Running " + test.getName(), 2);
                    SummaryJUnitResultFormatter f = new SummaryJUnitResultFormatter();
                    f.setWithOutAndErr("withoutanderr".equalsIgnoreCase(this.summaryValue));
                    f.setOutput(this.getDefaultOutput());
                    this.runner.addFormatter(f);
                }
                FormatterElement[] feArray = this.mergeFormatters(test);
                int i = 0;
                while (i < feArray.length) {
                    FormatterElement fe = feArray[i];
                    File outFile = this.getOutput(fe, test);
                    if (outFile != null) {
                        fe.setOutfile(outFile);
                    } else {
                        fe.setOutput(this.getDefaultOutput());
                    }
                    this.runner.addFormatter(fe.createFormatter());
                    ++i;
                }
                this.runner.run();
                n = this.runner.getRetCode();
                Object var12_12 = null;
                if (sysProperties == null) break block12;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                if (sysProperties != null) {
                    sysProperties.restoreSystem();
                }
                if (cl == null) throw throwable;
                cl.resetThreadContextLoader();
                throw throwable;
            }
            sysProperties.restoreSystem();
        }
        if (cl == null) return n;
        cl.resetThreadContextLoader();
        return n;
    }

    protected ExecuteWatchdog createWatchdog() throws BuildException {
        if (this.timeout == null) {
            return null;
        }
        return new ExecuteWatchdog(this.timeout.intValue());
    }

    protected OutputStream getDefaultOutput() {
        return new LogOutputStream((Task)this, 2);
    }

    protected Enumeration getIndividualTests() {
        int count = this.batchTests.size();
        Enumeration[] enums = new Enumeration[count + 1];
        int i = 0;
        while (i < count) {
            BatchTest batchtest = (BatchTest)this.batchTests.elementAt(i);
            enums[i] = batchtest.elements();
            ++i;
        }
        enums[enums.length - 1] = this.tests.elements();
        return Enumerations.fromCompound(enums);
    }

    protected Enumeration allTests() {
        Enumeration[] enums = new Enumeration[]{this.tests.elements(), this.batchTests.elements()};
        return Enumerations.fromCompound(enums);
    }

    private FormatterElement[] mergeFormatters(JUnitTest test) {
        Vector feVector = (Vector)this.formatters.clone();
        test.addFormattersTo(feVector);
        Object[] feArray = new FormatterElement[feVector.size()];
        feVector.copyInto(feArray);
        return feArray;
    }

    protected File getOutput(FormatterElement fe, JUnitTest test) {
        if (fe.getUseFile()) {
            String filename = test.getOutfile() + fe.getExtension();
            File destFile = new File(test.getTodir(), filename);
            String absFilename = destFile.getAbsolutePath();
            return this.getProject().resolveFile(absFilename);
        }
        return null;
    }

    protected void addClasspathEntry(String resource) {
        URL url = ((Object)((Object)this)).getClass().getResource(resource);
        if (url != null) {
            String u = url.toString();
            if (u.startsWith("jar:file:")) {
                int pling = u.indexOf("!");
                String jarName = u.substring(9, pling);
                this.log("Found " + jarName, 4);
                this.antRuntimeClasses.createPath().setLocation(new File(new File(jarName).getAbsolutePath()));
            } else if (u.startsWith("file:")) {
                int tail = u.indexOf(resource);
                String dirName = u.substring(5, tail);
                this.log("Found " + dirName, 4);
                this.antRuntimeClasses.createPath().setLocation(new File(new File(dirName).getAbsolutePath()));
            } else {
                this.log("Don't know how to handle resource URL " + u, 4);
            }
        } else {
            this.log("Couldn't find " + resource, 4);
        }
    }

    private void logTimeout(FormatterElement[] feArray, JUnitTest test) {
        int i = 0;
        while (i < feArray.length) {
            FormatterElement fe = feArray[i];
            File outFile = this.getOutput(fe, test);
            JUnitResultFormatter formatter = fe.createFormatter();
            if (outFile != null && formatter != null) {
                try {
                    FileOutputStream out = new FileOutputStream(outFile);
                    formatter.setOutput(out);
                    formatter.startTestSuite(test);
                    test.setCounts(0L, 0L, 1L);
                    Test t = new Test(){

                        public int countTestCases() {
                            return 0;
                        }

                        public void run(TestResult r) {
                            throw new AssertionFailedError("Timeout occurred");
                        }
                    };
                    formatter.startTest(t);
                    formatter.addError(t, (Throwable)new AssertionFailedError("Timeout occurred"));
                    formatter.endTestSuite(test);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    public static class SummaryAttribute
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"true", "yes", "false", "no", "on", "off", "withOutAndErr"};
        }

        public boolean asBoolean() {
            String value = this.getValue();
            return "true".equals(value) || "on".equals(value) || "yes".equals(value) || "withOutAndErr".equals(value);
        }
    }
}

