/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.xml.dom;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.cocoon.xml.XMLConsumer;
import org.w3c.dom.Document;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class SVGBuilder
extends SAXSVGDocumentFactory
implements XMLConsumer,
LogEnabled,
Recyclable {
    protected Logger log;
    protected Locator locator;
    private static final String SAX_PARSER = "org.apache.xerces.parsers.SAXParser";

    protected SVGBuilder() {
        super(SAX_PARSER);
    }

    public void enableLogging(Logger logger) {
        if (this.log == null) {
            this.log = logger;
        }
    }

    protected Logger getLogger() {
        return this.log;
    }

    public Document getDocument() {
        return this.document;
    }

    public void startDocument() throws SAXException {
        try {
            String namespaceURI = "http://www.w3.org/2000/svg";
            this.document = this.implementation.createDocument(namespaceURI, "svg", null);
            super.startDocument();
            this.namespaces.put("svg", (Object)"http://www.w3.org/2000/svg");
        }
        catch (SAXException se) {
            throw se;
        }
        catch (Exception ex) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Got exception in startDocument, rethrowing", (Throwable)ex);
            }
            throw new SAXException("Exception in startDocument", ex);
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        super.setDocumentLocator(locator);
    }

    public void endDocument() throws SAXException {
        try {
            super.endDocument();
            URL baseURL = null;
            try {
                if (this.locator != null) {
                    baseURL = new URL(this.locator.getSystemId());
                } else {
                    baseURL = new URL("http://localhost/");
                    this.getLogger().warn("setDocumentLocator was not called, will use http://localhost/ as base URI");
                }
                ((SVGOMDocument)this.document).setURLObject(baseURL);
            }
            catch (MalformedURLException e) {
                this.getLogger().warn("Unable to set document base URI to " + baseURL + ", will default to http://localhost/", (Throwable)e);
                ((SVGOMDocument)this.document).setURLObject(new URL("http://localhost/"));
            }
            this.notify(this.document);
        }
        catch (SAXException se) {
            throw se;
        }
        catch (Exception ex) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Got exception in endDocument, rethrowing", (Throwable)ex);
            }
            throw new SAXException("Exception in endDocument", ex);
        }
    }

    protected void notify(Document doc) throws SAXException {
    }

    public void recycle() {
        this.locator = null;
    }
}

