/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.event.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.excalibur.event.PreparedEnqueue;
import org.apache.excalibur.event.Sink;
import org.apache.excalibur.event.SinkException;
import org.apache.excalibur.event.SinkFullException;

public class MultiCastSink
implements Sink {
    private final Collection m_sinks;
    private final int m_size;
    private final boolean m_single;

    public MultiCastSink(Collection sinks) {
        this(sinks, false);
    }

    public MultiCastSink(Collection sinks, boolean single) {
        this.m_sinks = sinks;
        this.m_size = -1;
        this.m_single = single;
    }

    public int canAccept() {
        return 0;
    }

    public boolean isFull() {
        return false;
    }

    public int maxSize() {
        return 0;
    }

    public void enqueue(Object element) throws SinkException {
        PreparedEnqueue prepared = this.prepareEnqueue(new Object[]{element});
        prepared.commit();
    }

    public void enqueue(Object[] elements) throws SinkException {
        PreparedEnqueue prepared = this.prepareEnqueue(elements);
        prepared.commit();
    }

    public boolean tryEnqueue(Object element) {
        try {
            this.enqueue(element);
            return true;
        }
        catch (SinkException e) {
            return false;
        }
    }

    public PreparedEnqueue prepareEnqueue(Object[] elements) throws SinkException {
        DefaultPreparedEnqueue prepares = new DefaultPreparedEnqueue();
        int successful = 0;
        Iterator sinks = this.m_sinks.iterator();
        while (sinks.hasNext()) {
            Sink sink = (Sink)sinks.next();
            try {
                prepares.addPreparedEnqueue(sink.prepareEnqueue(elements));
            }
            catch (SinkFullException e) {
                continue;
            }
            if (this.m_single) {
                return prepares;
            }
            ++successful;
            break;
        }
        if (successful < this.m_sinks.size()) {
            prepares.abort();
            throw new SinkFullException("Could not deliver elements.");
        }
        return prepares;
    }

    public int size() {
        return this.m_size;
    }

    private static final class DefaultPreparedEnqueue
    implements PreparedEnqueue {
        private final Collection m_preparedEnqueues = new LinkedList();

        private DefaultPreparedEnqueue() {
        }

        public void abort() {
            Iterator iter = this.m_preparedEnqueues.iterator();
            while (iter.hasNext()) {
                ((PreparedEnqueue)iter.next()).abort();
            }
        }

        public void commit() {
            Iterator iter = this.m_preparedEnqueues.iterator();
            while (iter.hasNext()) {
                ((PreparedEnqueue)iter.next()).commit();
            }
        }

        public void addPreparedEnqueue(PreparedEnqueue preparedEnqueue) {
            this.m_preparedEnqueues.add(preparedEnqueue);
        }
    }
}

