/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.manager;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.excalibur.instrument.manager.AbstractValueInstrumentSample;
import org.apache.excalibur.instrument.manager.InstrumentProxy;

class MeanValueInstrumentSample
extends AbstractValueInstrumentSample {
    private long m_valueTotal;

    MeanValueInstrumentSample(InstrumentProxy instrumentProxy, String name, long interval, int size, String description, long lease) {
        super(instrumentProxy, name, interval, size, description, lease);
    }

    public int getType() {
        return 104;
    }

    protected void advanceToNextSample() {
        this.m_valueCount = 0;
    }

    protected void saveState(DefaultConfiguration state) {
        super.saveState(state);
        state.setAttribute("value-total", Long.toString(this.m_valueTotal));
    }

    protected void loadState(int value, Configuration state) throws ConfigurationException {
        super.loadState(value, state);
        this.m_valueTotal = state.getAttributeAsLong("value-total");
    }

    protected void postSaveNeedsReset() {
        super.postSaveNeedsReset();
        this.m_valueTotal = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setValueInner(int value, long time) {
        long sampleTime;
        int sampleValue;
        MeanValueInstrumentSample meanValueInstrumentSample = this;
        synchronized (meanValueInstrumentSample) {
            this.update(time);
            if (this.m_valueCount > 0) {
                ++this.m_valueCount;
                this.m_valueTotal += (long)value;
                this.m_value = (int)(this.m_valueTotal / (long)this.m_valueCount);
            } else {
                this.m_valueCount = 1;
                this.m_value = value;
                this.m_valueTotal = this.m_value;
            }
            sampleValue = this.m_value;
            sampleTime = this.m_time;
        }
        this.updateListeners(sampleValue, sampleTime);
    }
}

