/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.DirectoryGenerator;
import org.apache.cocoon.xml.dom.DOMStreamer;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.xml.dom.DOMParser;
import org.apache.excalibur.xml.xpath.PrefixResolver;
import org.apache.excalibur.xml.xpath.XPathProcessor;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XPathDirectoryGenerator
extends DirectoryGenerator {
    protected static final String XPATH_NODE_NAME = "xpath";
    protected static final String QUERY_ATTR_NAME = "query";
    protected static Map mappingFiles = new HashMap();
    protected DOMParser parser = null;
    protected Document doc = null;
    protected PrefixResolver prefixResolver = null;
    protected RE xmlRE = null;
    protected String xpath = null;
    protected XPathProcessor processor = null;

    public void dispose() {
        if (this.manager != null) {
            this.manager.release((Object)this.processor);
            this.manager.release((Object)this.parser);
            this.processor = null;
            this.parser = null;
        }
        super.dispose();
    }

    public void recycle() {
        this.xpath = null;
        this.doc = null;
        super.recycle();
    }

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this.processor = (XPathProcessor)manager.lookup(XPathProcessor.ROLE);
        this.parser = (DOMParser)manager.lookup(DOMParser.ROLE);
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        String mappings;
        super.setup(resolver, objectModel, src, par);
        this.xpath = par.getParameter(XPATH_NODE_NAME, null);
        this.cacheKeyParList.add(this.xpath);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Applying XPath: " + this.xpath + " to directory " + this.source);
        }
        if (null != (mappings = par.getParameter("nsmapping", null))) {
            boolean mapping_reload = par.getParameterAsBoolean("nsmapping-reload", false);
            Source mappingSource = resolver.resolveURI(mappings);
            String mappingKey = mappingSource.getURI();
            MappingInfo mappingInfo = (MappingInfo)mappingFiles.get(mappingKey);
            if (null == mappingInfo || !mappingInfo.reload || mappingInfo.mappingSource.getLastModified() < mappingSource.getLastModified()) {
                this.prefixResolver = new MappingInfo(this.getLogger().getChildLogger("prefix-resolver"), mappingSource, mapping_reload);
                mappingFiles.put(mappingKey, this.prefixResolver);
            } else {
                this.prefixResolver = mappingInfo;
            }
        }
        String xmlFilesPattern = null;
        try {
            xmlFilesPattern = par.getParameter("xmlFiles", "\\.xml$");
            this.cacheKeyParList.add(xmlFilesPattern);
            this.xmlRE = new RE(xmlFilesPattern);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("pattern for XML files: " + xmlFilesPattern);
            }
        }
        catch (RESyntaxException rese) {
            throw new ProcessingException("Syntax error in regexp pattern '" + xmlFilesPattern + "'", rese);
        }
    }

    protected boolean isXML(File path) {
        return this.xmlRE.match(path.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void performXPathQuery(File xmlFile) throws SAXException {
        block9: {
            this.doc = null;
            Source source = null;
            try {
                Object var7_3;
                try {
                    source = this.resolver.resolveURI(xmlFile.toURL().toExternalForm());
                    this.doc = this.parser.parseDocument(SourceUtil.getInputSource(source));
                }
                catch (SAXException e) {
                    this.getLogger().error("Warning:" + xmlFile.getName() + " is not a valid XML file. Ignoring.", (Throwable)e);
                    var7_3 = null;
                    this.resolver.release(source);
                    break block9;
                }
                catch (ProcessingException e) {
                    this.getLogger().error("Warning: Problem while reading the file " + xmlFile.getName() + ". Ignoring.", (Throwable)((Object)e));
                    var7_3 = null;
                    this.resolver.release(source);
                    break block9;
                }
                catch (IOException e) {
                    this.getLogger().error("Warning: Problem while reading the file " + xmlFile.getName() + ". Ignoring.", (Throwable)e);
                    var7_3 = null;
                    this.resolver.release(source);
                    break block9;
                }
                var7_3 = null;
            }
            catch (Throwable throwable) {
                Object var7_4 = null;
                this.resolver.release(source);
                throw throwable;
            }
            this.resolver.release(source);
        }
        if (this.doc == null) return;
        NodeList nl = null == this.prefixResolver ? this.processor.selectNodeList((Node)this.doc.getDocumentElement(), this.xpath) : this.processor.selectNodeList((Node)this.doc.getDocumentElement(), this.xpath, this.prefixResolver);
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("", QUERY_ATTR_NAME, QUERY_ATTR_NAME, "CDATA", this.xpath);
        this.contentHandler.startElement("http://apache.org/cocoon/directory/2.0", XPATH_NODE_NAME, "dir:xpath", attributes);
        DOMStreamer ds = new DOMStreamer(this.xmlConsumer);
        int i = 0;
        while (true) {
            if (i >= nl.getLength()) {
                this.contentHandler.endElement("http://apache.org/cocoon/directory/2.0", XPATH_NODE_NAME, "dir:xpath");
                return;
            }
            ds.stream(nl.item(i));
            ++i;
        }
    }

    protected void startNode(String nodeName, File path) throws SAXException {
        super.startNode(nodeName, path);
        if (this.xpath != null && path.isFile() && this.isXML(path)) {
            this.performXPathQuery(path);
        }
    }

    private static class MappingInfo
    implements PrefixResolver {
        public final Source mappingSource;
        public final boolean reload;
        private final Logger logger;
        private final Map prefixMap;

        public MappingInfo(Logger logger, Source mappingSource, boolean reload) throws SourceNotFoundException, IOException {
            this.logger = logger;
            this.mappingSource = mappingSource;
            this.reload = reload;
            this.prefixMap = new HashMap();
            BufferedReader br = new BufferedReader(new InputStreamReader(mappingSource.getInputStream()));
            String line = br.readLine();
            while (line != null) {
                int i = line.indexOf(61);
                if (i > 0) {
                    String prefix = line.substring(0, i);
                    String namespace = line.substring(i + 1);
                    this.prefixMap.put(prefix, namespace);
                    logger.debug("added mapping: '" + prefix + "'='" + namespace + "'");
                }
                line = br.readLine();
            }
        }

        public String prefixToNamespace(String prefix) {
            String namespace = (String)this.prefixMap.get(prefix);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("have to resolve prefix='" + prefix + ", found namespace='" + namespace + "'");
            }
            return namespace;
        }
    }
}

