/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.ant;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.cocoon.Cocoon;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.ant.CocoonCrawling;
import org.apache.cocoon.ant.DelayedFileOutputStream;
import org.apache.cocoon.ant.DelayedFileSavingEnvironment;
import org.apache.cocoon.ant.UriType;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.commandline.CommandLineContext;
import org.apache.cocoon.environment.commandline.LinkSamplingEnvironment;

public class CocoonProcessorDelegate
extends AbstractLogEnabled
implements Contextualizable,
Configurable,
Initializable {
    private Cocoon cocoon;
    private Context context;
    private CommandLineContext clContext;
    private File contextDir;
    private File destDir;
    private boolean followLinks;
    private CocoonCrawling cocoonCrawling;

    public CocoonProcessorDelegate(Cocoon cocoon) {
        this.cocoon = cocoon;
    }

    public void contextualize(Context context) throws ContextException {
        this.context = new DefaultContext(context);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration child = configuration.getChild("follow-links");
        this.followLinks = child.getValueAsBoolean();
    }

    public void initialize() throws Exception {
        this.clContext = (CommandLineContext)this.context.get((Object)"environment-context");
        this.contextDir = new File(this.clContext.getRealPath("/"));
        this.destDir = (File)this.context.get((Object)"dest-dir");
        this.cocoonCrawling = new CocoonCrawling();
        this.cocoonCrawling.enableLogging(this.getLogger());
    }

    public void processAllUris(Set uris) throws ProcessingException {
        Iterator i = uris.iterator();
        while (i.hasNext()) {
            Object uriObjRef = i.next();
            UriType uriType = null;
            if (uriObjRef instanceof String) {
                uriType = new UriType((String)uriObjRef);
            } else {
                if (!(uriObjRef instanceof UriType)) continue;
                uriType = (UriType)uriObjRef;
            }
            if (uriType == null) continue;
            this.processUri(uriType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUri(UriType uriType) throws ProcessingException {
        int maxIterations = -1;
        int iterations = 0;
        if (!this.followLinks) {
            maxIterations = 1;
        }
        this.cocoonCrawling.setRoot(uriType);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Crawling root " + String.valueOf(uriType.getPath()));
        }
        Iterator cocoonCrawlingIterator = this.cocoonCrawling.iterator();
        while ((maxIterations <= -1 || iterations < maxIterations) && cocoonCrawlingIterator.hasNext()) {
            block30: {
                String message;
                String message2;
                UriType crawlingUriType = (UriType)cocoonCrawlingIterator.next();
                String uri = crawlingUriType.getUri();
                if (uri.charAt(uri.length() - 1) == '/') {
                    crawlingUriType = new UriType("index.html");
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("processUri uri " + String.valueOf(crawlingUriType.getUri()));
                }
                Map parameters = crawlingUriType.getParameters();
                HashMap rewriteLinks = new HashMap();
                DelayedFileOutputStream dfos = new DelayedFileOutputStream();
                try {
                    this.getPage(crawlingUriType, parameters, rewriteLinks, dfos);
                }
                catch (ResourceNotFoundException rnfe) {
                    String message3 = "Unavailable resource of uri " + String.valueOf(crawlingUriType.getUri());
                    this.getLogger().warn(message3, (Throwable)rnfe);
                    break block30;
                }
                catch (Exception e) {
                    message2 = "Processing error of uri " + String.valueOf(crawlingUriType.getUri());
                    this.getLogger().warn(message2, (Throwable)e);
                }
                finally {
                    try {
                        dfos.flush();
                        dfos.close();
                    }
                    catch (IOException ioe) {
                        message = "Cannot close output " + String.valueOf(crawlingUriType.getDestFile()) + ", " + "for URI " + String.valueOf(crawlingUriType.getUri());
                        this.getLogger().warn(message, (Throwable)ioe);
                    }
                }
                String contentType = crawlingUriType.getContentType();
                if (contentType == null || contentType != null && contentType.startsWith("text")) {
                    try {
                        Collection links = this.getLinks(crawlingUriType, parameters);
                        if (links != null) {
                            Iterator i = links.iterator();
                            while (i.hasNext()) {
                                String linkUri = (String)i.next();
                                if (this.getLogger().isDebugEnabled()) {
                                    this.getLogger().debug("processUri linkUri " + String.valueOf(linkUri));
                                }
                                UriType linkUriType = new UriType(crawlingUriType, linkUri);
                                if (this.getLogger().isDebugEnabled()) {
                                    this.getLogger().debug("parent Uri " + String.valueOf(crawlingUriType.getUri()) + ", " + String.valueOf(crawlingUriType.getPath()));
                                }
                                if (this.getLogger().isDebugEnabled()) {
                                    this.getLogger().debug("add uri " + String.valueOf(linkUriType.getUri()));
                                }
                                this.cocoonCrawling.add(linkUriType);
                                crawlingUriType.addLink(linkUriType);
                            }
                        }
                    }
                    catch (ResourceNotFoundException rnfe) {
                        message2 = "Failed fetching links of unavailable resource uri " + String.valueOf(crawlingUriType.getUri());
                        this.getLogger().warn(message2, (Throwable)rnfe);
                    }
                    catch (Exception e) {
                        message = "Processing error while fetching links of uri " + String.valueOf(crawlingUriType.getUri());
                        this.getLogger().warn(message, (Throwable)e);
                    }
                }
            }
            ++iterations;
        }
    }

    public void dumpVisitedLinks() {
        Iterator visitedAlreadyIterator = this.cocoonCrawling.visitedAlreadyIterator();
        while (visitedAlreadyIterator.hasNext()) {
            UriType visitedAlreadyUriType = (UriType)visitedAlreadyIterator.next();
            this.getLogger().info("Visited Uri " + String.valueOf(visitedAlreadyUriType.getUri()) + ", " + "contentType " + String.valueOf(visitedAlreadyUriType.getContentType()));
            Collection linksFromVisitedAlreadyUriType = visitedAlreadyUriType.getLinks();
            if (linksFromVisitedAlreadyUriType == null) continue;
            Iterator linksFromvisitedAlreadyIterator = linksFromVisitedAlreadyUriType.iterator();
            while (linksFromvisitedAlreadyIterator.hasNext()) {
                UriType linkFromVisitedAlreadyUriType = (UriType)linksFromvisitedAlreadyIterator.next();
                this.getLogger().info("Visited Uri links " + String.valueOf(linkFromVisitedAlreadyUriType.getUri()));
            }
        }
    }

    protected void getPage(UriType uriType, Map parameters, Map links, DelayedFileOutputStream dfos) throws Exception {
        Map attributes = null;
        DelayedFileSavingEnvironment env = new DelayedFileSavingEnvironment(uriType, this.contextDir, attributes, parameters, links, dfos, this.getLogger());
        env.setDestDir(this.destDir);
        this.cocoon.process((Environment)env);
        uriType.setContentType(env.getContentType());
    }

    protected Collection getLinks(UriType uriType, Map parameters) throws Exception {
        Map attributes = null;
        LinkSamplingEnvironment env = new LinkSamplingEnvironment(uriType.getDeparameterizedUri(), this.contextDir, attributes, parameters, this.clContext, this.getLogger());
        this.cocoon.process((Environment)env);
        return env.getLinks();
    }
}

