/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.webapps.session.context;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.webapps.session.context.SessionContext;
import org.apache.cocoon.xml.IncludeXMLConsumer;
import org.apache.cocoon.xml.dom.DOMUtil;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceParameters;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.xml.xpath.NodeListImpl;
import org.apache.excalibur.xml.xpath.XPathProcessor;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public final class SimpleSessionContext
implements SessionContext {
    private String name;
    private Document data;
    private Map attributes = new HashMap();
    private String loadResource;
    private String saveResource;
    private XPathProcessor xpathProcessor;
    private SourceResolver resolver;

    public SimpleSessionContext(XPathProcessor xPathProcessor, SourceResolver resolver) throws ProcessingException {
        this.data = DOMUtil.createDocument();
        this.data.appendChild(this.data.createElementNS(null, "context"));
        this.xpathProcessor = xPathProcessor;
        this.resolver = resolver;
    }

    public String getName() {
        return this.name;
    }

    public void setup(String value, String loadResource, String saveResource) {
        this.name = value;
        this.loadResource = loadResource;
        this.saveResource = saveResource;
    }

    public synchronized DocumentFragment getXML(String path) throws ProcessingException {
        DocumentFragment result = null;
        String[] pathComponents = DOMUtil.buildPathArray((String)(path = this.createPath(path)));
        NodeList list = pathComponents == null ? this.xpathProcessor.selectNodeList((Node)this.data, path) : DOMUtil.getNodeListFromPath((Node)this.data, (String[])pathComponents);
        if (list != null && list.getLength() > 0) {
            Document doc = DOMUtil.createDocument();
            result = doc.createDocumentFragment();
            int i = 0;
            while (i < list.getLength()) {
                if (list.item(i).getNodeType() == 2) {
                    result.appendChild(doc.createTextNode(list.item(i).getNodeValue()));
                } else {
                    NodeList childs = list.item(i).getChildNodes();
                    if (childs != null) {
                        int m = 0;
                        while (m < childs.getLength()) {
                            result.appendChild(doc.importNode(childs.item(m), true));
                            ++m;
                        }
                    }
                }
                ++i;
            }
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void setXML(String path, DocumentFragment fragment) throws ProcessingException {
        block3: {
            node = DOMUtil.selectSingleNode((Node)this.data, (String)(path = this.createPath(path)), (XPathProcessor)this.xpathProcessor);
            if (node.getNodeType() != 2) ** GOTO lbl8
            attr = (Attr)node;
            attr.setNodeValue(DOMUtil.getValueOfNode((Node)fragment));
            break block3;
lbl-1000:
            // 1 sources

            {
                node.removeChild(node.getFirstChild());
lbl8:
                // 2 sources

                ** while (node.hasChildNodes())
            }
lbl9:
            // 1 sources

            childs = fragment.getChildNodes();
            if (childs != null && childs.getLength() > 0) {
                i = 0;
                while (i < childs.getLength()) {
                    n = this.data.importNode(childs.item(i), true);
                    node.appendChild(n);
                    ++i;
                }
            }
        }
    }

    public synchronized void appendXML(String path, DocumentFragment fragment) throws ProcessingException {
        Node node = DOMUtil.selectSingleNode((Node)this.data, (String)(path = this.createPath(path)), (XPathProcessor)this.xpathProcessor);
        if (node.getNodeType() == 2) {
            Attr attr;
            if (node.getNodeValue() != null || node.getNodeValue().trim().length() > 0) {
                attr = node.getOwnerDocument().createAttributeNS(null, node.getNodeName());
                node.getParentNode().appendChild(attr);
            } else {
                attr = (Attr)node;
            }
            attr.setNodeValue(DOMUtil.getValueOfNode((Node)fragment));
        } else {
            NodeList childs = fragment.getChildNodes();
            if (childs != null && childs.getLength() > 0) {
                int i = 0;
                while (i < childs.getLength()) {
                    Node n = this.data.importNode(childs.item(i), true);
                    node.appendChild(n);
                    ++i;
                }
            }
        }
    }

    private String createPath(String path) {
        if (path == null) {
            path = "/";
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if ((path = "context" + path).endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public synchronized void removeXML(String path) throws ProcessingException {
        String[] pathComponents = DOMUtil.buildPathArray((String)(path = this.createPath(path)));
        NodeList list = pathComponents == null ? this.xpathProcessor.selectNodeList((Node)this.data, path) : DOMUtil.getNodeListFromPath((Node)this.data, (String[])pathComponents);
        if (list != null && list.getLength() > 0) {
            int len = list.getLength();
            int i = 0;
            while (i < len) {
                Node child = list.item(len - 1 - i);
                child.getParentNode().removeChild(child);
                ++i;
            }
        }
    }

    public synchronized Node getSingleNode(String path) throws ProcessingException {
        Node result = null;
        path = this.createPath(path);
        try {
            result = DOMUtil.getSingleNode((Node)this.data, (String)path, (XPathProcessor)this.xpathProcessor);
            if (result != null) {
                result = result.cloneNode(true);
            }
        }
        catch (TransformerException localException) {
            throw new ProcessingException("TransformerException: " + localException, (Throwable)localException);
        }
        return result;
    }

    public synchronized NodeList getNodeList(String path) throws ProcessingException {
        NodeList result = null;
        String[] pathComponents = DOMUtil.buildPathArray((String)(path = this.createPath(path)));
        result = pathComponents == null ? this.xpathProcessor.selectNodeList((Node)this.data, path) : DOMUtil.getNodeListFromPath((Node)this.data, (String[])pathComponents);
        if (result != null) {
            result = new NodeListImpl(result);
        }
        return result;
    }

    public synchronized void setNode(String path, Node node) throws ProcessingException {
        if (path == null || path.equals("/")) {
            this.data = DOMUtil.createDocument();
            this.data.appendChild(this.data.createElementNS(null, "context"));
            this.data.getFirstChild().appendChild(this.data.importNode(node, true));
        } else {
            path = this.createPath(path);
            Node removeNode = DOMUtil.selectSingleNode((Node)this.data, (String)path, (XPathProcessor)this.xpathProcessor);
            removeNode.getParentNode().replaceChild(this.data.importNode(node, true), removeNode);
        }
    }

    public synchronized void setAttribute(String key, Object value) {
        if (value == null) {
            this.attributes.remove(key);
        } else {
            this.attributes.put(key, value);
        }
    }

    public synchronized Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public synchronized Object getAttribute(String key, Object defaultObject) {
        Object value = this.attributes.get(key);
        if (value == null) {
            value = defaultObject;
        }
        return value;
    }

    public synchronized String getValueOfNode(String path) throws ProcessingException {
        String value = null;
        path = this.createPath(path);
        value = DOMUtil.getValueOf((Node)this.data, (String)path, (XPathProcessor)this.xpathProcessor);
        return value;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void setValueOfNode(String path, String value) throws ProcessingException {
        block1: {
            node = DOMUtil.selectSingleNode((Node)this.data, (String)(path = this.createPath(path)), (XPathProcessor)this.xpathProcessor);
            if (node.getNodeType() != 2) ** GOTO lbl8
            attr = (Attr)node;
            attr.setNodeValue(value);
            break block1;
lbl-1000:
            // 1 sources

            {
                node.removeChild(node.getFirstChild());
lbl8:
                // 2 sources

                ** while (node.hasChildNodes())
            }
lbl9:
            // 1 sources

            node.appendChild(node.getOwnerDocument().createTextNode(value));
        }
    }

    public synchronized boolean streamXML(String path, ContentHandler contentHandler, LexicalHandler lexicalHandler) throws SAXException, ProcessingException {
        boolean streamed = false;
        String[] pathComponents = DOMUtil.buildPathArray((String)(path = this.createPath(path)));
        NodeList list = pathComponents == null ? this.xpathProcessor.selectNodeList((Node)this.data, path) : DOMUtil.getNodeListFromPath((Node)this.data, (String[])pathComponents);
        if (list != null && list.getLength() > 0) {
            streamed = true;
            int i = 0;
            while (i < list.getLength()) {
                if (list.item(i).getNodeType() == 2) {
                    String value = list.item(i).getNodeValue();
                    contentHandler.characters(value.toCharArray(), 0, value.length());
                } else {
                    NodeList childs = list.item(i).getChildNodes();
                    if (childs != null) {
                        int m = 0;
                        while (m < childs.getLength()) {
                            IncludeXMLConsumer.includeNode((Node)childs.item(m), (ContentHandler)contentHandler, (LexicalHandler)lexicalHandler);
                            ++m;
                        }
                    }
                }
                ++i;
            }
        }
        return streamed;
    }

    public void loadXML(String path, SourceParameters parameters) throws SAXException, ProcessingException, IOException {
        if (this.loadResource == null) {
            throw new ProcessingException("The context " + this.name + " does not support loading.");
        }
        Source source = null;
        try {
            try {
                source = SourceUtil.getSource((String)this.loadResource, null, (SourceParameters)parameters, (SourceResolver)this.resolver);
                Document doc = SourceUtil.toDOM((Source)source);
                DocumentFragment df = doc.createDocumentFragment();
                df.appendChild(doc.getDocumentElement());
                this.setXML(path, df);
            }
            catch (SourceException se) {
                throw SourceUtil.handle((SourceException)se);
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.resolver.release(source);
            throw throwable;
        }
        this.resolver.release(source);
    }

    public void saveXML(String path, SourceParameters parameters) throws SAXException, ProcessingException, IOException {
        if (this.saveResource == null) {
            throw new ProcessingException("The context " + this.name + " does not support saving.");
        }
        DocumentFragment frag = this.getXML(path);
        if (frag == null) {
            frag = DOMUtil.createDocument().createDocumentFragment();
        }
        SourceUtil.writeDOM((String)this.saveResource, null, (SourceParameters)parameters, (DocumentFragment)frag, (SourceResolver)this.resolver, (String)"xml");
    }
}

