/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.sdx.search.lucene.analysis;

import fr.gouv.culture.sdx.search.lucene.analysis.filter.BrazilianStemFilter;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.de.WordlistLoader;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;

/*
 * Created by IntelliJ IDEA.
 * User: rpandey
 * Date: 12 janv. 2004
 * Time: 14:51:13
 * To change this template use Options | File Templates.
 */

/**
 * Analyzer for brazilian language. Supports an external list of stopwords (words that
 * will not be indexed at all) and an external list of exclusions (word that will
 * not be stemmed, but indexed).
 *
 * @author    Jo�o Kramer
 * @version   $Id: BrazilianAnalyzer.java,v 1.0 2001/02/13 21:29:04
 */
public class Analyzer_br extends DefaultAnalyzer {

	protected final static String ANALYZER_TYPE="Analyzer_br";
	
    /**
     * List of typical brazilian stopwords.
     */
    public static final String[] BRAZILIAN_STOP_WORDS = {
        "a", "ainda", "alem", "ambas", "ambos", "antes",
        "ao", "aonde", "aos", "apos", "aquele", "aqueles",
        "as", "assim", "com", "como", "contra", "contudo",
        "cuja", "cujas", "cujo", "cujos", "da", "das", "de",
        "dela", "dele", "deles", "demais", "depois", "desde",
        "desta", "deste", "dispoe", "dispoem", "diversa",
        "diversas", "diversos", "do", "dos", "durante", "e",
        "ela", "elas", "ele", "eles", "em", "entao", "entre",
        "essa", "essas", "esse", "esses", "esta", "estas",
        "este", "estes", "ha", "isso", "isto", "logo", "mais",
        "mas", "mediante", "menos", "mesma", "mesmas", "mesmo",
        "mesmos", "na", "nas", "nao", "nas", "nem", "nesse", "neste",
        "nos", "o", "os", "ou", "outra", "outras", "outro", "outros",
        "pelas", "pelas", "pelo", "pelos", "perante", "pois", "por",
        "porque", "portanto", "proprio", "propios", "quais", "qual",
        "qualquer", "quando", "quanto", "que", "quem", "quer", "se",
        "seja", "sem", "sendo", "seu", "seus", "sob", "sobre", "sua",
        "suas", "tal", "tambem", "teu", "teus", "toda", "todas", "todo",
        "todos", "tua", "tuas", "tudo", "um", "uma", "umas", "uns"};


    /**
     * Builds an analyzer with the given stop words.
     */
    public Analyzer_br(String[] stopwords) {
        super.stopTable = StopFilter.makeStopTable(stopwords);
    }

    /**
     * Builds an analyzer with the given stop words.
     */
    public Analyzer_br(Hashtable stopwords) {
        super.stopTable = stopwords;
    }

    /**
     * Builds an analyzer with the given stop words.
     */
    public Analyzer_br(File stopwords) throws IOException {
        super.stopTable = WordlistLoader.getWordtable(stopwords);
    }

    /**
     * Builds an exclusionlist from an array of Strings.
     */
    public void setStemExclusionTable(String[] exclusionlist) {
        super.excludeTable = StopFilter.makeStopTable(exclusionlist);
    }

    /**
     * Builds an exclusionlist from a Hashtable.
     */
    public void setStemExclusionTable(Hashtable exclusionlist) {
        super.excludeTable = exclusionlist;
    }

    /**
     * Builds an exclusionlist from the words contained in the given file.
     */
    public void setStemExclusionTable(File exclusionlist) throws IOException {
        super.excludeTable = WordlistLoader.getWordtable(exclusionlist);
    }

    /**
     * Creates a TokenStream which tokenizes all the text in the provided Reader.
     *
     * @return  A TokenStream build from a StandardTokenizer filtered with
     * 			StandardFilter, StopFilter, GermanStemFilter and LowerCaseFilter.
     */
    public final TokenStream tokenStream(String fieldName, Reader reader) {
        TokenStream result = new StandardTokenizer(reader);
        result = new StandardFilter(result);
        result = new StopFilter(result, super.stopTable);
        result = new BrazilianStemFilter(result, super.excludeTable);
        // Convert to lowercase after stemming!
        result = new LowerCaseFilter(result);
        return result;
    }


	/* (non-Javadoc)
	 * @see fr.gouv.culture.sdx.search.lucene.analysis.AbstractAnalyzer#getAnalyserType()
	 */
	protected String getAnalyzerType() {
		return Analyzer_br.ANALYZER_TYPE;
	}
}
