/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.sdx.search.lucene.query;

import fr.gouv.culture.sdx.utils.AbstractSdxObject;

/**
 * Created by IntelliJ IDEA.
 * User: rpandey
 * Date: 25 mars 2004
 * Time: 11:32:13
 * To change this template use Options | File Templates.
 */
public abstract class AbstractResponse extends AbstractSdxObject {

    public static final int HPP_ALL_HITS = -1;
    /** The default number of documents to show per page. */
    public static final int HITS_PER_PAGE = 20;
    /** The maximum number of pages*/
    protected int _nbPages;
    /** The number of results to show per page. */
    protected int _hitsPerPage = HITS_PER_PAGE;//Defaulted
    /** The indices where the results come from. */
    protected SearchLocations _searchLocations;
    protected int _count = 0;


    public int getHitsPerPage() {
        return _hitsPerPage;
    }

    public int getNbPages() {
        return _nbPages;
    }

    public SearchLocations getSearchLocations() {
        return _searchLocations;
    }

    public int count() {
        return _count;
    }


    public void setSearchLocations(SearchLocations searchLocations) {
        _searchLocations = searchLocations;
    }

    public abstract int countPages();

    public void setHitsPerPage(int hpp) {
        _hitsPerPage = hpp;
    }

    protected void setNbPages(int nb) {
        _nbPages = nb;
    }

    public void setAllHits() {
        setHitsPerPage(HPP_ALL_HITS);
    }
    
    /* (non-Javadoc)
	 * @see fr.gouv.culture.sdx.utils.AbstractSdxObject#initToSax()
	 */
	protected boolean initToSax() {
		return true;
	}

	/**Init the LinkedHashMap _xmlizable_volatile_objects with the objects in order to describ them in XML
	 * Some objects need to be refresh each time a toSAX is called*/
	protected void initVolatileObjectsToSax() {
	
	}

}
