/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.utils.rdbms.hsql;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.utils.AbstractSdxObject;
import fr.gouv.culture.sdx.utils.Utilities;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;

public class HSQLDB
extends AbstractSdxObject {
    public static final String CLASS_NAME_SUFFIX = "HSQLDB";
    protected final String HSQLDB_DRIVER = "org.hsqldb.jdbcDriver";
    protected final String PROTOCOL_PREFIX = "jdbc:hsqldb:";
    protected String dbDirPath = null;
    protected Hashtable _registeredTableNames = new Hashtable();
    private Connection conn = null;

    public HSQLDB() throws ClassNotFoundException {
        Class.forName("org.hsqldb.jdbcDriver");
    }

    public void registerTableName(String tableName) throws SDXException {
        Utilities.isObjectUnique(this._registeredTableNames, tableName, null);
    }

    public void setDbDirPath(String dbDirPath) throws SDXException {
        this.dbDirPath = dbDirPath;
        this.getSQLConnection();
    }

    public String getDbDirPath() {
        return this.dbDirPath;
    }

    public synchronized Connection getSQLConnection() throws SDXException {
        if (this.conn != null) {
            return this.conn;
        }
        try {
            Connection conn;
            if (!Utilities.checkString(this.dbDirPath)) {
                throw new SQLException("the db directory path for this db instance is not set");
            }
            this.conn = conn = DriverManager.getConnection("jdbc:hsqldb:" + this.dbDirPath, "sa", "");
            return conn;
        }
        catch (SQLException e) {
            String[] args = new String[]{this.dbDirPath};
            throw new SDXException(super.getLog(), 113, args, e);
        }
    }

    protected void finalize() throws Throwable {
        if (this.conn != null) {
            this.conn.close();
        }
    }

    protected String getClassNameSuffix() {
        return CLASS_NAME_SUFFIX;
    }

    protected boolean initToSax() {
        this._xmlizable_objects.put("ID", this.getId());
        this._xmlizable_objects.put("Encoding", this.getEncoding());
        this._xmlizable_objects.put("XML-Lang", this.getXmlLang());
        return true;
    }

    protected void initVolatileObjectsToSax() {
    }
}

