/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.repository;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.repository.JDBCRepository;
import fr.gouv.culture.sdx.repository.JDBCRepositoryConnection;
import fr.gouv.culture.sdx.utils.configuration.ConfigurationUtils;
import fr.gouv.culture.sdx.utils.save.SaveParameters;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public class ORACLERepository
extends JDBCRepository {
    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        ConfigurationUtils.checkConfAttributeValue("dsi", this.dsi, configuration.getLocation());
    }

    protected String getTableCreationQuery() {
        return "CREATE TABLE " + this.getTableName() + " ( " + "id" + " VARCHAR(255) NOT NULL, " + "data" + " BLOB, PRIMARY KEY (" + "id" + "))";
    }

    protected String getEntriesWithLimitQuery(long offset, long number) {
        String query = "SELECT * FROM " + this.getTableName();
        query = query + " LIMIT " + String.valueOf(offset) + "," + String.valueOf(number) + ";";
        return query;
    }

    public void backup(SaveParameters save_config) throws SDXException {
        super.backup(save_config);
        if (save_config != null && save_config.getAttributeAsBoolean("all", false)) {
            save_config.setAttribute("type", "ORACLE");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init() throws SDXException {
        JDBCRepositoryConnection repoConn;
        block12: {
            Connection conn = null;
            ResultSet rs = null;
            repoConn = (JDBCRepositoryConnection)this.getConnection();
            try {
                try {
                    conn = repoConn.getConnection();
                    Statement st = conn.createStatement();
                    rs = st.executeQuery("SELECT id, data FROM " + this.getTableName() + " WHERE " + "id" + " = '_____'");
                }
                catch (SQLException e) {
                    this.createTable(conn);
                    Object var6_7 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e2) {
                            String[] args = new String[]{this.getId(), e2.getMessage()};
                            throw new SDXException(super.getLog(), 3200, args, e2);
                        }
                    }
                    if (repoConn == null) return;
                    repoConn.commit();
                    this.releaseConnection(repoConn);
                    return;
                }
                Object var6_6 = null;
                if (rs == null) break block12;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (rs != null) {
                    try {}
                    catch (SQLException e2) {
                        String[] args = new String[]{this.getId(), e2.getMessage()};
                        throw new SDXException(super.getLog(), 3200, args, e2);
                    }
                    rs.close();
                }
                if (repoConn == null) throw throwable;
                repoConn.commit();
                this.releaseConnection(repoConn);
                throw throwable;
            }
            try {}
            catch (SQLException e2) {
                String[] args = new String[]{this.getId(), e2.getMessage()};
                throw new SDXException(super.getLog(), 3200, args, e2);
            }
            rs.close();
        }
        if (repoConn == null) return;
        repoConn.commit();
        this.releaseConnection(repoConn);
    }

    public void restore(SaveParameters save_config) throws SDXException {
        super.restore(save_config);
    }
}

