/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.utils.xml;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.utils.SAXUtils;
import fr.gouv.culture.sdx.utils.SdxObject;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.configuration.ConfigurationUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.xml.AbstractXMLPipe;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.impl.FileSource;
import org.apache.excalibur.xml.sax.XMLizable;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class AbstractSdxXMLPipe
extends AbstractXMLPipe
implements SdxObject {
    protected transient Logger _logger = null;
    protected transient DefaultContext _context = null;
    protected transient ServiceManager _manager = null;
    protected transient Configuration _configuration = null;
    protected String _id = "";
    protected String _encoding = "UTF-8";
    protected Locale _locale = null;
    protected String _xmlLang = "";
    protected transient Source _description = null;
    protected transient HashMap _xmlizable_objects = new HashMap();
    protected boolean isToSaxInitialized = false;

    public void enableLogging(Logger logger) {
        this._logger = logger;
    }

    public void contextualize(Context context) throws ContextException {
        this._context = new DefaultContext(context);
    }

    public void service(ServiceManager serviceManager) throws ServiceException {
        ConfigurationUtils.checkServiceManager(serviceManager);
        this._manager = serviceManager;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        ConfigurationUtils.checkConfiguration(configuration);
        this.verifyConfigurationResources();
        this._configuration = configuration;
        try {
            this.setId(configuration.getAttribute("id", this.getId()));
        }
        catch (SDXException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)((Object)e));
        }
        this.setLocale(Utilities.buildLocale(configuration, null));
        this.setXmlLang(configuration.getAttribute("xml:lang", this.getXmlLang()));
        this.setEncoding(configuration.getAttribute("encoding", this._encoding));
        this.configureDescription(configuration);
    }

    protected void configureDescription(Configuration configuration) throws ConfigurationException {
        String l_descriptionSrc = configuration.getAttribute("description-src", null);
        if (!Utilities.checkString(l_descriptionSrc)) {
            return;
        }
        try {
            File l_descriptionFile = Utilities.resolveFile(null, configuration.getLocation(), (Context)this.getContext(), l_descriptionSrc, false);
            String l_descriptionUrl = l_descriptionFile.toURL().toExternalForm();
            this.setDescription((Source)new FileSource(l_descriptionUrl));
        }
        catch (SourceException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
        catch (SDXException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
    }

    public void setId(String id) throws SDXException {
        if (!Utilities.checkString(id)) {
            String[] args = new String[]{this.toString()};
            throw new SDXException(this.getLog(), 212, args, null);
        }
        this._id = id;
    }

    public void setDescription(Source description) {
        this._description = description;
    }

    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
    }

    public void setXmlLang(String lang) {
        this._xmlLang = lang;
    }

    public Logger getLog() {
        if (Utilities.checkString(this._id) && this._id.indexOf("..") == -1) {
            return this._logger.getChildLogger(this._id);
        }
        return this._logger;
    }

    protected DefaultContext getContext() {
        return this._context;
    }

    protected ServiceManager getServiceManager() {
        return this._manager;
    }

    protected Configuration getConfiguration() {
        return this._configuration;
    }

    public Locale getLocale() {
        return this._locale;
    }

    public String getId() {
        return this._id;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public Source getDescription() {
        return this._description;
    }

    public String getXmlLang() {
        if (Utilities.checkString(this._xmlLang)) {
            return this._xmlLang;
        }
        return this.getLocale().getLanguage();
    }

    protected Attributes getBaseAttributes() {
        AttributesImpl l_baseAtts = new AttributesImpl();
        l_baseAtts.addAttribute("http://www.w3.org/XML/1998/namespace", "xml:lang", "xml:lang", "CDATA", String.valueOf(this.getXmlLang()));
        l_baseAtts.addAttribute("", "id", "id", "CDATA", String.valueOf(this.getId()));
        l_baseAtts.addAttribute("", "locale", "locale", "CDATA", String.valueOf(this.getLocale()));
        l_baseAtts.addAttribute("", "encoding", "encoding", "CDATA", String.valueOf(this.getEncoding()));
        l_baseAtts.addAttribute("", "object", "object", "CDATA", String.valueOf(this));
        return l_baseAtts;
    }

    protected abstract String getClassNameSuffix();

    protected abstract boolean initToSax();

    protected abstract void initVolatileObjectsToSax();

    public void toSAX(ContentHandler contentHandler) throws SAXException {
        if (contentHandler == null) {
            return;
        }
        if (!this.isToSaxInitialized) {
            this.isToSaxInitialized = this.initToSax();
        }
        this.initVolatileObjectsToSax();
        try {
            String l_classNameSuffix = Utilities.getElementName(this.getClassNameSuffix());
            contentHandler.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", l_classNameSuffix, Utilities.prefixNodeNameSDX(l_classNameSuffix), this.getBaseAttributes());
            Iterator keys = this._xmlizable_objects.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Object l_xmlizable_object = this._xmlizable_objects.get(key);
                if (l_xmlizable_object instanceof XMLizable) {
                    ((XMLizable)l_xmlizable_object).toSAX(contentHandler);
                    continue;
                }
                if (l_xmlizable_object instanceof String) {
                    contentHandler.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", key, Utilities.prefixNodeNameSDX(key), new AttributesImpl());
                    SAXUtils.sendElementContent(contentHandler, (String)l_xmlizable_object);
                    contentHandler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", key, Utilities.prefixNodeNameSDX(key));
                    continue;
                }
                if (l_xmlizable_object instanceof Collection) {
                    Collection l_collection = (Collection)l_xmlizable_object;
                    Iterator l_xmlizable_values = l_collection.iterator();
                    contentHandler.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", key, Utilities.prefixNodeNameSDX(key), new AttributesImpl());
                    while (l_xmlizable_values.hasNext()) {
                        Object l_xmlizable_value = l_xmlizable_values.next();
                        if (l_xmlizable_value instanceof XMLizable) {
                            ((XMLizable)l_xmlizable_value).toSAX(contentHandler);
                            continue;
                        }
                        if (!(l_xmlizable_value instanceof String)) continue;
                        contentHandler.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", "value", Utilities.prefixNodeNameSDX("value"), new AttributesImpl());
                        SAXUtils.sendElementContent(contentHandler, (String)l_xmlizable_value);
                        contentHandler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "value", Utilities.prefixNodeNameSDX("value"));
                    }
                    contentHandler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", key, Utilities.prefixNodeNameSDX(key));
                    continue;
                }
                if (!(l_xmlizable_object instanceof Map)) continue;
                Map l_map = (Map)l_xmlizable_object;
                Iterator l_xmlizable_keys = l_map.keySet().iterator();
                contentHandler.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", key, Utilities.prefixNodeNameSDX(key), new AttributesImpl());
                while (l_xmlizable_keys.hasNext()) {
                    String l_mapKey = (String)l_xmlizable_keys.next();
                    Object l_xmlizable_value = l_map.get(l_mapKey);
                    if (l_xmlizable_value instanceof XMLizable) {
                        ((XMLizable)l_xmlizable_value).toSAX(contentHandler);
                        continue;
                    }
                    if (!(l_xmlizable_value instanceof String)) continue;
                    contentHandler.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", l_mapKey, Utilities.prefixNodeNameSDX(l_mapKey), new AttributesImpl());
                    SAXUtils.sendElementContent(contentHandler, (String)l_xmlizable_value);
                    contentHandler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", l_mapKey, Utilities.prefixNodeNameSDX(l_mapKey));
                }
                contentHandler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", key, Utilities.prefixNodeNameSDX(key));
            }
            if (this._description != null) {
                SourceUtil.toSAX((Source)this._description, (ContentHandler)contentHandler);
            }
            contentHandler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", l_classNameSuffix, Utilities.prefixNodeNameSDX(l_classNameSuffix));
        }
        catch (ProcessingException e) {
            throw new SAXException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    protected synchronized SdxObject setUpSdxObject(SdxObject sdxObj) throws ConfigurationException {
        SdxObject l_sdxObj = sdxObj;
        l_sdxObj = Utilities.setUpSdxObject(sdxObj, this.getLog(), Utilities.createNewReadOnlyContext((Context)this.getContext()), this.getServiceManager());
        l_sdxObj.setEncoding(this.getEncoding());
        l_sdxObj.setLocale(this.getLocale());
        l_sdxObj.setXmlLang(this.getXmlLang());
        return l_sdxObj;
    }

    protected synchronized SdxObject setUpSdxObject(SdxObject sdxObj, Configuration configuration) throws ConfigurationException {
        SdxObject l_sdxObj = sdxObj;
        l_sdxObj = this.setUpSdxObject(sdxObj);
        l_sdxObj.configure(configuration);
        return l_sdxObj;
    }

    protected void verifyConfigurationResources() throws ConfigurationException {
        try {
            ConfigurationUtils.checkLogger(this.getLog());
            ConfigurationUtils.checkContext((Context)this.getContext());
            ConfigurationUtils.checkServiceManager(this.getServiceManager());
        }
        catch (ContextException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
        catch (ServiceException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
    }
}

