/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.markup;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.language.markup.LogicsheetFilter;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.xml.xslt.XSLTProcessor;
import org.apache.excalibur.xml.xslt.XSLTProcessorException;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;

public class Logicsheet
extends AbstractLogEnabled {
    private SourceResolver resolver;
    private String systemId;
    protected Map namespaceURIs = null;
    private ServiceManager manager;
    private LogicsheetFilter filter;

    public Logicsheet(String systemId, ServiceManager manager, SourceResolver resolver, LogicsheetFilter filter) throws SAXException, IOException, SourceException, ProcessingException {
        this.systemId = systemId;
        this.manager = manager;
        this.resolver = resolver;
        this.filter = filter;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof Logicsheet)) {
            return false;
        }
        Logicsheet that = (Logicsheet)((Object)other);
        return this.systemId.equals(that.systemId);
    }

    public int hashCode() {
        return this.systemId.hashCode();
    }

    public String getSystemId() {
        return this.systemId;
    }

    public Map getNamespaceURIs() {
        return this.namespaceURIs;
    }

    public void fillNamespaceURIs() throws ProcessingException {
        this.getTransformerHandler();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TransformerHandler getTransformerHandler() throws ProcessingException {
        TransformerHandler transformerHandler;
        XSLTProcessor xsltProcessor = null;
        Source source = null;
        try {
            try {
                xsltProcessor = (XSLTProcessor)this.manager.lookup(XSLTProcessor.ROLE);
                source = this.resolver.resolveURI(this.systemId);
                if (this.namespaceURIs == null) {
                    this.namespaceURIs = new HashMap();
                }
                this.filter.setNamespaceMap(this.namespaceURIs);
                transformerHandler = xsltProcessor.getTransformerHandler(source, (XMLFilter)this.filter);
                Object var5_9 = null;
            }
            catch (ServiceException e) {
                throw new ProcessingException("Could not obtain XSLT processor", (Throwable)e);
            }
            catch (MalformedURLException e) {
                throw new ProcessingException("Could not resolve " + this.systemId, (Throwable)e);
            }
            catch (SourceException e) {
                throw SourceUtil.handle((String)("Could not resolve " + this.systemId), (SourceException)e);
            }
            catch (IOException e) {
                throw new ProcessingException("Could not resolve " + this.systemId, (Throwable)e);
            }
            catch (XSLTProcessorException e) {
                throw new ProcessingException("Could not transform " + this.systemId, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            this.manager.release((Object)xsltProcessor);
            this.resolver.release(source);
            throw throwable;
        }
        this.manager.release((Object)xsltProcessor);
        this.resolver.release(source);
        return transformerHandler;
    }
}

