/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.awt.color.ColorSpace;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOURIResolver;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactoryConfigurator;
import org.apache.fop.fo.ElementMapping;
import org.apache.fop.fo.ElementMappingRegistry;
import org.apache.fop.fonts.FontCache;
import org.apache.fop.hyphenation.HyphenationTreeResolver;
import org.apache.fop.image.ImageFactory;
import org.apache.fop.layoutmgr.LayoutManagerMaker;
import org.apache.fop.render.RendererFactory;
import org.apache.fop.render.XMLHandlerRegistry;
import org.apache.fop.util.ColorSpaceCache;
import org.apache.fop.util.ContentHandlerFactoryRegistry;
import org.xml.sax.SAXException;

public class FopFactory {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$fop$apps$FopFactory == null ? (class$org$apache$fop$apps$FopFactory = FopFactory.class$("org.apache.fop.apps.FopFactory")) : class$org$apache$fop$apps$FopFactory));
    private RendererFactory rendererFactory;
    private XMLHandlerRegistry xmlHandlers;
    private ElementMappingRegistry elementMappingRegistry;
    private ContentHandlerFactoryRegistry contentHandlerFactoryRegistry = new ContentHandlerFactoryRegistry();
    private HyphenationTreeResolver hyphResolver = null;
    private ColorSpaceCache colorSpaceCache = null;
    private ImageFactory imageFactory;
    private FopFactoryConfigurator config = new FopFactoryConfigurator(this);
    private String base = null;
    private String fontBase = null;
    private String hyphenBase = null;
    private boolean strictFOValidation = true;
    private boolean strictUserConfigValidation = true;
    private FontCache fontCache = null;
    private boolean enableBase14Kerning = false;
    private float sourceResolution = 72.0f;
    private float targetResolution = 72.0f;
    private String pageHeight = "11in";
    private String pageWidth = "8.26in";
    private boolean breakIndentInheritanceOnReferenceAreaBoundary = false;
    private LayoutManagerMaker lmMakerOverride = null;
    private Set ignoredNamespaces;
    private FOURIResolver foURIResolver;
    static /* synthetic */ Class class$org$apache$fop$apps$FopFactory;

    protected FopFactory() {
        this.elementMappingRegistry = new ElementMappingRegistry(this);
        this.foURIResolver = new FOURIResolver(this.validateUserConfigStrictly());
        this.colorSpaceCache = new ColorSpaceCache(this.foURIResolver);
        this.imageFactory = new ImageFactory();
        this.rendererFactory = new RendererFactory();
        this.xmlHandlers = new XMLHandlerRegistry();
        this.ignoredNamespaces = new HashSet();
        this.setUseCache(true);
    }

    public static FopFactory newInstance() {
        return new FopFactory();
    }

    public FOUserAgent newFOUserAgent() {
        FOUserAgent userAgent = new FOUserAgent(this);
        return userAgent;
    }

    public Fop newFop(String outputFormat) throws FOPException {
        return new Fop(outputFormat, this.newFOUserAgent());
    }

    public Fop newFop(String outputFormat, FOUserAgent userAgent) throws FOPException {
        if (userAgent == null) {
            throw new NullPointerException("The userAgent parameter must not be null!");
        }
        return new Fop(outputFormat, userAgent);
    }

    public Fop newFop(String outputFormat, OutputStream stream) throws FOPException {
        return new Fop(outputFormat, this.newFOUserAgent(), stream);
    }

    public Fop newFop(String outputFormat, FOUserAgent userAgent, OutputStream stream) throws FOPException {
        if (userAgent == null) {
            throw new NullPointerException("The userAgent parameter must not be null!");
        }
        return new Fop(outputFormat, userAgent, stream);
    }

    public Fop newFop(FOUserAgent userAgent) throws FOPException {
        if (userAgent.getRendererOverride() == null && userAgent.getFOEventHandlerOverride() == null) {
            throw new IllegalStateException("Either the overriding renderer or the overriding FOEventHandler must be set when this factory method is used!");
        }
        return this.newFop(null, userAgent);
    }

    public RendererFactory getRendererFactory() {
        return this.rendererFactory;
    }

    public XMLHandlerRegistry getXMLHandlerRegistry() {
        return this.xmlHandlers;
    }

    public ElementMappingRegistry getElementMappingRegistry() {
        return this.elementMappingRegistry;
    }

    public ContentHandlerFactoryRegistry getContentHandlerFactoryRegistry() {
        return this.contentHandlerFactoryRegistry;
    }

    public ImageFactory getImageFactory() {
        return this.imageFactory;
    }

    public void addElementMapping(ElementMapping elementMapping) {
        this.elementMappingRegistry.addElementMapping(elementMapping);
    }

    public void setLayoutManagerMakerOverride(LayoutManagerMaker lmMaker) {
        this.lmMakerOverride = lmMaker;
    }

    public LayoutManagerMaker getLayoutManagerMakerOverride() {
        return this.lmMakerOverride;
    }

    private String checkBaseURL(String base) throws MalformedURLException {
        if (!base.endsWith("/")) {
            base = base + "/";
        }
        File dir = new File(base);
        try {
            base = (dir.isDirectory() ? dir.toURL() : new URL(base)).toExternalForm();
        }
        catch (MalformedURLException mfue) {
            if (this.strictUserConfigValidation) {
                throw mfue;
            }
            log.error((Object)mfue.getMessage());
        }
        return base;
    }

    public void setBaseURL(String base) throws MalformedURLException {
        this.base = this.checkBaseURL(base);
    }

    public String getBaseURL() {
        return this.base;
    }

    public void setFontBaseURL(String fontBase) throws MalformedURLException {
        this.fontBase = this.checkBaseURL(fontBase);
    }

    public String getFontBaseURL() {
        return this.fontBase;
    }

    public String getHyphenBaseURL() {
        return this.hyphenBase;
    }

    public void setHyphenBaseURL(final String hyphenBase) throws MalformedURLException {
        if (hyphenBase != null) {
            this.setHyphenationTreeResolver(new HyphenationTreeResolver(){

                public Source resolve(String href) {
                    return FopFactory.this.resolveURI(href, hyphenBase);
                }
            });
        }
        this.hyphenBase = this.checkBaseURL(hyphenBase);
    }

    public void setURIResolver(URIResolver uriResolver) {
        this.foURIResolver.setCustomURIResolver(uriResolver);
    }

    public URIResolver getURIResolver() {
        return this.foURIResolver;
    }

    public HyphenationTreeResolver getHyphenationTreeResolver() {
        return this.hyphResolver;
    }

    public void setHyphenationTreeResolver(HyphenationTreeResolver hyphResolver) {
        this.hyphResolver = hyphResolver;
    }

    public void setStrictValidation(boolean validateStrictly) {
        this.strictFOValidation = validateStrictly;
    }

    public boolean validateStrictly() {
        return this.strictFOValidation;
    }

    public boolean isBreakIndentInheritanceOnReferenceAreaBoundary() {
        return this.breakIndentInheritanceOnReferenceAreaBoundary;
    }

    public void setBreakIndentInheritanceOnReferenceAreaBoundary(boolean value) {
        this.breakIndentInheritanceOnReferenceAreaBoundary = value;
    }

    public boolean isBase14KerningEnabled() {
        return this.enableBase14Kerning;
    }

    public void setBase14KerningEnabled(boolean value) {
        this.enableBase14Kerning = value;
    }

    public float getSourceResolution() {
        return this.sourceResolution;
    }

    public float getSourcePixelUnitToMillimeter() {
        return 25.4f / this.getSourceResolution();
    }

    public void setSourceResolution(float dpi) {
        this.sourceResolution = dpi;
        if (log.isDebugEnabled()) {
            log.debug((Object)("source-resolution set to: " + this.sourceResolution + "dpi (px2mm=" + this.getSourcePixelUnitToMillimeter() + ")"));
        }
    }

    public float getTargetResolution() {
        return this.targetResolution;
    }

    public float getTargetPixelUnitToMillimeter() {
        return 25.4f / this.targetResolution;
    }

    public void setTargetResolution(float dpi) {
        this.targetResolution = dpi;
    }

    public void setSourceResolution(int dpi) {
        this.setSourceResolution((float)dpi);
    }

    public String getPageHeight() {
        return this.pageHeight;
    }

    public void setPageHeight(String pageHeight) {
        this.pageHeight = pageHeight;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Default page-height set to: " + pageHeight));
        }
    }

    public String getPageWidth() {
        return this.pageWidth;
    }

    public void setPageWidth(String pageWidth) {
        this.pageWidth = pageWidth;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Default page-width set to: " + pageWidth));
        }
    }

    public void ignoreNamespace(String namespaceURI) {
        this.ignoredNamespaces.add(namespaceURI);
    }

    public void ignoreNamespaces(Collection namespaceURIs) {
        this.ignoredNamespaces.addAll(namespaceURIs);
    }

    public boolean isNamespaceIgnored(String namespaceURI) {
        return this.ignoredNamespaces.contains(namespaceURI);
    }

    public Set getIgnoredNamespace() {
        return Collections.unmodifiableSet(this.ignoredNamespaces);
    }

    public void setUserConfig(File userConfigFile) throws SAXException, IOException {
        this.config.setUserConfig(userConfigFile);
    }

    public void setUserConfig(String uri) throws SAXException, IOException {
        this.config.setUserConfig(uri);
    }

    public void setUserConfig(Configuration userConfig) throws FOPException {
        this.config.setUserConfig(userConfig);
    }

    public Configuration getUserConfig() {
        return this.config.getUserConfig();
    }

    public void setStrictUserConfigValidation(boolean strictUserConfigValidation) {
        this.strictUserConfigValidation = strictUserConfigValidation;
        this.foURIResolver.setThrowExceptions(strictUserConfigValidation);
    }

    public boolean validateUserConfigStrictly() {
        return this.strictUserConfigValidation;
    }

    public void setUseCache(boolean useCache) {
        if (useCache) {
            this.fontCache = FontCache.load();
            if (this.fontCache == null) {
                this.fontCache = new FontCache();
            }
        } else {
            this.fontCache = null;
        }
    }

    public boolean useCache() {
        return this.fontCache != null;
    }

    public FontCache getFontCache() {
        return this.fontCache;
    }

    public Source resolveURI(String href, String baseUri) {
        Source source = null;
        try {
            source = this.foURIResolver.resolve(href, baseUri);
        }
        catch (TransformerException e) {
            log.error((Object)("Attempt to resolve URI '" + href + "' failed: "), (Throwable)e);
        }
        return source;
    }

    public ColorSpace getColorSpace(String baseUri, String iccProfileSrc) {
        return this.colorSpaceCache.get(baseUri, iccProfileSrc);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

