/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.layout.renderer.aspect.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.cocoon.portal.layout.renderer.aspect.RendererAspect;

public final class RendererAspectChain {
    protected List aspects = new ArrayList(3);
    protected List configs = new ArrayList(3);
    protected List aspectDescriptions = new ArrayList(2);

    public void configure(ServiceSelector selector, Configuration conf) throws ConfigurationException {
        if (conf != null) {
            Configuration[] aspects = conf.getChildren("aspect");
            if (aspects != null) {
                int i = 0;
                while (i < aspects.length) {
                    Configuration current = aspects[i];
                    String role = current.getAttribute("type");
                    try {
                        RendererAspect rAspect = (RendererAspect)selector.select((Object)role);
                        this.aspects.add(rAspect);
                        Parameters aspectConfiguration = Parameters.fromConfiguration((Configuration)current);
                        Object compiledConf = rAspect.prepareConfiguration(aspectConfiguration);
                        this.configs.add(compiledConf);
                        Iterator descriptionIterator = rAspect.getAspectDescriptions(compiledConf);
                        if (descriptionIterator != null) {
                            while (descriptionIterator.hasNext()) {
                                this.aspectDescriptions.add(descriptionIterator.next());
                            }
                        }
                    }
                    catch (ParameterException pe) {
                        throw new ConfigurationException("Unable to configure renderer aspect " + role, (Throwable)pe);
                    }
                    catch (ServiceException se) {
                        throw new ConfigurationException("Unable to lookup aspect " + role, (Throwable)se);
                    }
                    ++i;
                }
            }
        } else {
            throw new ConfigurationException("No aspects configured");
        }
    }

    public Iterator getIterator() {
        return this.aspects.iterator();
    }

    public Iterator getConfigIterator() {
        return this.configs.iterator();
    }

    public Iterator getAspectDescriptionIterator() {
        return this.aspectDescriptions.iterator();
    }

    public void dispose(ServiceSelector selector) {
        Iterator i = this.aspects.iterator();
        while (i.hasNext()) {
            selector.release(i.next());
        }
        this.aspects.clear();
    }
}

