/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.pluto.om.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.pluto.om.common.Preference;
import org.apache.pluto.om.common.PreferenceCtrl;
import org.apache.pluto.util.StringUtils;

public class PreferenceImpl
implements Preference,
PreferenceCtrl,
Serializable {
    private static final String NULL_VALUE = "#*!0_NULL_0!*#";
    private static final String NULL_ARRAYENTRY = "#*!1_NULL_1!*#";
    private String name;
    private ArrayList value;
    private Boolean readOnly;

    public String getName() {
        return this.name;
    }

    public Iterator getValues() {
        if (this.value.contains(NULL_VALUE)) {
            return null;
        }
        ArrayList returnValue = new ArrayList(this.value.size());
        returnValue.addAll(this.value);
        int i = 0;
        while (i < returnValue.size()) {
            if (NULL_ARRAYENTRY.equals(returnValue.get(i))) {
                returnValue.set(i, null);
            }
            ++i;
        }
        return returnValue.iterator();
    }

    public boolean isReadOnly() {
        if (this.readOnly == null) {
            return false;
        }
        return this.readOnly;
    }

    public boolean isValueSet() {
        return this.value != null;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValues(Collection _value) {
        if (this.value == null) {
            this.value = new ArrayList();
        } else {
            this.value.clear();
        }
        ArrayList<String> addValue = null;
        if (_value == null) {
            addValue = new ArrayList<String>(1);
            addValue.add(NULL_VALUE);
        } else {
            addValue = new ArrayList(_value.size());
            addValue.addAll(_value);
            int i = 0;
            while (i < addValue.size()) {
                if (addValue.get(i) == null) {
                    addValue.set(i, NULL_ARRAYENTRY);
                }
                ++i;
            }
        }
        this.value.addAll(addValue);
    }

    public void setReadOnly(String readOnly) {
        this.readOnly = new Boolean(readOnly);
    }

    public String getReadOnly() {
        if (this.readOnly == null) {
            return Boolean.FALSE.toString();
        }
        return this.readOnly.toString();
    }

    public Collection getCastorValues() {
        return this.value;
    }

    public void setCastorValues(Collection _value) {
        if (this.value == null) {
            this.value = new ArrayList();
        } else {
            this.value.clear();
        }
        this.value.addAll(_value);
    }

    protected Collection getClonedCastorValuesAsCollection() {
        ArrayList<String> returnValue = new ArrayList<String>(this.value.size());
        Iterator iter = this.value.iterator();
        while (iter.hasNext()) {
            String value = (String)iter.next();
            returnValue.add(value);
        }
        return returnValue;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indent) {
        StringBuffer buffer = new StringBuffer(50);
        StringUtils.newLine((StringBuffer)buffer, (int)indent);
        buffer.append(this.getClass().toString());
        buffer.append(": name='");
        buffer.append(this.name);
        buffer.append("', value='");
        if (this.value == null) {
            buffer.append("null");
        } else {
            StringUtils.newLine((StringBuffer)buffer, (int)indent);
            buffer.append("{");
            Iterator iterator = this.value.iterator();
            if (iterator.hasNext()) {
                StringUtils.newLine((StringBuffer)buffer, (int)indent);
                buffer.append((String)iterator.next());
            }
            while (iterator.hasNext()) {
                StringUtils.indent((StringBuffer)buffer, (int)(indent + 2));
                buffer.append((String)iterator.next());
            }
            StringUtils.newLine((StringBuffer)buffer, (int)indent);
            buffer.append("}");
        }
        buffer.append("', isReadOnly='");
        buffer.append(this.isReadOnly());
        buffer.append("'");
        return buffer.toString();
    }
}

