/*
 * Decompiled with CFR 0.152.
 */
package net.sf.pizzacompiler.compiler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.sf.pizzacompiler.compiler.Basic;
import net.sf.pizzacompiler.compiler.ClassFileUtil;
import net.sf.pizzacompiler.compiler.ClassReader$$closures;
import net.sf.pizzacompiler.compiler.ClassSymbol;
import net.sf.pizzacompiler.compiler.Code;
import net.sf.pizzacompiler.compiler.ConstType;
import net.sf.pizzacompiler.compiler.Constants;
import net.sf.pizzacompiler.compiler.Continuations;
import net.sf.pizzacompiler.compiler.Convert;
import net.sf.pizzacompiler.compiler.DoubleConst;
import net.sf.pizzacompiler.compiler.FloatConst;
import net.sf.pizzacompiler.compiler.FunSymbol;
import net.sf.pizzacompiler.compiler.IntConst;
import net.sf.pizzacompiler.compiler.LongConst;
import net.sf.pizzacompiler.compiler.Mangle;
import net.sf.pizzacompiler.compiler.Name;
import net.sf.pizzacompiler.compiler.NameAndType;
import net.sf.pizzacompiler.compiler.PackageSymbol;
import net.sf.pizzacompiler.compiler.Report;
import net.sf.pizzacompiler.compiler.Scope;
import net.sf.pizzacompiler.compiler.StringConst;
import net.sf.pizzacompiler.compiler.Switches;
import net.sf.pizzacompiler.compiler.Symbol;
import net.sf.pizzacompiler.compiler.Type;
import net.sf.pizzacompiler.compiler.TypeSymbol;
import net.sf.pizzacompiler.compiler.VarSymbol;
import net.sf.pizzacompiler.compiler.ZipFileDirectory;
import net.sf.pizzacompiler.lang.List;
import net.sf.pizzacompiler.lang.ListBuffer;
import net.sf.pizzacompiler.util.Hashtable;
import pizza.support.ExceptionWrapper;
import pizza.support.ObjectArray;
import pizza.support.array;

public class ClassReader
extends ClassFileUtil
implements Constants {
    private static final String PATH_SEP = System.getProperty("path.separator");
    private static final Name pizzaLangCons = Name.fromString("pizza.lang.Cons");
    private static final Name pizzaUtilSome = Name.fromString("pizza.util.Some");
    private String classPath;
    public Hashtable classes = new Hashtable();
    public Hashtable packages = new Hashtable();
    private Scope locals;
    private ClassSymbol target;
    private boolean busy;
    private byte[] buf;
    private int bp;
    private Object[] poolObj;
    private int[] poolIdx;
    private byte[] signature;
    private int sigp;
    private int limit;
    static Hashtable dirs = new Hashtable();
    private static HashMap _zipFileDirectories = new HashMap();

    static void unrecogized(Name name) {
    }

    public ClassReader() {
        this(null, null);
    }

    public ClassReader(String string, String string2) {
        this.packages.net$sf$pizzacompiler$util$Hashtable$put(Symbol.emptyPackage.fullname, Symbol.emptyPackage);
        this.classes.net$sf$pizzacompiler$util$Hashtable$put(Symbol.predefClass.fullname, Symbol.predefClass);
        this.busy = false;
        if (string == null) {
            string = this.getDefaultUserClassPath();
        }
        if (string2 == null) {
            string2 = this.getDefaultBootClassPath();
        }
        this.setClassPath(string, string2);
    }

    private String getDefaultUserClassPath() {
        return System.getProperty("java.class.path");
    }

    private String getDefaultBootClassPath() {
        String string = System.getProperty("sun.boot.class.path");
        if (string == null) {
            string = System.getProperty("java.boot.class.path");
        }
        if (string == null) {
            string = System.getProperty("java.sys.class.path");
        }
        return string;
    }

    private void setClassPath(String string, String string2) {
        this.classPath = this.ensureEndsWithPathSep(string2);
        this.classPath = this.classPath == null ? (string == null ? "" : string) : (string == null ? this.classPath : String.valueOf(this.classPath).concat(String.valueOf(string)));
        this.classPath = this.ensureEndsWithPathSep(this.classPath);
    }

    private String ensureEndsWithPathSep(String string) {
        if (string != null && string.length() > 0 && !string.endsWith(PATH_SEP)) {
            return String.valueOf(string).concat(String.valueOf(PATH_SEP));
        }
        return string;
    }

    private char nextChar() {
        return (char)(((this.buf[this.bp++] & 0xFF) << 8) + (this.buf[this.bp++] & 0xFF));
    }

    private int nextInt() {
        return ((this.buf[this.bp++] & 0xFF) << 24) + ((this.buf[this.bp++] & 0xFF) << 16) + ((this.buf[this.bp++] & 0xFF) << 8) + (this.buf[this.bp++] & 0xFF);
    }

    private char getChar(int n) {
        return (char)(((this.buf[n] & 0xFF) << 8) + (this.buf[n + 1] & 0xFF));
    }

    private int getInt(int n) {
        return ((this.buf[n] & 0xFF) << 24) + ((this.buf[n + 1] & 0xFF) << 16) + ((this.buf[n + 2] & 0xFF) << 8) + (this.buf[n + 3] & 0xFF);
    }

    private long getLong(int n) {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.buf, n, 8));
        try {
            return dataInputStream.readLong();
        }
        catch (IOException iOException) {
            throw new InternalError();
        }
    }

    private float getFloat(int n) {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.buf, n, 4));
        try {
            return dataInputStream.readFloat();
        }
        catch (IOException iOException) {
            throw new InternalError("get");
        }
    }

    private double getDouble(int n) {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.buf, n, 8));
        try {
            return dataInputStream.readDouble();
        }
        catch (IOException iOException) {
            throw new InternalError("get");
        }
    }

    private void indexPool() {
        this.poolIdx = new int[this.nextChar()];
        this.poolObj = new Object[this.poolIdx.length];
        int n = 1;
        block6: while (n < this.poolIdx.length) {
            this.poolIdx[n++] = this.bp;
            byte by = this.buf[this.bp++];
            switch (by) {
                case 1: 
                case 2: {
                    char c = this.nextChar();
                    this.bp += c;
                    continue block6;
                }
                case 7: 
                case 8: {
                    this.bp += 2;
                    continue block6;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    this.bp += 4;
                    continue block6;
                }
                case 5: 
                case 6: {
                    this.bp += 8;
                    ++n;
                    continue block6;
                }
            }
            throw new RuntimeException(String.valueOf(String.valueOf(String.valueOf("bad constant pool tag: ").concat(String.valueOf(by))).concat(String.valueOf(" at "))).concat(String.valueOf(this.bp - 1)));
        }
    }

    private Object classOrType(Name name) {
        if (name.sub(0) == 91 || name.sub(name.len - 1) == 59) {
            byte[] byArray = name.toAscii();
            return this.sig2type(byArray, 0, byArray.length);
        }
        return this.enterClass(name);
    }

    private Object readPool(int n) {
        if (this.poolObj[n] != null) {
            return this.poolObj[n];
        }
        int n2 = this.poolIdx[n];
        if (n2 == 0) {
            return null;
        }
        byte by = this.buf[n2];
        switch (by) {
            case 1: {
                this.poolObj[n] = Name.fromAscii(this.buf, n2 + 3, this.getChar(n2 + 1));
                break;
            }
            case 2: {
                throw new RuntimeException("can't read unicode strings in class files");
            }
            case 7: {
                this.poolObj[n] = this.classOrType(this.readExternal(this.getChar(n2 + 1)));
                break;
            }
            case 8: {
                this.poolObj[n] = new StringConst((Name)this.readPool(this.getChar(n2 + 1)));
                break;
            }
            case 9: {
                ClassSymbol classSymbol = (ClassSymbol)this.readPool(this.getChar(n2 + 1));
                NameAndType nameAndType = (NameAndType)this.readPool(this.getChar(n2 + 3));
                this.poolObj[n] = new VarSymbol(0, nameAndType.name, this.sig2type(Name.names, nameAndType.sig.index, nameAndType.sig.len), classSymbol);
                break;
            }
            case 10: 
            case 11: {
                ClassSymbol classSymbol = (ClassSymbol)this.readPool(this.getChar(n2 + 1));
                NameAndType nameAndType = (NameAndType)this.readPool(this.getChar(n2 + 3));
                this.poolObj[n] = new FunSymbol(0, nameAndType.name, this.sig2type(Name.names, nameAndType.sig.index, nameAndType.sig.len), classSymbol);
                break;
            }
            case 12: {
                this.poolObj[n] = new NameAndType((Name)this.readPool(this.getChar(n2 + 1)), this.readExternal(this.getChar(n2 + 3)));
                break;
            }
            case 3: {
                this.poolObj[n] = new IntConst(this.getInt(n2 + 1));
                break;
            }
            case 4: {
                this.poolObj[n] = new FloatConst(this.getFloat(n2 + 1));
                break;
            }
            case 5: {
                this.poolObj[n] = new LongConst(this.getLong(n2 + 1));
                break;
            }
            case 6: {
                this.poolObj[n] = new DoubleConst(this.getDouble(n2 + 1));
                break;
            }
            default: {
                throw new RuntimeException(String.valueOf("bad constant pool tag: ").concat(String.valueOf(by)));
            }
        }
        return this.poolObj[n];
    }

    private Name readExternal(int n) {
        int n2;
        if (this.poolObj[n] == null && this.buf[n2 = this.poolIdx[n]] == 1) {
            char c = this.getChar(n2 + 1);
            byte[] byArray = ClassFileUtil.internalize(this.buf, n2 + 3, c);
            this.poolObj[n] = Name.fromAscii(byArray, 0, c);
        }
        return (Name)this.poolObj[n];
    }

    private void enterTypevars(Type.ClassType classType) {
        if (classType.outer() instanceof Type.ClassType) {
            this.enterTypevars((Type.ClassType)classType.outer());
        }
        Type[] typeArray = classType.args();
        for (int i = 0; i < typeArray.length; ++i) {
            this.locals.enter(typeArray[i].tsym());
        }
    }

    private Type sig2type(byte[] byArray, int n, int n2) {
        this.signature = byArray;
        this.sigp = n;
        this.limit = n + n2;
        return this.sig2type();
    }

    private Type.TypeVar[] sig2typevars(byte[] byArray, int n, int n2) {
        this.signature = byArray;
        this.sigp = n;
        this.limit = n + n2;
        return this.sig2typevars();
    }

    private Type sig2type() {
        switch (this.signature[this.sigp]) {
            case 65: {
                ++this.sigp;
                int n = this.sigp;
                while (this.signature[this.sigp] != 59) {
                    ++this.sigp;
                }
                ++this.sigp;
                return this.findTypeVar(Name.fromAscii(this.signature, n, this.sigp - 1 - n));
            }
            case 66: {
                ++this.sigp;
                return Type.byteType;
            }
            case 67: {
                ++this.sigp;
                return Type.charType;
            }
            case 68: {
                ++this.sigp;
                return Type.doubleType;
            }
            case 70: {
                ++this.sigp;
                return Type.floatType;
            }
            case 73: {
                ++this.sigp;
                return Type.intType;
            }
            case 74: {
                ++this.sigp;
                return Type.longType;
            }
            case 76: {
                Type type = this.classSig2type(Type.packageType);
                while (this.sigp < this.limit && this.signature[this.sigp] == 46) {
                    ++this.sigp;
                    type = this.classSig2type(type);
                }
                return type;
            }
            case 83: {
                ++this.sigp;
                return Type.shortType;
            }
            case 86: {
                ++this.sigp;
                return Type.voidType;
            }
            case 90: {
                ++this.sigp;
                return Type.booleanType;
            }
            case 91: {
                ++this.sigp;
                while (48 <= this.signature[this.sigp] && this.signature[this.sigp] <= 57) {
                    ++this.sigp;
                }
                return new Type.ArrayType(this.sig2type());
            }
            case 40: {
                Type[] typeArray = this.sig2types(')');
                List list = Type.emptyTypeList;
                if (this.sigp < this.limit && this.signature[this.sigp] == 60) {
                    list = List.fromArray(ObjectArray.make(this.sig2types('>')));
                }
                Type type = this.sig2type();
                return new Type.FunType(typeArray, type, list);
            }
            case 60: {
                this.locals = this.locals.dup();
                Type.TypeVar[] typeVarArray = this.sig2typevars();
                Type.ForAll forAll = new Type.ForAll(typeVarArray, this.sig2type());
                this.locals = this.locals.leave();
                return forAll;
            }
        }
        throw new RuntimeException(String.valueOf("bad signature: ").concat(String.valueOf(Convert.ascii2string(this.signature, this.sigp, 1))));
    }

    private Type classSig2type(Type type) {
        if (this.signature[this.sigp] == 76) {
            ++this.sigp;
            int n = this.sigp;
            while (this.signature[this.sigp] != 59) {
                ++this.sigp;
            }
            Type type2 = (Type.ClassType)this.enterClass((Name)Name.fromAscii((byte[])this.signature, (int)n, (int)(this.sigp - n))).type;
            ++this.sigp;
            if (this.sigp < this.limit && this.signature[this.sigp] == 60) {
                type2 = new Type.ClassType(this.sig2types('>'), null).setSym(type2.tsym());
            }
            type2.outer = type;
            return type2;
        }
        throw new RuntimeException(String.valueOf("bad class signature: ").concat(String.valueOf(Convert.ascii2string(this.signature, this.sigp, 10))));
    }

    private Type[] sig2types(char c) {
        ++this.sigp;
        return this.sig2types(c, 0);
    }

    private Type[] sig2types(char c, int n) {
        if (this.signature[this.sigp] == c) {
            ++this.sigp;
            return new Type[n];
        }
        Type type = this.sig2type();
        Type[] typeArray = this.sig2types(c, n + 1);
        typeArray[n] = type;
        return typeArray;
    }

    private Type.TypeVar sig2typevar() {
        int n = this.sigp;
        while (this.signature[this.sigp] != 44 && this.signature[this.sigp] != 60 && this.signature[this.sigp] != 62) {
            ++this.sigp;
        }
        Type.TypeVar typeVar = Type.makeTypeVar(Name.fromAscii(this.signature, n, this.sigp - n), this.target, true);
        this.locals.enter(typeVar.tsym());
        return typeVar;
    }

    private Type.TypeVar[] sig2typevars() {
        ++this.sigp;
        Type.TypeVar typeVar = this.sig2typevar();
        Type.TypeVar[] typeVarArray = this.sig2typevars(1);
        typeVarArray[0] = typeVar;
        int n = 0;
        while (this.signature[this.sigp] == 60) {
            typeVarArray[n].bounds = List.fromArray(ObjectArray.make(this.sig2types('>')));
            ++n;
        }
        Basic.assert(this.signature[this.sigp] == 62);
        ++this.sigp;
        return typeVarArray;
    }

    private Type.TypeVar[] sig2typevars(int n) {
        if (this.signature[this.sigp] == 44) {
            ++this.sigp;
            Type.TypeVar typeVar = this.sig2typevar();
            Type.TypeVar[] typeVarArray = this.sig2typevars(n + 1);
            typeVarArray[n] = typeVar;
            return typeVarArray;
        }
        return new Type.TypeVar[n];
    }

    private Type findTypeVar(Name name) {
        Symbol symbol = this.locals.lookup(name);
        while (symbol.scope != null) {
            if (symbol.sym.kind == 2) {
                return symbol.sym.type;
            }
            symbol = symbol.next();
        }
        throw new RuntimeException(String.valueOf("undeclared type variable: ").concat(String.valueOf(name)));
    }

    private Type readType(int n) {
        Name name = this.readExternal(n);
        return this.sig2type(Name.names, name.index, name.len);
    }

    private Code readCode(Symbol symbol) {
        Code code = new Code(false);
        code.max_stack = this.nextChar();
        code.max_locals = this.nextChar();
        code.cp = this.nextInt();
        code.code = new byte[code.cp];
        System.arraycopy(this.buf, this.bp, code.code, 0, code.cp);
        code.ncatches = this.nextChar();
        code.exc_start_pc = new char[code.ncatches];
        code.exc_end_pc = new char[code.ncatches];
        code.exc_handler_pc = new char[code.ncatches];
        code.exc_catch_type = new char[code.ncatches];
        for (int i = 0; i < code.ncatches; ++i) {
            code.exc_start_pc[i] = this.nextChar();
            code.exc_end_pc[i] = this.nextChar();
            code.exc_handler_pc[i] = this.nextChar();
            code.exc_catch_type[i] = this.nextChar();
        }
        int n = this.nextChar();
        for (int i = 0; i < n; ++i) {
            int n2;
            Name name = (Name)this.readPool(this.nextChar());
            int n3 = this.nextInt();
            if (name == ClassFileUtil.LineNumberTableS) {
                code.nlines = this.nextChar();
                code.line_start_pc = new char[code.nlines];
                code.line_number = new char[code.nlines];
                for (n2 = 0; n2 < code.nlines; ++n2) {
                    code.line_start_pc[n2] = this.nextChar();
                    code.line_number[n2] = this.nextChar();
                }
                continue;
            }
            if (name == ClassFileUtil.LocalVariableTableS) {
                code.nvars = this.nextChar();
                code.lvar_start_pc = new char[code.nvars];
                code.lvar_length = new char[code.nvars];
                code.lvar_reg = new char[code.nvars];
                code.lvar = new VarSymbol[code.nvars];
                for (n2 = 0; n2 < code.nvars; ++n2) {
                    code.lvar_start_pc[n2] = this.nextChar();
                    code.lvar_length[n2] = this.nextChar();
                    code.lvar[n2] = new VarSymbol(0, (Name)this.readPool(this.nextChar()), this.readType(this.nextChar()), symbol);
                    code.lvar_reg[n2] = this.nextChar();
                    code.lvar[n2].adr = code.lvar_reg[n2];
                }
                continue;
            }
            ClassReader.unrecogized(name);
            this.bp += n3;
        }
        return code;
    }

    private Name readClassName(int n) {
        return ((ClassSymbol)this.readPool((int)n)).fullname;
    }

    private VarSymbol readField() {
        char c = this.nextChar();
        Name name = (Name)this.readPool(this.nextChar());
        Type type = this.readType(this.nextChar());
        VarSymbol varSymbol = new VarSymbol(c, name, type, this.target);
        int n = this.nextChar();
        for (int i = 0; i < n; ++i) {
            Name name2 = (Name)this.readPool(this.nextChar());
            int n2 = this.nextInt();
            if (name2 == ClassFileUtil.ConstantValueS) {
                ConstType constType = (ConstType)this.readPool(this.nextChar());
                varSymbol.type = (Type)((Object)constType.coerce(varSymbol.type.tag()));
                continue;
            }
            if (name2 == ClassFileUtil.PizzaCaseS) {
                varSymbol.modifiers |= 0x40000;
                varSymbol.setCaseNum(this.nextChar());
                continue;
            }
            if (name2 == ClassFileUtil.SyntheticS) {
                varSymbol.modifiers |= 0x10000;
                continue;
            }
            if (name2 == ClassFileUtil.DeprecatedS) {
                varSymbol.modifiers |= 0x20000;
                continue;
            }
            ClassReader.unrecogized(name2);
            this.bp += n2;
        }
        return varSymbol;
    }

    private FunSymbol readMethod() {
        char c = this.nextChar();
        Name name = (Name)this.readPool(this.nextChar());
        Type type = this.readType(this.nextChar());
        FunSymbol funSymbol = new FunSymbol(c, name, type, this.target);
        int n = this.nextChar();
        for (int i = 0; i < n; ++i) {
            Name name2 = (Name)this.readPool(this.nextChar());
            int n2 = this.nextInt();
            if (name2 == ClassFileUtil.CodeS) {
                this.bp += n2;
                continue;
            }
            if (name2 == ClassFileUtil.ExceptionsS) {
                int n3 = this.nextChar();
                List list = Type.emptyTypeList;
                for (int j = 0; j < n3; ++j) {
                    list = List.Cons(this.enterClass((Name)this.readClassName((int)this.nextChar())).type, list);
                }
                type.funtype().thrown = list;
                continue;
            }
            if (name2 == ClassFileUtil.PizzaCaseS) {
                funSymbol.modifiers |= 0x40000;
                funSymbol.setCaseNum(this.nextChar());
                continue;
            }
            if (name2 == ClassFileUtil.SyntheticS) {
                funSymbol.modifiers |= 0x10000;
                continue;
            }
            if (name2 == ClassFileUtil.DeprecatedS) {
                funSymbol.modifiers |= 0x20000;
                continue;
            }
            ClassReader.unrecogized(name2);
            this.bp += n2;
        }
        return funSymbol;
    }

    void readClass(ClassSymbol classSymbol) {
        boolean bl = false;
        this.locals = new Scope(null, classSymbol);
        classSymbol.setLocals(this.locals);
        this.target = classSymbol;
        if (Switches.pizza) {
            char c;
            if (classSymbol.type.outer() instanceof Type.ClassType) {
                this.enterTypevars((Type.ClassType)classSymbol.type.outer());
            }
            if ((c = this.nextChar()) != '\u0000') {
                Name name = this.readExternal(c);
                ((Type.ClassType)classSymbol.type).args = this.sig2typevars(Name.names, name.index, name.len);
            }
        }
        classSymbol.modifiers = this.nextChar();
        Name name = this.readClassName(this.nextChar());
        if (classSymbol.fullname != name) {
            throw new RuntimeException(String.valueOf(String.valueOf(String.valueOf("class file: ").concat(String.valueOf(classSymbol.fullname))).concat(String.valueOf(" contains wrong class: "))).concat(String.valueOf(name)));
        }
        char c = this.nextChar();
        classSymbol.setSupertype(c == '\u0000' ? null : (Switches.pizza ? this.readType(c) : this.enterClass((Name)this.readClassName((int)c)).type));
        Type[] typeArray = new Type[this.nextChar()];
        classSymbol.setInterfaces(typeArray);
        for (int i = 0; i < typeArray.length; ++i) {
            typeArray[i] = Switches.pizza ? this.readType(this.nextChar()) : this.enterClass((Name)this.readClassName((int)this.nextChar())).type;
        }
        int n = this.nextChar();
        for (int i = 0; i < n; ++i) {
            this.locals.enter(this.readField());
        }
        int n2 = this.nextChar();
        for (int i = 0; i < n2; ++i) {
            FunSymbol funSymbol = this.readMethod();
            this.locals.enter(funSymbol);
            if ((funSymbol.modifiers & 0x200000) == 0) continue;
            this.locals.enter(Continuations.makeStepFun(funSymbol));
        }
        int n3 = this.nextChar();
        for (int i = 0; i < n3; ++i) {
            Name name2 = (Name)this.readPool(this.nextChar());
            int n4 = this.nextInt();
            if (name2 == ClassFileUtil.SourceFileS) {
                classSymbol.sourcefile = (Name)this.readPool(this.nextChar());
                continue;
            }
            if (name2 == ClassFileUtil.PizzaS) {
                bl = true;
                Switches.pizza = true;
                this.readClass(classSymbol);
                continue;
            }
            if (name2 == ClassFileUtil.InnerClassesS) {
                this.readInnerClasses(classSymbol);
                continue;
            }
            if (name2 == ClassFileUtil.PizzaCaseS) {
                classSymbol.setCaseNum(this.nextChar());
                continue;
            }
            if (name2 == ClassFileUtil.SyntheticS) {
                classSymbol.modifiers |= 0x10000;
                continue;
            }
            if (name2 == ClassFileUtil.DeprecatedS) {
                classSymbol.modifiers |= 0x20000;
                continue;
            }
            ClassReader.unrecogized(name2);
            this.bp += n4;
        }
        if (!Switches.pizza && !bl) {
            classSymbol.supertype_p = classSymbol.supertype_j;
            classSymbol.interfaces_p = classSymbol.interfaces_j;
            classSymbol.locals_p = classSymbol.locals_j;
        }
    }

    void readInnerClasses(ClassSymbol classSymbol) {
        int n = this.nextChar();
        for (int i = 0; i < n; ++i) {
            ClassSymbol classSymbol2 = (ClassSymbol)this.readPool(this.nextChar());
            ClassSymbol classSymbol3 = (ClassSymbol)this.readPool(this.nextChar());
            Name name = (Name)this.readPool(this.nextChar());
            if (name == null) {
                name = Name.fromString("");
            }
            char c = this.nextChar();
            Mangle.mangled.net$sf$pizzacompiler$util$Hashtable$put(classSymbol2.fullname, new Mangle(classSymbol3, name, c));
            if (classSymbol3 != classSymbol) continue;
            classSymbol.locals_j.enterIfAbsent(classSymbol2.proxy(name));
            if (classSymbol.locals_p != null) {
                classSymbol.locals_p.enterIfAbsent(classSymbol2.proxy(name));
            }
            classSymbol2.owner = classSymbol;
            if (!classSymbol2.isInner()) continue;
            ((Type.ClassType)classSymbol2.type).outer = classSymbol.type;
        }
    }

    void readClassFile(ClassSymbol classSymbol) throws IOException {
        try {
            int n = this.nextInt();
            if (n != -889275714) {
                throw new RuntimeException("illegal start of class file");
            }
            char c = this.nextChar();
            char c2 = this.nextChar();
            if (c2 <= '-' && (c2 != '-' || c < '\u0003')) {
                throw new RuntimeException(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("class file has wrong version ").concat(String.valueOf((int)c2))).concat(String.valueOf("."))).concat(String.valueOf((int)c))).concat(String.valueOf(", should at least be "))).concat(String.valueOf(45))).concat(String.valueOf("."))).concat(String.valueOf(3)));
            }
            this.indexPool();
            boolean bl = Switches.pizza;
            Switches.pizza = false;
            this.readClass(classSymbol);
            Mangle mangle = (Mangle)Mangle.mangled.net$sf$pizzacompiler$util$Hashtable$get(classSymbol.fullname);
            if (mangle != null) {
                classSymbol.modifiers = mangle.mods | classSymbol.modifiers & 0xFFC00000;
            }
            Switches.pizza = bl;
        }
        catch (RuntimeException runtimeException) {
            throw new IOException(String.valueOf(String.valueOf("bad class file (").concat(String.valueOf(runtimeException))).concat(String.valueOf(")")));
        }
    }

    private static boolean isZip(String string) {
        return string.endsWith(".zip") || string.endsWith(".jar");
    }

    static ZipFile openDir(String string) throws IOException {
        ZipFile zipFile = (ZipFile)dirs.net$sf$pizzacompiler$util$Hashtable$get(string);
        if (zipFile == null) {
            zipFile = new ZipFile(string);
            dirs.net$sf$pizzacompiler$util$Hashtable$put(string, zipFile);
        }
        return zipFile;
    }

    private InputStream openFile(String string, String string2) {
        block6: {
            Object var3_3 = null;
            try {
                if (ClassReader.isZip(string)) {
                    ZipFile zipFile = ClassReader.openDir(string);
                    ZipEntry zipEntry = zipFile.getEntry(string2.replace('\\', '/'));
                    if (zipEntry != null) {
                        if (Switches.verbose) {
                            Report.message(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("[loading ").concat(String.valueOf(zipFile.getName()))).concat(String.valueOf("("))).concat(String.valueOf(zipEntry.toString()))).concat(String.valueOf(")"))).concat(String.valueOf("]")));
                        }
                        return zipFile.getInputStream(zipEntry);
                    }
                    break block6;
                }
                File file = new File(string, string2);
                if (Switches.verbose) {
                    Report.message(String.valueOf(String.valueOf("[loading ").concat(String.valueOf(file.toString()))).concat(String.valueOf("]")));
                }
                return new FileInputStream(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    protected InputStream find(String string) {
        if (Switches.printSearch) {
            Report.message(String.valueOf("looking for ").concat(String.valueOf(string)));
        }
        int n = 0;
        InputStream inputStream = null;
        while (n < this.classPath.length() && inputStream == null) {
            int n2 = this.classPath.indexOf(PATH_SEP, n);
            String string2 = this.classPath.substring(n, n2);
            if (Switches.printSearch) {
                Report.message(String.valueOf(" in ").concat(String.valueOf(string2)));
            }
            inputStream = this.openFile(string2, string);
            n = n2 + 1;
        }
        return inputStream;
    }

    private static String[] list(String string, String string2) {
        try {
            if (ClassReader.isZip(string)) {
                return ClassReader.listFromZip(string, string2);
            }
            File file = string2.length() != 0 ? new File(string, string2) : new File(string);
            return file.list();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static String[] listFromZip(String string, String string2) throws IOException {
        ZipFileDirectory zipFileDirectory;
        ListBuffer listBuffer = new ListBuffer();
        SoftReference softReference = (SoftReference)_zipFileDirectories.get(string);
        ZipFileDirectory zipFileDirectory2 = zipFileDirectory = softReference == null ? null : (ZipFileDirectory)softReference.get();
        if (zipFileDirectory == null) {
            ZipFile zipFile = ClassReader.openDir(string);
            zipFileDirectory = new ZipFileDirectory(zipFile);
            _zipFileDirectories.put(string, new SoftReference<ZipFileDirectory>(zipFileDirectory));
        }
        return zipFileDirectory.listFiles(string2);
    }

    static void checkNotIn(TypeSymbol typeSymbol, Hashtable hashtable) throws IOException {
        if (hashtable.net$sf$pizzacompiler$util$Hashtable$get(typeSymbol.fullname) != null) {
            throw new IOException(String.valueOf("package and class with same name: ").concat(String.valueOf(typeSymbol.fullname)));
        }
    }

    ClassSymbol enterClass(Name name) {
        ClassSymbol classSymbol = (ClassSymbol)this.classes.net$sf$pizzacompiler$util$Hashtable$get(name);
        if (classSymbol == null) {
            if (name == pizzaLangCons || name == pizzaUtilSome) {
                Report.message(String.valueOf(String.valueOf("WARNING - you seem to have an outdated class file: ").concat(String.valueOf(name))).concat(String.valueOf(".class; please delete and recompile")));
            }
            classSymbol = new ClassSymbol(0, Basic.shortName(name), this.enterPackage(Basic.packagePart(name)), new ClassReader$$closures(this, 0, null));
            this.classes.net$sf$pizzacompiler$util$Hashtable$put(name, classSymbol);
        }
        return classSymbol;
    }

    private void completeClass(ClassSymbol classSymbol) throws IOException {
        Basic.assert(!this.busy);
        try {
            this.busy = true;
            String string = String.valueOf(ClassFileUtil.externalizeFileName(classSymbol.fullname)).concat(String.valueOf(".class"));
            InputStream inputStream = this.find(string);
            if (inputStream == null) {
                throw new IOException(String.valueOf(String.valueOf("file ").concat(String.valueOf(string))).concat(String.valueOf(" not found")));
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.buf = new byte[inputStream.available()];
            try {
                int n;
                while ((n = inputStream.read(this.buf)) != -1) {
                    byteArrayOutputStream.write(this.buf, 0, n);
                }
                this.buf = byteArrayOutputStream.toByteArray();
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            this.bp = 0;
            this.readClassFile(classSymbol);
            this.busy = false;
            Symbol symbol = classSymbol.locals_j.elems;
            while (symbol != null) {
                if (symbol.sym.kind == 2) {
                    ((ClassSymbol)symbol.sym).complete();
                }
                symbol = symbol.sibling;
            }
            Object var9_10 = null;
            this.busy = false;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this.busy = false;
            throw throwable;
        }
    }

    public ClassSymbol loadClass(Name name) throws IOException {
        boolean bl;
        ClassSymbol classSymbol = (ClassSymbol)this.classes.net$sf$pizzacompiler$util$Hashtable$get(name);
        boolean bl2 = bl = classSymbol == null;
        if (bl) {
            classSymbol = this.enterClass(name);
        }
        if (classSymbol.needsCompletion()) {
            try {
                classSymbol.complete();
                ClassReader.checkNotIn(classSymbol, this.packages);
            }
            catch (IOException iOException) {
                if (bl) {
                    this.classes.net$sf$pizzacompiler$util$Hashtable$remove(classSymbol.fullname);
                }
                throw iOException;
            }
            this.busy = false;
        }
        return classSymbol;
    }

    public PackageSymbol enterPackage(Name name) {
        PackageSymbol packageSymbol = (PackageSymbol)this.packages.net$sf$pizzacompiler$util$Hashtable$get(name);
        if (packageSymbol == null) {
            packageSymbol = new PackageSymbol(Basic.shortName(name), new Type.PackageType(), this.enterPackage(Basic.packagePart(name)));
            this.packages.net$sf$pizzacompiler$util$Hashtable$put(name, packageSymbol);
        }
        return packageSymbol;
    }

    public PackageSymbol loadPackage(Name name) throws IOException {
        PackageSymbol packageSymbol = (PackageSymbol)this.packages.net$sf$pizzacompiler$util$Hashtable$get(name);
        if (packageSymbol == null) {
            packageSymbol = this.enterPackage(name);
            ClassReader.checkNotIn(packageSymbol, this.classes);
        }
        return packageSymbol;
    }

    private void includeClassFiles(String[] stringArray, PackageSymbol packageSymbol) {
        if (stringArray != null) {
            if (packageSymbol.locals == null) {
                packageSymbol.locals = new Scope(null, packageSymbol);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                Name name;
                Name name2;
                if (!stringArray[i].endsWith(".class") || (name2 = Symbol.formFullName(name = Name.fromString(stringArray[i].substring(0, stringArray[i].length() - 6)), packageSymbol)) == pizzaLangCons || name2 == pizzaUtilSome) continue;
                packageSymbol.locals.enterIfAbsent(this.enterClass(name2));
            }
        }
    }

    protected Scope directory(PackageSymbol packageSymbol) {
        if (packageSymbol.locals != null) {
            return packageSymbol.locals;
        }
        String string = ClassFileUtil.externalizeFileName(packageSymbol.fullname);
        this.includeClassFiles(this.getFilesForPackage(this.classPath, string), packageSymbol);
        Scope scope = packageSymbol.locals;
        if (packageSymbol.locals == null) {
            packageSymbol.locals = new Scope(null, packageSymbol);
        }
        return scope;
    }

    protected String[] getFilesForPackage(String string, String string2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < string.length()) {
            int n2 = string.indexOf(PATH_SEP, n);
            n2 = n2 == -1 ? string.length() : n2;
            String string3 = string.substring(n, n2);
            String[] stringArray = ClassReader.list(string3, string2);
            if (stringArray != null) {
                arrayList.addAll(Arrays.asList((Object[])array.asObject(stringArray)));
            }
            n = n2 + 1;
        }
        return (String[])array.asObject(arrayList.toArray((Object[])array.asObject(new String[0])));
    }

    /* synthetic */ void $closure$net$sf$pizzacompiler$compiler$ClassReader$0d(ClassSymbol classSymbol, Object[] objectArray) {
        try {
            this.completeClass(classSymbol);
        }
        catch (IOException iOException) {
            throw new ExceptionWrapper(iOException);
        }
    }
}

