/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.manager.http.server;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.excalibur.instrument.CounterInstrument;
import org.apache.excalibur.instrument.Instrument;
import org.apache.excalibur.instrument.manager.http.server.AbstractSocketServer;
import org.apache.excalibur.instrument.manager.http.server.HTTPRedirect;
import org.apache.excalibur.instrument.manager.http.server.HTTPURLHandler;
import org.apache.excalibur.instrument.manager.http.server.URLCoder;

public class HTTPServer
extends AbstractSocketServer {
    private List m_handlers = new ArrayList();
    private HTTPURLHandler[] m_handlerArray;
    private String m_accessLogFile;
    private File m_currentLogFile;
    private PrintWriter m_currentLogWriter;
    private SimpleDateFormat m_dayFormat = new SimpleDateFormat("yyyy-MM-dd");
    private SimpleDateFormat m_logTimeFormat = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss Z", Locale.US);
    private CounterInstrument m_instrumentRequests = new CounterInstrument("requests");
    private CounterInstrument m_instrumentResponseBytes;
    private CounterInstrument m_instrumentRequestBytes;

    public HTTPServer(int port, InetAddress bindAddress) {
        super(port, bindAddress);
        this.addInstrument((Instrument)this.m_instrumentRequests);
        this.m_instrumentResponseBytes = new CounterInstrument("response-bytes");
        this.addInstrument((Instrument)this.m_instrumentResponseBytes);
        this.m_instrumentRequestBytes = new CounterInstrument("request-bytes");
        this.addInstrument((Instrument)this.m_instrumentRequestBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        super.stop();
        HTTPServer hTTPServer = this;
        synchronized (hTTPServer) {
            if (this.m_currentLogWriter != null) {
                this.m_currentLogWriter.close();
                this.m_currentLogWriter = null;
                this.m_currentLogFile = null;
            }
        }
    }

    protected void handleSocket(Socket socket) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("handleSocket( " + socket + " ) BEGIN : " + Thread.currentThread().getName());
        }
        String ip = socket.getInetAddress().getHostAddress();
        try {
            while (this.handleRequest(socket.getInputStream(), socket.getOutputStream(), ip) && !this.isStopping()) {
            }
        }
        catch (InterruptedIOException e) {
        }
        catch (SocketException e) {
        }
        catch (Throwable e) {
            this.getLogger().debug("Encountered an error processing the request.", e);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("handleSocket( " + socket + " ) END : " + Thread.currentThread().getName());
        }
    }

    public void setAccessLogFile(String accessLogFile) {
        this.m_accessLogFile = accessLogFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerHandler(HTTPURLHandler handler) {
        List list = this.m_handlers;
        synchronized (list) {
            this.m_handlers.add(handler);
            this.m_handlerArray = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logAccessEvent(String ip, String method, String url, int errorCode, int contentLength, String referrer, String userAgent) {
        if (this.m_accessLogFile == null) {
            return;
        }
        Date now = new Date();
        HTTPServer hTTPServer = this;
        synchronized (hTTPServer) {
            File file;
            StringBuffer sb;
            int datePos = this.m_accessLogFile.indexOf("yyyy_mm_dd");
            if (datePos >= 0) {
                sb = new StringBuffer();
                if (datePos > 0) {
                    sb.append(this.m_accessLogFile.substring(0, datePos));
                }
                sb.append(this.m_dayFormat.format(now));
                if (datePos + 10 < this.m_accessLogFile.length()) {
                    sb.append(this.m_accessLogFile.substring(datePos + 10));
                }
                file = new File(sb.toString());
            } else {
                file = new File(this.m_accessLogFile);
            }
            if (this.m_currentLogFile == null || !this.m_currentLogFile.equals(file)) {
                if (this.m_currentLogWriter != null) {
                    this.m_currentLogWriter.close();
                }
                try {
                    this.m_currentLogWriter = new PrintWriter(new FileWriter(file));
                    this.m_currentLogFile = file;
                }
                catch (IOException e) {
                    this.getLogger().warn("Unable to open: " + this.m_currentLogFile);
                    this.m_currentLogWriter = null;
                    this.m_currentLogFile = null;
                    return;
                }
            }
            sb = new StringBuffer();
            sb.append(ip);
            sb.append(" - - [");
            sb.append(this.m_logTimeFormat.format(now));
            sb.append("] \"");
            sb.append(method);
            sb.append(" ");
            sb.append(url);
            sb.append("\" ");
            sb.append(errorCode);
            sb.append(" ");
            sb.append(contentLength);
            sb.append(" \"");
            sb.append(referrer);
            sb.append("\" \"");
            sb.append(userAgent);
            sb.append("\"");
            this.m_currentLogWriter.println(sb.toString());
            this.m_currentLogWriter.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleRequest(InputStream is, OutputStream os, String ip) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(is));
        String request = r.readLine();
        if (request == null) {
            return false;
        }
        String referrer = "-";
        String userAgent = "-";
        String host = null;
        int requestBytes = request.getBytes().length + 1;
        try {
            String header;
            do {
                header = r.readLine();
                this.getLogger().debug("Header: " + header);
                if (header == null) continue;
                if (header.startsWith("User-Agent: ")) {
                    userAgent = header.substring(12);
                } else if (header.startsWith("Referer: ")) {
                    referrer = header.substring(9);
                } else if (header.startsWith("Host: ")) {
                    host = header.substring(6);
                }
                requestBytes += header.getBytes().length + 1;
            } while (header != null && header.length() > 0);
        }
        finally {
            if (requestBytes > 0) {
                this.m_instrumentRequestBytes.increment(requestBytes);
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("got request: " + request + " : " + Thread.currentThread().getName());
        }
        Throwable error = null;
        ByteArrayOutputStream hbos = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(hbos);
        String method = "ERROR";
        String url = "";
        StringTokenizer st = new StringTokenizer(request, " ");
        if (st.countTokens() == 3) {
            method = st.nextToken();
            url = st.nextToken();
            String version = st.nextToken();
            if (method.equals("GET") && version.startsWith("HTTP/")) {
                String path;
                String query = null;
                int pos = url.indexOf(63);
                if (pos > 0) {
                    path = url.substring(0, pos);
                    if (pos < url.length() - 1) {
                        query = url.substring(pos + 1);
                    }
                } else {
                    path = url;
                }
                HTTPURLHandler[] handlers = this.getHandlers();
                for (int i = 0; i < handlers.length; ++i) {
                    boolean ok;
                    HTTPURLHandler handler = handlers[i];
                    if (!path.startsWith(handler.getPath())) continue;
                    HashMap params = new HashMap();
                    if (query != null) {
                        this.decodeQuery(params, query, handler.getEncoding());
                    }
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Request Path: " + path);
                        this.getLogger().debug("  Parameters: " + ((Object)params).toString());
                    }
                    this.m_instrumentRequests.increment();
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    try {
                        handler.handleRequest(path, params, bos);
                        ok = true;
                    }
                    catch (HTTPRedirect e) {
                        String redirectPath = e.getPath();
                        if (host != null && redirectPath.indexOf("://") < 0) {
                            StringBuffer sb = new StringBuffer();
                            sb.append("http://");
                            sb.append(host);
                            if (redirectPath.startsWith(".")) {
                                int slashPos = path.lastIndexOf(47);
                                String subpath = slashPos > 0 ? path.substring(0, slashPos + 1) : "/";
                                sb.append(subpath);
                            } else if (!redirectPath.startsWith("/")) {
                                sb.append("/");
                            }
                            sb.append(redirectPath);
                            redirectPath = sb.toString();
                        }
                        if (this.getLogger().isDebugEnabled()) {
                            if (redirectPath.equals(e.getPath())) {
                                this.getLogger().debug("Redirect to: " + redirectPath);
                            } else {
                                this.getLogger().debug("Redirect to: " + e.getPath() + " -> " + redirectPath);
                            }
                        }
                        byte[] contents = ("<html><head><title>302 Found</title></head><body>The document has moved <a href='" + redirectPath + "'>here</a>" + "</body></html>").getBytes(handler.getEncoding());
                        out.println("HTTP/1.1 302 Found");
                        out.println("Date: " + new Date());
                        out.println("Server: Avalon Instrument Manager HTTP Connector");
                        out.println("Content-Length: " + contents.length);
                        out.println("Location: " + redirectPath);
                        out.println("Keep-Alive: timeout=" + this.getSoTimeout() / 1000);
                        out.println("Connection: Keep-Alive");
                        out.println("Content-Type: " + handler.getContentType());
                        out.println("Pragma: no-cache");
                        out.println("Expires: Thu, 01 Jan 1970 00:00:00 GMT");
                        out.println("Cache-Control: no-cache");
                        out.println("");
                        out.flush();
                        byte[] responseBytes = hbos.toByteArray();
                        os.write(responseBytes);
                        os.write(contents, 0, contents.length);
                        os.flush();
                        this.m_instrumentResponseBytes.increment(responseBytes.length + contents.length);
                        this.logAccessEvent(ip, method, url, 302, contents.length, referrer, userAgent);
                        return true;
                    }
                    catch (Throwable t) {
                        error = t;
                        ok = false;
                    }
                    if (!ok) break;
                    byte[] contents = bos.toByteArray();
                    out.println("HTTP/1.1 200 OK");
                    out.println("Date: " + new Date());
                    out.println("Server: Avalon Instrument Manager HTTP Connector");
                    out.println("Content-Length: " + contents.length);
                    out.println("Keep-Alive: timeout=" + this.getSoTimeout() / 1000);
                    out.println("Connection: Keep-Alive");
                    out.println("Content-Type: " + handler.getContentType());
                    out.println("Pragma: no-cache");
                    out.println("Expires: Thu, 01 Jan 1970 00:00:00 GMT");
                    out.println("Cache-Control: no-cache");
                    out.println("");
                    out.flush();
                    byte[] responseBytes = hbos.toByteArray();
                    os.write(responseBytes);
                    os.write(contents, 0, contents.length);
                    os.flush();
                    this.m_instrumentResponseBytes.increment(responseBytes.length + contents.length);
                    this.logAccessEvent(ip, method, url, 200, contents.length, referrer, userAgent);
                    return true;
                }
            }
        }
        out.println("HTTP/1.1 404 Not Found");
        out.println("Date: " + new Date());
        out.println("Server: Avalon Instrument Manager HTTP Connector");
        out.println("Content-Type: text/plain; charset=UTF-8");
        out.println("");
        out.println("The Requested page does not exist");
        if (error != null) {
            out.println("---");
            if (error instanceof FileNotFoundException) {
                out.println(error.getMessage());
            } else {
                this.getLogger().error("Error servicing request.", error);
                error.printStackTrace(out);
            }
        }
        out.flush();
        byte[] responseBytes = hbos.toByteArray();
        os.write(responseBytes);
        os.flush();
        this.m_instrumentResponseBytes.increment(responseBytes.length);
        this.logAccessEvent(ip, method, url, 404, 0, referrer, userAgent);
        return false;
    }

    public void setParameter(Map params, String param, String value) {
        Object old = params.get(param);
        if (old == null) {
            params.put(param, value);
        } else if (old instanceof String) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(old);
            list.add(value);
            params.put(param, list);
        } else {
            List list = (List)old;
            list.add(value);
        }
    }

    private void decodeParameter(Map params, String pair, String encoding) {
        int pos = pair.indexOf(61);
        if (pos > 0) {
            try {
                String param = URLCoder.decode(pair.substring(0, pos), encoding);
                String value = pos < pair.length() - 1 ? URLCoder.decode(pair.substring(pos + 1), encoding) : "";
                this.setParameter(params, param, value);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException("Unknown encoding: " + e.toString());
            }
        }
    }

    private void decodeQuery(Map params, String query, String encoding) {
        StringTokenizer st = new StringTokenizer(query, "&");
        while (st.hasMoreTokens()) {
            this.decodeParameter(params, st.nextToken(), encoding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HTTPURLHandler[] getHandlers() {
        HTTPURLHandler[] handlers = this.m_handlerArray;
        if (handlers == null) {
            List list = this.m_handlers;
            synchronized (list) {
                handlers = new HTTPURLHandler[this.m_handlers.size()];
                this.m_handlers.toArray(handlers);
                this.m_handlerArray = handlers;
            }
        }
        return handlers;
    }
}

