/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.datasource;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.avalon.excalibur.datasource.PoolSettable;
import org.apache.avalon.excalibur.datasource.ProxiedJdbcConnection;
import org.apache.avalon.excalibur.pool.Pool;
import org.apache.avalon.excalibur.pool.Poolable;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;

public class AbstractJdbcConnection
extends AbstractLogEnabled
implements PoolSettable,
Disposable,
ProxiedJdbcConnection {
    protected Connection m_connection;
    private Object m_proxy;
    protected Pool m_pool;
    protected boolean m_encounteredError;
    protected int m_testAge;
    protected PreparedStatement m_testStatement;
    protected SQLException m_testException;
    protected long m_lastUsed = System.currentTimeMillis();
    private static final Map m_methods = new HashMap();
    private final List m_allocatedStatements = new LinkedList();
    static /* synthetic */ Class class$org$apache$avalon$excalibur$datasource$AbstractJdbcConnection;
    static /* synthetic */ Class class$java$sql$CallableStatement;
    static /* synthetic */ Class class$java$sql$PreparedStatement;
    static /* synthetic */ Class class$java$sql$Statement;
    static /* synthetic */ Class class$java$sql$DatabaseMetaData;
    static /* synthetic */ Class class$java$sql$Array;
    static /* synthetic */ Class class$java$sql$ResultSet;
    static /* synthetic */ Class class$java$sql$ResultSetMetaData;
    static /* synthetic */ Class class$java$sql$ParameterMetaData;

    public AbstractJdbcConnection(Connection connection, boolean oradb) {
        this(connection, oradb ? "select 1 from dual" : "select 1");
    }

    public AbstractJdbcConnection(Connection connection, String keepAlive) {
        this(connection, keepAlive, 5000);
    }

    public AbstractJdbcConnection(Connection connection, String keepAlive, int keepAliveAge) {
        this.m_connection = connection;
        this.initialize();
        this.m_testAge = keepAliveAge;
        if (null == keepAlive || "".equals(keepAlive.trim())) {
            this.m_testStatement = null;
            this.m_testException = null;
        } else {
            try {
                this.m_testStatement = this.m_connection.prepareStatement(keepAlive);
            }
            catch (SQLException se) {
                this.m_testStatement = null;
                this.m_testException = se;
            }
        }
    }

    public void initialize() {
    }

    public void enableLogging(Logger log) {
        super.enableLogging(log);
        if (this.m_testStatement == null && this.m_testException != null) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Could not prepare test statement, connection recycled on basis of time.", (Throwable)this.m_testException);
            }
            this.m_testException = null;
        }
    }

    public void setPool(Pool pool) {
        this.m_pool = pool;
    }

    public void recycle() {
        this.m_testException = null;
        try {
            this.clearAllocatedStatements();
            this.m_connection.clearWarnings();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void setProxiedConnection(Object proxy) {
        this.m_proxy = proxy;
    }

    public Connection getConnection() {
        return this.m_connection;
    }

    public boolean isClosed() throws SQLException {
        if (this.m_connection.isClosed()) {
            return true;
        }
        if (this.m_testStatement == null) {
            if (this.m_encounteredError) {
                return true;
            }
        } else {
            long age = System.currentTimeMillis() - this.m_lastUsed;
            boolean ping = false;
            if (age > (long)this.m_testAge) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Pinging database after " + age + "ms of inactivity.");
                }
                ping = true;
            } else if (this.m_encounteredError) {
                this.getLogger().debug("Pinging database after a previously thrown error.");
                ping = true;
            }
            this.m_encounteredError = false;
            if (ping) {
                try {
                    ResultSet rs = this.m_testStatement.executeQuery();
                    rs.close();
                }
                catch (SQLException se) {
                    this.getLogger().debug("Ping of connection failed.", (Throwable)se);
                    this.dispose();
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        try {
            this.m_lastUsed = System.currentTimeMillis();
            try {
                this.clearAllocatedStatements();
                this.m_connection.clearWarnings();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        finally {
            this.m_pool.put((Poolable)this.m_proxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearAllocatedStatements() throws SQLException {
        List list = this.m_allocatedStatements;
        synchronized (list) {
            try {
                Iterator iterator = this.m_allocatedStatements.iterator();
                while (iterator.hasNext()) {
                    Statement stmt = (Statement)iterator.next();
                    stmt.close();
                }
            }
            finally {
                this.m_allocatedStatements.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerAllocatedStatement(Statement stmt) {
        List list = this.m_allocatedStatements;
        synchronized (list) {
            this.m_allocatedStatements.add(stmt);
        }
    }

    public void dispose() {
        block2: {
            try {
                this.m_connection.close();
            }
            catch (SQLException se) {
                if (!this.getLogger().isDebugEnabled()) break block2;
                this.getLogger().debug("Could not close connection", (Throwable)se);
            }
        }
    }

    public boolean equals(Object obj) {
        InvocationHandler handler;
        if (Proxy.isProxyClass(obj.getClass()) && (handler = Proxy.getInvocationHandler(obj)) instanceof ProxiedJdbcConnection) {
            return this.m_connection.equals(((ProxiedJdbcConnection)handler).getConnection());
        }
        return false;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object retVal = null;
        Method executeMethod = (Method)m_methods.get(method.getName());
        try {
            retVal = null == executeMethod ? method.invoke((Object)this.m_connection, args) : executeMethod.invoke((Object)this, args);
        }
        catch (InvocationTargetException e) {
            this.m_encounteredError = true;
            throw e.getTargetException();
        }
        if (retVal != null) {
            if (retVal instanceof CallableStatement) {
                retVal = Proxy.newProxyInstance((class$java$sql$CallableStatement == null ? (class$java$sql$CallableStatement = AbstractJdbcConnection.class$("java.sql.CallableStatement")) : class$java$sql$CallableStatement).getClassLoader(), new Class[]{class$java$sql$CallableStatement == null ? (class$java$sql$CallableStatement = AbstractJdbcConnection.class$("java.sql.CallableStatement")) : class$java$sql$CallableStatement}, (InvocationHandler)new ProxiedObject(retVal));
            } else if (retVal instanceof PreparedStatement) {
                retVal = Proxy.newProxyInstance((class$java$sql$PreparedStatement == null ? (class$java$sql$PreparedStatement = AbstractJdbcConnection.class$("java.sql.PreparedStatement")) : class$java$sql$PreparedStatement).getClassLoader(), new Class[]{class$java$sql$PreparedStatement == null ? (class$java$sql$PreparedStatement = AbstractJdbcConnection.class$("java.sql.PreparedStatement")) : class$java$sql$PreparedStatement}, (InvocationHandler)new ProxiedObject(retVal));
            } else if (retVal instanceof Statement) {
                retVal = Proxy.newProxyInstance((class$java$sql$Statement == null ? (class$java$sql$Statement = AbstractJdbcConnection.class$("java.sql.Statement")) : class$java$sql$Statement).getClassLoader(), new Class[]{class$java$sql$Statement == null ? (class$java$sql$Statement = AbstractJdbcConnection.class$("java.sql.Statement")) : class$java$sql$Statement}, (InvocationHandler)new ProxiedObject(retVal));
            } else if (retVal instanceof DatabaseMetaData) {
                retVal = Proxy.newProxyInstance((class$java$sql$DatabaseMetaData == null ? (class$java$sql$DatabaseMetaData = AbstractJdbcConnection.class$("java.sql.DatabaseMetaData")) : class$java$sql$DatabaseMetaData).getClassLoader(), new Class[]{class$java$sql$DatabaseMetaData == null ? (class$java$sql$DatabaseMetaData = AbstractJdbcConnection.class$("java.sql.DatabaseMetaData")) : class$java$sql$DatabaseMetaData}, (InvocationHandler)new ProxiedObject(retVal));
            }
        }
        return retVal;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Method[] methods = (class$org$apache$avalon$excalibur$datasource$AbstractJdbcConnection == null ? (class$org$apache$avalon$excalibur$datasource$AbstractJdbcConnection = AbstractJdbcConnection.class$("org.apache.avalon.excalibur.datasource.AbstractJdbcConnection")) : class$org$apache$avalon$excalibur$datasource$AbstractJdbcConnection).getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            m_methods.put(methods[i].getName(), methods[i]);
        }
    }

    private class ProxiedObject
    implements InvocationHandler {
        Object m_originalObject;

        private ProxiedObject(Object originalObject) {
            this.m_originalObject = originalObject;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object retVal;
            try {
                retVal = method.invoke(this.m_originalObject, args);
            }
            catch (InvocationTargetException e) {
                AbstractJdbcConnection.this.m_encounteredError = true;
                throw e.getTargetException();
            }
            if (retVal != null) {
                if (retVal instanceof Array) {
                    retVal = Proxy.newProxyInstance((class$java$sql$Array == null ? (class$java$sql$Array = AbstractJdbcConnection.class$("java.sql.Array")) : class$java$sql$Array).getClassLoader(), new Class[]{class$java$sql$Array == null ? (class$java$sql$Array = AbstractJdbcConnection.class$("java.sql.Array")) : class$java$sql$Array}, (InvocationHandler)new ProxiedObject(retVal));
                } else if (retVal instanceof ResultSet && retVal instanceof ResultSetMetaData) {
                    retVal = Proxy.newProxyInstance((class$java$sql$ResultSet == null ? (class$java$sql$ResultSet = AbstractJdbcConnection.class$("java.sql.ResultSet")) : class$java$sql$ResultSet).getClassLoader(), new Class[]{class$java$sql$ResultSet == null ? (class$java$sql$ResultSet = AbstractJdbcConnection.class$("java.sql.ResultSet")) : class$java$sql$ResultSet, class$java$sql$ResultSetMetaData == null ? (class$java$sql$ResultSetMetaData = AbstractJdbcConnection.class$("java.sql.ResultSetMetaData")) : class$java$sql$ResultSetMetaData}, (InvocationHandler)new ProxiedObject(retVal));
                } else if (retVal instanceof ResultSet) {
                    retVal = Proxy.newProxyInstance((class$java$sql$ResultSet == null ? (class$java$sql$ResultSet = AbstractJdbcConnection.class$("java.sql.ResultSet")) : class$java$sql$ResultSet).getClassLoader(), new Class[]{class$java$sql$ResultSet == null ? (class$java$sql$ResultSet = AbstractJdbcConnection.class$("java.sql.ResultSet")) : class$java$sql$ResultSet}, (InvocationHandler)new ProxiedObject(retVal));
                } else if (retVal instanceof ResultSetMetaData) {
                    retVal = Proxy.newProxyInstance((class$java$sql$ResultSetMetaData == null ? (class$java$sql$ResultSetMetaData = AbstractJdbcConnection.class$("java.sql.ResultSetMetaData")) : class$java$sql$ResultSetMetaData).getClassLoader(), new Class[]{class$java$sql$ResultSetMetaData == null ? (class$java$sql$ResultSetMetaData = AbstractJdbcConnection.class$("java.sql.ResultSetMetaData")) : class$java$sql$ResultSetMetaData}, (InvocationHandler)new ProxiedObject(retVal));
                } else if (retVal instanceof ParameterMetaData) {
                    retVal = Proxy.newProxyInstance((class$java$sql$ParameterMetaData == null ? (class$java$sql$ParameterMetaData = AbstractJdbcConnection.class$("java.sql.ParameterMetaData")) : class$java$sql$ParameterMetaData).getClassLoader(), new Class[]{class$java$sql$ParameterMetaData == null ? (class$java$sql$ParameterMetaData = AbstractJdbcConnection.class$("java.sql.ParameterMetaData")) : class$java$sql$ParameterMetaData}, (InvocationHandler)new ProxiedObject(retVal));
                }
            }
            return retVal;
        }
    }
}

