/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ArithmeticExpression10;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Calculator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.NegateExpression;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.Token;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.UntypedAtomicConverter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public class ArithmeticExpression
extends BinaryExpression {
    private Calculator calculator;

    public ArithmeticExpression(Expression expression, int n, Expression expression2) {
        super(expression, n, expression2);
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        Expression expression = super.simplify(staticContext);
        if (expression == this && staticContext.isInBackwardsCompatibleMode()) {
            return new ArithmeticExpression10(this.operand0, this.operator, this.operand1);
        }
        return expression;
    }

    public boolean isBackwardsCompatible() {
        return false;
    }

    public Calculator getCalculator() {
        return this.calculator;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
        Expression expression = this.operand0;
        Expression expression2 = this.operand1;
        this.operand0 = this.operand0.typeCheck(staticContext, itemType);
        this.operand1 = this.operand1.typeCheck(staticContext, itemType);
        SequenceType sequenceType = SequenceType.OPTIONAL_ATOMIC;
        RoleLocator roleLocator = new RoleLocator(1, Token.tokens[this.operator], 0, null);
        roleLocator.setSourceLocator(this);
        this.operand0 = TypeChecker.staticTypeCheck(this.operand0, sequenceType, false, roleLocator, staticContext);
        ItemType itemType2 = this.operand0.getItemType(typeHierarchy);
        if (itemType2 instanceof EmptySequenceTest) {
            return new Literal(EmptySequence.getInstance());
        }
        AtomicType atomicType = (AtomicType)itemType2.getPrimitiveItemType();
        if (atomicType.getFingerprint() == 631) {
            this.operand0 = new UntypedAtomicConverter(this.operand0, BuiltInAtomicType.DOUBLE, true);
            atomicType = BuiltInAtomicType.DOUBLE;
        } else if (!(this.operand0 instanceof UntypedAtomicConverter) && typeHierarchy.relationship(atomicType, BuiltInAtomicType.UNTYPED_ATOMIC) != 4) {
            this.operand0 = new UntypedAtomicConverter(this.operand0, BuiltInAtomicType.DOUBLE, false);
            atomicType = (AtomicType)this.operand0.getItemType(typeHierarchy);
        }
        RoleLocator roleLocator2 = new RoleLocator(1, Token.tokens[this.operator], 1, null);
        roleLocator2.setSourceLocator(this);
        this.operand1 = TypeChecker.staticTypeCheck(this.operand1, sequenceType, false, roleLocator2, staticContext);
        ItemType itemType3 = this.operand1.getItemType(typeHierarchy);
        if (itemType3 instanceof EmptySequenceTest) {
            return new Literal(EmptySequence.getInstance());
        }
        AtomicType atomicType2 = (AtomicType)itemType3.getPrimitiveItemType();
        if (atomicType2.getFingerprint() == 631) {
            this.operand1 = new UntypedAtomicConverter(this.operand1, BuiltInAtomicType.DOUBLE, true);
            atomicType2 = BuiltInAtomicType.DOUBLE;
        } else if (!(this.operand1 instanceof UntypedAtomicConverter) && typeHierarchy.relationship(atomicType2, BuiltInAtomicType.UNTYPED_ATOMIC) != 4) {
            this.operand1 = new UntypedAtomicConverter(this.operand1, BuiltInAtomicType.DOUBLE, false);
            atomicType2 = (AtomicType)this.operand1.getItemType(typeHierarchy);
        }
        if (this.operand0 != expression) {
            this.adoptChildExpression(this.operand0);
        }
        if (this.operand1 != expression2) {
            this.adoptChildExpression(this.operand1);
        }
        if (Literal.isEmptySequence(this.operand0) || Literal.isEmptySequence(this.operand1)) {
            return new Literal(EmptySequence.getInstance());
        }
        if (atomicType.isExternalType() || atomicType2.isExternalType()) {
            DynamicError dynamicError = new DynamicError("Arithmetic operators are not defined for external objects");
            dynamicError.setLocator(this);
            dynamicError.setIsTypeError(true);
            dynamicError.setErrorCode("XPTY0004");
            throw dynamicError;
        }
        if (this.operator == 199) {
            if (this.operand1 instanceof Literal && ((Literal)this.operand1).getValue() instanceof NumericValue) {
                NumericValue numericValue = (NumericValue)((Literal)this.operand1).getValue();
                return new Literal(numericValue.negate());
            }
            NegateExpression negateExpression = new NegateExpression(this.operand1);
            negateExpression.setBackwardsCompatible(false);
            return negateExpression.typeCheck(staticContext, itemType);
        }
        boolean bl = !atomicType.equals(BuiltInAtomicType.ANY_ATOMIC) && !atomicType2.equals(BuiltInAtomicType.ANY_ATOMIC) && !atomicType.equals(BuiltInAtomicType.NUMERIC) && !atomicType2.equals(BuiltInAtomicType.NUMERIC);
        this.calculator = Calculator.getCalculator(atomicType.getFingerprint(), atomicType2.getFingerprint(), ArithmeticExpression.mapOpCode(this.operator), bl);
        if (this.calculator == null) {
            DynamicError dynamicError = new DynamicError("Arithmetic operator is not defined for arguments of types (" + atomicType.getDescription() + ", " + atomicType2.getDescription() + ")");
            dynamicError.setLocator(this);
            dynamicError.setErrorCode("XPTY0004");
            throw dynamicError;
        }
        try {
            if (this.operand0 instanceof Literal && this.operand1 instanceof Literal) {
                return new Literal(Value.asValue(this.evaluateItem(staticContext.makeEarlyEvaluationContext())));
            }
        }
        catch (DynamicError dynamicError) {
            // empty catch block
        }
        return this;
    }

    public static int mapOpCode(int n) {
        switch (n) {
            case 15: {
                return 0;
            }
            case 16: 
            case 199: {
                return 1;
            }
            case 17: {
                return 2;
            }
            case 18: {
                return 3;
            }
            case 50: {
                return 5;
            }
            case 19: {
                return 4;
            }
        }
        throw new IllegalArgumentException();
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        AtomicType atomicType;
        ItemType itemType;
        if (this.calculator == null) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
        ItemType itemType2 = this.operand0.getItemType(typeHierarchy);
        if (!(itemType2 instanceof AtomicType)) {
            itemType2 = itemType2.getAtomizedItemType();
        }
        if (!((itemType = this.operand1.getItemType(typeHierarchy)) instanceof AtomicType)) {
            itemType = itemType.getAtomizedItemType();
        }
        if ((atomicType = this.calculator.getResultType((AtomicType)itemType2.getPrimitiveItemType(), (AtomicType)itemType.getPrimitiveItemType())).equals(BuiltInAtomicType.ANY_ATOMIC) && (this.operator == 15 || this.operator == 16) && (typeHierarchy.isSubType(itemType, BuiltInAtomicType.NUMERIC) || typeHierarchy.isSubType(itemType2, BuiltInAtomicType.NUMERIC))) {
            atomicType = BuiltInAtomicType.NUMERIC;
        }
        return atomicType;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue = (AtomicValue)this.operand0.evaluateItem(xPathContext);
        if (atomicValue == null) {
            return null;
        }
        AtomicValue atomicValue2 = (AtomicValue)this.operand1.evaluateItem(xPathContext);
        if (atomicValue2 == null) {
            return null;
        }
        try {
            return this.calculator.compute(atomicValue, atomicValue2, xPathContext);
        }
        catch (DynamicError dynamicError) {
            if (dynamicError.getLocator() == null) {
                dynamicError.setLocator(this);
            }
            if (dynamicError.getXPathContext() == null) {
                dynamicError.setXPathContext(xPathContext);
            }
            throw dynamicError;
        }
    }
}

