/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.ValidationErrorValue;
import net.sf.saxon.value.Value;

public final class CastableExpression
extends UnaryExpression {
    AtomicType targetType;
    boolean allowEmpty;

    public CastableExpression(Expression expression, AtomicType atomicType, boolean bl) {
        super(expression);
        this.targetType = atomicType;
        this.allowEmpty = bl;
    }

    public AtomicType getTargetType() {
        return this.targetType;
    }

    public boolean allowsEmpty() {
        return this.allowEmpty;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.operand = this.operand.simplify(staticContext);
        if (Literal.isAtomic(this.operand)) {
            return Literal.makeLiteral(BooleanValue.get(this.effectiveBooleanValue(staticContext.makeEarlyEvaluationContext())));
        }
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand = this.operand.typeCheck(staticContext, itemType);
        TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
        if (!CastExpression.isPossibleCast(this.operand.getItemType(typeHierarchy).getAtomizedItemType().getFingerprint(), this.targetType.getPrimitiveType())) {
            return Literal.makeLiteral(BooleanValue.FALSE);
        }
        if (Literal.isAtomic(this.operand)) {
            return Literal.makeLiteral(BooleanValue.get(this.effectiveBooleanValue(staticContext.makeEarlyEvaluationContext())));
        }
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand = this.operand.optimize(optimizer, staticContext, itemType);
        if (Literal.isAtomic(this.operand)) {
            return Literal.makeLiteral(BooleanValue.get(this.effectiveBooleanValue(staticContext.makeEarlyEvaluationContext())));
        }
        return this;
    }

    public boolean equals(Object object) {
        return super.equals(object) && this.targetType == ((CastableExpression)object).targetType && this.allowEmpty == ((CastableExpression)object).allowEmpty;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return BuiltInAtomicType.BOOLEAN;
    }

    public int computeCardinality() {
        return 16384;
    }

    public int computeSpecialProperties() {
        int n = super.computeSpecialProperties();
        return n | 0x400000;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(xPathContext));
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        Item item;
        int n = 0;
        SequenceIterator sequenceIterator = this.operand.iterate(xPathContext);
        while ((item = sequenceIterator.next()) != null) {
            Value value;
            if (item instanceof NodeInfo) {
                AtomicValue atomicValue;
                value = ((NodeInfo)item).atomize();
                int n2 = value.getLength();
                if ((n += n2) > 1) {
                    return false;
                }
                if (n2 == 0 || CastableExpression.isCastable(atomicValue = (AtomicValue)value.itemAt(0), this.targetType, xPathContext)) continue;
                return false;
            }
            value = (AtomicValue)item;
            if (++n > 1) {
                return false;
            }
            if (CastableExpression.isCastable((AtomicValue)value, this.targetType, xPathContext)) continue;
            return false;
        }
        if (n == 0) {
            return this.allowEmpty;
        }
        return true;
    }

    public static boolean isCastable(AtomicValue atomicValue, AtomicType atomicType, XPathContext xPathContext) {
        return !(atomicValue.convert(atomicType, xPathContext, true) instanceof ValidationErrorValue);
    }

    protected String displayOperator(Configuration configuration) {
        return "castable as " + this.targetType.toString(configuration.getNamePool());
    }
}

