/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Value;

public final class SingletonAtomizer
extends UnaryExpression {
    private boolean allowEmpty;
    private RoleLocator role;
    private static final int STRING_KINDS = 8576;
    private static final int UNTYPED_KINDS = 520;
    private static final int UNTYPED_IF_UNTYPED_KINDS = 526;

    public SingletonAtomizer(Expression expression, RoleLocator roleLocator, boolean bl) {
        super(expression);
        this.allowEmpty = bl;
        this.role = roleLocator;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.operand = this.operand.simplify(staticContext);
        if (this.operand instanceof Literal && ((Literal)this.operand).getValue() instanceof AtomicValue) {
            return this.operand;
        }
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand = this.operand.typeCheck(staticContext, itemType);
        this.resetStaticProperties();
        if (Literal.isEmptySequence(this.operand)) {
            if (!this.allowEmpty) {
                this.typeError("An empty sequence is not allowed as the " + this.role.getMessage(), this.role.getErrorCode(), null);
            }
            Expression.setParentExpression(this.operand, this.getParentExpression());
            return this.operand;
        }
        TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
        if (this.operand.getItemType(typeHierarchy).isAtomicType()) {
            Expression.setParentExpression(this.operand, this.getParentExpression());
            return this.operand;
        }
        return this;
    }

    public int computeSpecialProperties() {
        int n = super.computeSpecialProperties();
        return n | 0x400000;
    }

    public RoleLocator getRole() {
        return this.role;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Item item;
        int n = 0;
        Item item2 = null;
        SequenceIterator sequenceIterator = this.operand.iterate(xPathContext);
        while ((item = sequenceIterator.next()) != null) {
            if (item instanceof AtomicValue) {
                if (n++ > 0) {
                    this.typeError("A sequence of more than one item is not allowed as the " + this.role.getMessage(), this.role.getErrorCode(), xPathContext);
                }
                item2 = item;
                continue;
            }
            Value value = ((NodeInfo)item).atomize();
            if ((n += value.getLength()) > 1) {
                this.typeError("A sequence of more than one item is not allowed as the " + this.role.getMessage(), this.role.getErrorCode(), xPathContext);
            }
            item2 = value.itemAt(0);
        }
        if (n == 0 && !this.allowEmpty) {
            this.typeError("An empty sequence is not allowed as the " + this.role.getMessage(), this.role.getErrorCode(), null);
        }
        return item2;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        ItemType itemType;
        boolean bl = true;
        Executable executable = this.getExecutable();
        if (executable != null && !executable.getConfiguration().isSchemaAware(52)) {
            bl = false;
        }
        if ((itemType = this.operand.getItemType(typeHierarchy)).isAtomicType()) {
            return itemType;
        }
        if (itemType instanceof NodeTest) {
            if (itemType instanceof EmptySequenceTest) {
                return itemType;
            }
            int n = ((NodeTest)itemType).getNodeKindMask();
            if (!bl) {
                if ((n | 0x2180) == 8576) {
                    return BuiltInAtomicType.STRING;
                }
                if ((n | 0x20E) == 526) {
                    return BuiltInAtomicType.UNTYPED_ATOMIC;
                }
            } else if ((n | 0x208) == 520) {
                return BuiltInAtomicType.UNTYPED_ATOMIC;
            }
            return itemType.getAtomizedItemType();
        }
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    public int computeCardinality() {
        if (this.allowEmpty) {
            return 24576;
        }
        return 16384;
    }

    protected String displayOperator(Configuration configuration) {
        return "atomize singleton";
    }
}

