/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.Err;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.FloatingPointConverter;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.ValidationErrorValue;
import net.sf.saxon.value.Value;

public final class DoubleValue
extends NumericValue {
    public static final DoubleValue ZERO = new DoubleValue(0.0);
    public static final DoubleValue NEGATIVE_ZERO = new DoubleValue(-0.0);
    public static final DoubleValue ONE = new DoubleValue(1.0);
    public static final DoubleValue NaN = new DoubleValue(Double.NaN);
    private double value;
    static Pattern nonExponentialPattern = Pattern.compile("(-?[0-9])([0-9]+?)(0*)\\.([0-9]*)");

    public DoubleValue(CharSequence charSequence) throws ValidationException {
        try {
            this.value = Value.stringToNumber(charSequence);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ValidationException("Cannot convert string " + Err.wrap(charSequence, 4) + " to a double");
        }
        this.typeLabel = BuiltInAtomicType.DOUBLE;
    }

    public DoubleValue(double d) {
        this.value = d;
        this.typeLabel = BuiltInAtomicType.DOUBLE;
    }

    public DoubleValue(double d, AtomicType atomicType) {
        this.value = d;
        this.typeLabel = atomicType;
    }

    public AtomicValue copy(AtomicType atomicType) {
        DoubleValue doubleValue = new DoubleValue(this.value);
        doubleValue.typeLabel = atomicType;
        return doubleValue;
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.DOUBLE;
    }

    public double getDoubleValue() {
        return this.value;
    }

    public int hashCode() {
        if (this.value > -2.147483648E9 && this.value < 2.147483647E9) {
            return (int)this.value;
        }
        return new Double(this.value).hashCode();
    }

    public boolean isNaN() {
        return Double.isNaN(this.value);
    }

    public boolean effectiveBooleanValue() {
        return this.value != 0.0 && !Double.isNaN(this.value);
    }

    public AtomicValue convertPrimitive(BuiltInAtomicType builtInAtomicType, boolean bl, XPathContext xPathContext) {
        switch (builtInAtomicType.getPrimitiveType()) {
            case 514: {
                return BooleanValue.get(this.effectiveBooleanValue());
            }
            case 88: 
            case 517: 
            case 632: 
            case 635: {
                return this;
            }
            case 532: {
                if (Double.isNaN(this.value)) {
                    ValidationException validationException = new ValidationException("Cannot convert double NaN to an integer");
                    validationException.setErrorCode("FOCA0002");
                    return new ValidationErrorValue(validationException);
                }
                if (Double.isInfinite(this.value)) {
                    ValidationException validationException = new ValidationException("Cannot convert double INF to an integer");
                    validationException.setErrorCode("FOCA0002");
                    return new ValidationErrorValue(validationException);
                }
                if (this.value > 9.223372036854776E18 || this.value < -9.223372036854776E18) {
                    return new BigIntegerValue(new BigDecimal(this.value).toBigInteger());
                }
                return Int64Value.makeIntegerValue((long)this.value);
            }
            case 515: {
                try {
                    return new DecimalValue(this.value);
                }
                catch (ValidationException validationException) {
                    return new ValidationErrorValue(validationException);
                }
            }
            case 516: {
                return new FloatValue((float)this.value);
            }
            case 513: {
                return new StringValue(this.getStringValueCS());
            }
            case 631: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
        }
        ValidationException validationException = new ValidationException("Cannot convert double to " + builtInAtomicType.getDisplayName());
        validationException.setErrorCode("XPTY0004");
        validationException.setIsTypeError(true);
        return new ValidationErrorValue(validationException);
    }

    public String getStringValue() {
        return ((Object)DoubleValue.doubleToString(this.value)).toString();
    }

    public CharSequence getStringValueCS() {
        return DoubleValue.doubleToString(this.value);
    }

    public CharSequence getCanonicalLexicalRepresentation() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(20);
        return FloatingPointConverter.appendDoubleExponential(fastStringBuffer, this.value);
    }

    public static CharSequence doubleToString(double d) {
        FastStringBuffer fastStringBuffer = FloatingPointConverter.appendDouble(new FastStringBuffer(20), d);
        return fastStringBuffer;
    }

    public static CharSequence doubleToStringOLD(double d, String string) {
        String string2;
        if (d == 0.0) {
            if (string.charAt(0) == '-') {
                return "-0";
            }
            return "0";
        }
        if (Double.isInfinite(d)) {
            return d > 0.0 ? "INF" : "-INF";
        }
        if (Double.isNaN(d)) {
            return "NaN";
        }
        double d2 = Math.abs(d);
        String string3 = string;
        if (d2 < 1.0E-6 || d2 >= 1000000.0) {
            if (string3.indexOf(69) < 0) {
                FastStringBuffer fastStringBuffer = new FastStringBuffer(32);
                Matcher matcher = nonExponentialPattern.matcher(string3);
                if (matcher.matches()) {
                    fastStringBuffer.append(matcher.group(1));
                    fastStringBuffer.append('.');
                    fastStringBuffer.append(matcher.group(2));
                    String string4 = matcher.group(4);
                    if ("0".equals(string4)) {
                        fastStringBuffer.append("E" + (matcher.group(2).length() + matcher.group(3).length()));
                        return fastStringBuffer;
                    }
                    fastStringBuffer.append(matcher.group(3));
                    fastStringBuffer.append(matcher.group(4));
                    fastStringBuffer.append("E" + (matcher.group(2).length() + matcher.group(3).length()));
                    return fastStringBuffer;
                }
                return string3;
            }
            return string3;
        }
        int n = string3.length();
        if (string3.endsWith("E0")) {
            string3 = string3.substring(0, n - 2);
        }
        if (string3.endsWith(".0")) {
            return string3.substring(0, n - 2);
        }
        int n2 = string3.indexOf(69);
        if (n2 < 0) {
            while (string3.charAt(n - 1) == '0' && string3.charAt(n - 2) != '.') {
                string3 = string3.substring(0, --n);
            }
            return string3;
        }
        int n3 = Integer.parseInt(string3.substring(n2 + 1));
        if (string3.charAt(0) == '-') {
            string2 = "-";
            string3 = string3.substring(1);
            --n2;
        } else {
            string2 = "";
        }
        int n4 = n2 - 2;
        if (n3 >= n4) {
            return string2 + string3.substring(0, 1) + string3.substring(2, n2) + DoubleValue.zeros(n3 - n4);
        }
        if (n3 > 0) {
            return string2 + string3.substring(0, 1) + string3.substring(2, 2 + n3) + '.' + string3.substring(2 + n3, n2);
        }
        while (string3.charAt(n2 - 1) == '0') {
            --n2;
        }
        return string2 + "0." + DoubleValue.zeros(-1 - n3) + string3.substring(0, 1) + string3.substring(2, n2);
    }

    static String zeros(int n) {
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = 48;
        }
        return new String(cArray);
    }

    public NumericValue negate() {
        return new DoubleValue(-this.value);
    }

    public NumericValue floor() {
        return new DoubleValue(Math.floor(this.value));
    }

    public NumericValue ceiling() {
        return new DoubleValue(Math.ceil(this.value));
    }

    public NumericValue round() {
        if (Double.isNaN(this.value)) {
            return this;
        }
        if (Double.isInfinite(this.value)) {
            return this;
        }
        if (this.value == 0.0) {
            return this;
        }
        if (this.value > -0.5 && this.value < 0.0) {
            return new DoubleValue(-0.0);
        }
        if (this.value > -9.223372036854776E18 && this.value < 9.223372036854776E18) {
            return new DoubleValue(Math.round(this.value));
        }
        return this;
    }

    public NumericValue roundHalfToEven(int n) {
        if (Double.isNaN(this.value)) {
            return this;
        }
        if (Double.isInfinite(this.value)) {
            return this;
        }
        if (this.value == 0.0) {
            return this;
        }
        double d = Math.pow(10.0, n + 1);
        double d2 = Math.abs(this.value * d);
        if (Double.isInfinite(d2)) {
            BigDecimal bigDecimal = new BigDecimal(this.value);
            bigDecimal.setScale(n, 6);
            return new DoubleValue(bigDecimal.doubleValue());
        }
        double d3 = d2 % 10.0;
        d2 = d3 > 5.0 ? (d2 += 10.0 - d3) : (d3 < 5.0 ? (d2 -= d3) : (d2 % 20.0 == 15.0 ? (d2 += 5.0) : (d2 -= 5.0)));
        d2 /= d;
        if (this.value < 0.0) {
            d2 = 0.0 - d2;
        }
        return new DoubleValue(d2);
    }

    public double signum() {
        if (Double.isNaN(this.value)) {
            return this.value;
        }
        if (this.value > 0.0) {
            return 1.0;
        }
        if (this.value == 0.0) {
            return 0.0;
        }
        return -1.0;
    }

    public boolean isWholeNumber() {
        return this.value == Math.floor(this.value) && !Double.isInfinite(this.value);
    }

    public NumericValue arithmetic(int n, NumericValue numericValue, XPathContext xPathContext) throws XPathException {
        if (numericValue instanceof DoubleValue) {
            switch (n) {
                case 15: {
                    return new DoubleValue(this.value + ((DoubleValue)numericValue).value);
                }
                case 16: {
                    return new DoubleValue(this.value - ((DoubleValue)numericValue).value);
                }
                case 17: {
                    return new DoubleValue(this.value * ((DoubleValue)numericValue).value);
                }
                case 18: {
                    return new DoubleValue(this.value / ((DoubleValue)numericValue).value);
                }
                case 50: {
                    if (((DoubleValue)numericValue).value == 0.0) {
                        DynamicError dynamicError = new DynamicError("Integer division by zero");
                        dynamicError.setErrorCode("FOAR0001");
                        dynamicError.setXPathContext(xPathContext);
                        throw dynamicError;
                    }
                    if (this.isNaN() || Double.isInfinite(this.value)) {
                        DynamicError dynamicError = new DynamicError("First operand of idiv is NaN or infinity");
                        dynamicError.setErrorCode("FOAR0002");
                        dynamicError.setXPathContext(xPathContext);
                        throw dynamicError;
                    }
                    if (numericValue.isNaN()) {
                        DynamicError dynamicError = new DynamicError("Second operand of idiv is NaN");
                        dynamicError.setErrorCode("FOAR0002");
                        dynamicError.setXPathContext(xPathContext);
                        throw dynamicError;
                    }
                    return (NumericValue)new DoubleValue(this.value / ((DoubleValue)numericValue).value).convert(BuiltInAtomicType.INTEGER, xPathContext);
                }
                case 19: {
                    return new DoubleValue(this.value % ((DoubleValue)numericValue).value);
                }
            }
            throw new UnsupportedOperationException("Unknown operator");
        }
        return this.arithmetic(n, (DoubleValue)numericValue.convert(BuiltInAtomicType.DOUBLE, xPathContext), xPathContext);
    }

    public int compareTo(long l) {
        double d = l;
        if (this.value == d) {
            return 0;
        }
        if (this.value < d) {
            return -1;
        }
        return 1;
    }

    public Comparable getSchemaComparable() {
        return new Double(this.value);
    }

    public Object convertToJava(Class clazz, XPathContext xPathContext) throws XPathException {
        if (clazz == Object.class) {
            return new Double(this.value);
        }
        if (clazz.isAssignableFrom(DoubleValue.class)) {
            return this;
        }
        if (clazz == Boolean.TYPE) {
            return this.effectiveBooleanValue();
        }
        if (clazz == Boolean.class) {
            return this.effectiveBooleanValue();
        }
        if (clazz == String.class || clazz == CharSequence.class) {
            return this.getStringValue();
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return new Double(this.value);
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return new Float(this.value);
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return new Long((long)this.value);
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return new Integer((int)this.value);
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return new Short((short)this.value);
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return new Byte((byte)this.value);
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            return new Character((char)this.value);
        }
        Object object = super.convertToJava(clazz, xPathContext);
        if (object == null) {
            DynamicError dynamicError = new DynamicError("Conversion of double to " + clazz.getName() + " is not supported");
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setErrorCode("SXJE0002");
        }
        return object;
    }

    public static void printInternalForm(double d) {
        System.err.println("==== Double " + d + " ====");
        long l = Double.doubleToLongBits(d);
        System.err.println("Internal form: " + Long.toHexString(l));
        if (l == 0x7FF0000000000000L) {
            System.err.println("+Infinity");
        } else if (l == -4503599627370496L) {
            System.err.println("-Infinity");
        } else if (l == 9221120237041090560L) {
            System.err.println("NaN");
        } else {
            int n = l >> 63 == 0L ? 1 : -1;
            int n2 = (int)(l >> 52 & 0x7FFL);
            long l2 = n2 == 0 ? (l & 0xFFFFFFFFFFFFFL) << 1 : l & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
            int n3 = n2 - 1075;
            System.err.println("Sign: " + n);
            System.err.println("Exponent: " + n3);
            System.err.println("Significand: " + l2);
            BigDecimal bigDecimal = BigDecimal.valueOf(l2);
            bigDecimal = n3 > 0 ? bigDecimal.multiply(new BigDecimal(BigInteger.valueOf(2L).pow(n3))) : bigDecimal.divide(new BigDecimal(BigInteger.valueOf(2L).pow(-n3)), 7);
            System.err.println("Exact value: " + (n > 0 ? "" : "-") + bigDecimal);
        }
    }
}

