/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.application;

import fr.gouv.culture.sdx.application.ApplicationSourceValidity;
import fr.gouv.culture.sdx.document.XMLDocument;
import fr.gouv.culture.sdx.documentbase.DocumentBase;
import fr.gouv.culture.sdx.documentbase.IndexParameters;
import fr.gouv.culture.sdx.documentbase.LuceneDocumentBase;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.repository.Repository;
import fr.gouv.culture.sdx.resolver.entity.SDXResolver;
import fr.gouv.culture.sdx.search.Searchable;
import fr.gouv.culture.sdx.search.lucene.FieldList;
import fr.gouv.culture.sdx.thesaurus.SDXThesaurus;
import fr.gouv.culture.sdx.thesaurus.Thesaurus;
import fr.gouv.culture.sdx.user.AnonymousUserInformation;
import fr.gouv.culture.sdx.user.Group;
import fr.gouv.culture.sdx.user.GroupInformationInserter;
import fr.gouv.culture.sdx.user.Identity;
import fr.gouv.culture.sdx.user.User;
import fr.gouv.culture.sdx.user.UserDatabase;
import fr.gouv.culture.sdx.user.UserInformation;
import fr.gouv.culture.sdx.utils.AbstractSdxObject;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.configuration.ConfigurationUtils;
import fr.gouv.culture.sdx.utils.io.IOWrapper;
import fr.gouv.culture.sdx.utils.logging.LoggingUtils;
import fr.gouv.culture.sdx.utils.rdbms.hsql.HSQLDB;
import fr.gouv.culture.sdx.utils.save.SaveParameters;
import fr.gouv.culture.sdx.utils.save.SaveParametersBuilder;
import fr.gouv.culture.sdx.utils.save.Saveable;
import fr.gouv.culture.sdx.utils.save.StringComparator;
import fr.gouv.culture.sdx.utils.zip.ZipWrapper;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.configuration.DefaultConfigurationSerializer;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.xml.EntityResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class Application
extends AbstractSdxObject
implements Saveable {
    private String path;
    private String dataDir;
    private DefaultContext _repositories;
    private DefaultContext _fieldLists = null;
    private Hashtable _documentBases;
    private DocumentBase _defaultDocumentBase = null;
    private UserDatabase _userDatabase;
    private Hashtable _thesauri = new Hashtable();
    private Hashtable _userInformations;
    private String _defaultAdminGroupId = null;
    private Configuration _defaultAdminGroupConf = null;
    private String _defaultAdminUserId = null;
    public static final String USER_DOCUMENT_BASE_ID = "sdxuserdb";
    public static final String USER_DATABASE_ID = "sdxuserdatabase";
    private boolean _isUsingSDXUserDataBase = false;
    private final String REPOSITORIES_DIR_NAME = "repos";
    private final String DOCUMENTBASES_DIR_NAME = "dbs";
    private final String USERS_DIR_NAME = "users";
    private final String USERS_DATABASE_DIR_NAME = "userDataBase";
    private final String USERS_DOCUMENTBASE_DIR_NAME = "userDocBase";
    private final String THESAURI_DIR_NAME = "thesauri";
    public static final String APPLICATION_CONFIGURATION_DIRECTORY = "conf";
    public static final String APP_CONFIG_FILENAME = "application.xconf";
    private final String LIB_DIR_NAME = "lib" + File.separator;
    private final String CLASSES_DIR_NAME = "classes" + File.separator;
    private final String ATTRIBUTE_SYSTEM_DIR = "dataDir";
    private final String ATTRIBUTE_SESSION_OBJECT_LIMIT = "sessionObjectLimit";
    private final int SESSION_OBJECT_LIMIT_DEFAULT = 5;
    private final String ATTRIBUTE_IS_DATADIR_SHARED = "is-datadir-shared";
    private final String ATTRIBUTE_INDEXATION_LOGGING_LEVEL = "indexation-logging-level";
    public static final String ELEMENT_NAME_USER_DOCUMENT_BASE = "userDocumentBase";
    private String ELEMENT_NAME_ADMIN = "admin";
    private String ATTRIBUTE_GROUP_ID = "groupId";
    private String ATTRIBUTE_USER_ID = "userId";
    private String ATTRIBUTE_USER_PASSWORD = "userPassword";
    private final String ELEMENT_NAME_CATALOGS = "catalogs";
    private final String ELEMENT_NAME_CATALOG = "catalog";
    private final String ATTRIBUTE_CATALOG_SRC = "src";
    private final String DEFAULT_DOCUMENTBASE_TYPE = "lucene";
    private final String DEFAULT_THESAURUS_TYPE = "lucene";
    public String DATABASES_DIR_NAME = "databases";
    protected int sessionObjectLimit = 5;
    public static final String CLASS_NAME_SUFFIX = "Application";
    private int indexationLoggingLevel;

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        DefaultContext l_context = super.getContext();
        try {
            this.path = (String)l_context.get((Object)"sdx.application.dirName");
        }
        catch (ContextException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
        l_context.put((Object)"sdx.application.id", (Object)super.getId());
        ConfigurationUtils.checkConfAttributeValue("xml:lang", this.getXmlLang(), configuration.getLocation());
        String appConfPath = Utilities.getStringFromContext("sdx.application.confDirPath", (Context)l_context);
        String _attSysDir = null;
        try {
            _attSysDir = configuration.getAttribute(this.ATTRIBUTE_SYSTEM_DIR);
        }
        catch (ConfigurationException ce) {
            // empty catch block
        }
        if (Utilities.checkString(_attSysDir)) {
            try {
                this.dataDir = Utilities.resolveFile(null, configuration.getLocation(), (Context)this.getContext(), _attSysDir, true).getAbsolutePath();
                Utilities.checkDirectory(this.dataDir, this.getLogger());
            }
            catch (Exception e) {
                this.dataDir = null;
                throw new ConfigurationException(e.getMessage(), (Throwable)e);
            }
        }
        boolean _isDatadirShared = configuration.getAttributeAsBoolean(this.ATTRIBUTE_IS_DATADIR_SHARED, false);
        this.indexationLoggingLevel = configuration.getAttributeAsInteger(this.ATTRIBUTE_INDEXATION_LOGGING_LEVEL, 0);
        String basepath = appConfPath;
        if (Utilities.checkString(this.dataDir)) {
            basepath = this.dataDir;
        }
        if (Utilities.checkString(basepath) && !basepath.endsWith(File.separator)) {
            basepath = basepath + File.separator;
        }
        String dbsDirPath = basepath + "dbs" + File.separator;
        String reposDirPath = basepath + "repos" + File.separator;
        String usersDirPath = basepath + "users" + File.separator;
        String usersDocbaseDirPath = usersDirPath + "userDocBase" + File.separator;
        String thesauriDbsPath = basepath + "thesauri" + File.separator;
        String sdxDatabaseDir = basepath + this.DATABASES_DIR_NAME + File.separator;
        String backup_location = basepath + "backup" + File.separator;
        l_context.put((Object)"sdx.application.dataDirPath", (Object)(this.dataDir == null ? "" : this.dataDir));
        l_context.put((Object)"sdx.application.dbsDirPath", (Object)dbsDirPath);
        l_context.put((Object)"sdx.application.reposDirPath", (Object)reposDirPath);
        l_context.put((Object)"sdx.application.usersDirPath", (Object)usersDirPath);
        l_context.put((Object)"sdx.application.userDocBaseDirPath", (Object)usersDocbaseDirPath);
        l_context.put((Object)"sdx.application.thesauriDirPath", (Object)thesauriDbsPath);
        l_context.put((Object)"sdx.application.databaseDirPath", (Object)sdxDatabaseDir);
        l_context.put((Object)"sdx.application.backupDirPath", (Object)backup_location);
        l_context.put((Object)"sdx.application.dataDir.shared", (Object)new Boolean(_isDatadirShared));
        l_context.put((Object)"sdx.application.indexation.logging.level", (Object)new Integer(this.indexationLoggingLevel));
        try {
            l_context.put((Object)"sdx.application.hsqldb", (Object)new HSQLDB());
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
        this.loadClasses(appConfPath);
        this.configureDefaultDatabaseType(configuration);
        this.configureSessionObjectLimit(configuration);
        this.configureRepositories(configuration);
        this.configureFieldLists(configuration);
        this.configureUserDocumentBase(configuration);
        this._defaultAdminGroupConf = configuration.getChild(this.ELEMENT_NAME_ADMIN, false);
        this.configureEntityCatalogs(configuration);
        this.configureDocumentBases(configuration);
        this.configureThesauri(configuration);
    }

    protected void configureEntityCatalogs(Configuration configuration) throws ConfigurationException {
        Configuration[] catalogConfList;
        Configuration catalogs = configuration.getChild("catalogs", false);
        if (catalogs != null && (catalogConfList = catalogs.getChildren("catalog")) != null && catalogConfList.length > 0) {
            try {
                this.addEntityCatalogs(catalogConfList);
            }
            catch (SDXException e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)((Object)e));
            }
        }
    }

    protected void configureFieldLists(Configuration configuration) throws ConfigurationException {
        String elemNameFieldLists = "fieldLists";
        Configuration[] fieldListConfList = new Configuration[configuration.getChild(elemNameFieldLists).getChildren("fieldList").length];
        fieldListConfList = configuration.getChild(elemNameFieldLists).getChildren("fieldList");
        if (fieldListConfList == null || fieldListConfList.length == 0) {
            String[] args = new String[]{super.getId()};
            SDXException sdxE = new SDXException(43, args);
            LoggingUtils.logWarn(this.getLogger(), sdxE.getMessage());
            return;
        }
        if (this._fieldLists == null) {
            this._fieldLists = new DefaultContext();
        }
        for (int i = 0; i < fieldListConfList.length; ++i) {
            FieldList l_fieldList = null;
            try {
                l_fieldList = ConfigurationUtils.configureFieldList(this.getLogger(), this.getServiceManager(), Utilities.createNewReadOnlyContext((Context)this.getContext()), null, fieldListConfList[i]);
                l_fieldList = ConfigurationUtils.configureLuceneFieldList(this.getLogger(), (Context)this.getContext(), l_fieldList);
                String id = l_fieldList.getId();
                ConfigurationUtils.checkConfAttributeValue("id", id, fieldListConfList[i].getLocation());
                Utilities.isObjectUnique((Context)this._fieldLists, null, (Object)l_fieldList);
                this._fieldLists.put((Object)l_fieldList.getId(), (Object)l_fieldList);
                continue;
            }
            catch (ConfigurationException e) {
                LoggingUtils.logException(this.getLogger(), (Exception)((Object)e));
                continue;
            }
            catch (SDXException e) {
                LoggingUtils.logException(this.getLogger(), (Exception)((Object)e));
            }
        }
        super.getContext().put((Object)"sdx.application.fieldLists", (Object)Utilities.createNewReadOnlyContext((Context)this._fieldLists));
    }

    protected void configureUserDocumentBase(Configuration configuration) throws ConfigurationException {
        Configuration userDbConf = configuration.getChild(ELEMENT_NAME_USER_DOCUMENT_BASE, false);
        if (userDbConf == null) {
            String[] args = new String[]{configuration.getLocation(), configuration.getLocation()};
            SDXException sdxE = new SDXException(13, args);
            LoggingUtils.logWarn(this.getLogger(), sdxE.getMessage(), (Exception)((Object)sdxE));
            return;
        }
        this._isUsingSDXUserDataBase = true;
        if (this._documentBases == null) {
            this._documentBases = new Hashtable();
        }
        try {
            LuceneDocumentBase userDb = new LuceneDocumentBase();
            DefaultContext l_context = super.getContext();
            l_context = new DefaultContext((Context)l_context);
            l_context.put((Object)"sdx.application.dbsDirPath", (Object)Utilities.getStringFromContext("sdx.application.userDocBaseDirPath", (Context)l_context));
            userDb = (LuceneDocumentBase)Utilities.setUpSdxObject(userDb, super.getLog(), Utilities.createNewReadOnlyContext((Context)l_context), super.getServiceManager());
            userDb.setId(USER_DOCUMENT_BASE_ID);
            userDb.configure(userDbConf);
            userDb.init();
            Utilities.isObjectUnique(this._documentBases, USER_DOCUMENT_BASE_ID, (Object)userDb);
            this._documentBases.put(USER_DOCUMENT_BASE_ID, userDb);
        }
        catch (SDXException e) {
            throw new ConfigurationException(e.getMessage(), e.fillInStackTrace());
        }
    }

    protected void configureSessionObjectLimit(Configuration configuration) {
        this.sessionObjectLimit = configuration.getAttributeAsInteger("sessionObjectLimit", 5);
    }

    private void configureDefaultDatabaseType(Configuration configuration) {
        Configuration defaultDatabaseConf = configuration.getChild(Utilities.getElementName("Database"), false);
        if (defaultDatabaseConf != null) {
            super.getContext().put((Object)"sdx.application.defaultDatabaseConfObj", (Object)defaultDatabaseConf);
        }
    }

    private void configureRepositories(Configuration configuration) {
        String elementName = Utilities.getElementName("Repository");
        Configuration[] repoConfList = new Configuration[configuration.getChild("repositories").getChildren(elementName).length];
        repoConfList = configuration.getChild("repositories", true).getChildren(elementName);
        if (repoConfList == null || repoConfList.length == 0) {
            String[] args = new String[]{super.getId()};
            SDXException sdxE = new SDXException(28, args);
            LoggingUtils.logWarn(this.getLogger(), sdxE.getMessage());
            return;
        }
        if (this._repositories == null) {
            this._repositories = new DefaultContext();
        }
        for (int i = 0; i < repoConfList.length; ++i) {
            Repository repo = null;
            try {
                repo = ConfigurationUtils.createRepository(this.getLogger(), (Context)super.getContext(), super.getServiceManager(), repoConfList[i]);
                Utilities.isObjectUnique((Context)this._repositories, null, (Object)repo);
                this._repositories.put((Object)repo.getId(), (Object)repo);
                continue;
            }
            catch (SDXException e) {
                LoggingUtils.logException(this.getLogger(), (Exception)((Object)e));
                continue;
            }
            catch (ConfigurationException e) {
                LoggingUtils.logException(this.getLogger(), (Exception)((Object)e));
            }
        }
        super.getContext().put((Object)"sdx.application.repos", (Object)Utilities.createNewReadOnlyContext((Context)this._repositories));
    }

    private void configureDocumentBases(Configuration configuration) throws ConfigurationException {
        DefaultContext l_context = super.getContext();
        String documentBaseElementName = Utilities.getElementName("DocumentBase");
        Configuration[] dbConfList = new Configuration[configuration.getChild(documentBaseElementName + "s").getChildren(documentBaseElementName).length];
        dbConfList = configuration.getChild(documentBaseElementName + "s").getChildren(documentBaseElementName);
        if (dbConfList == null || dbConfList.length == 0) {
            String[] args = new String[1];
            try {
                args[0] = ((Configuration)l_context.get((Object)"sdx.application.confObj")).getLocation();
            }
            catch (ContextException e) {
                args[0] = "no file location available";
            }
            SDXException sdxE = new SDXException(this.getLogger(), 7, args, null);
            throw new ConfigurationException(sdxE.getMessage(), (Throwable)((Object)sdxE));
        }
        if (this._documentBases == null) {
            this._documentBases = new Hashtable();
        }
        DocumentBase firstDocumentBase = null;
        for (int i = 0; i < dbConfList.length; ++i) {
            try {
                String dbType = dbConfList[i].getAttribute("type", "lucene");
                Object obj = Utilities.getObjectForClassName(this.getLog(), dbType, "fr.gouv.culture.sdx.documentbase.", dbType, "DocumentBase");
                Class<?> l_objClass = obj.getClass();
                if (!(obj instanceof DocumentBase)) {
                    String[] args = new String[3];
                    args[0] = "DocumentBase";
                    if (l_objClass != null) {
                        args[1] = l_objClass.getName();
                    }
                    args[2] = dbType;
                    throw new SDXException(this.getLogger(), 10, args, null);
                }
                DocumentBase db = (DocumentBase)obj;
                db = (DocumentBase)super.setUpSdxObject(db);
                db.configure(dbConfList[i]);
                db.init();
                Utilities.isObjectUnique(this._documentBases, null, (Object)db);
                this._documentBases.put(db.getId(), db);
                if (db.isDefault()) {
                    this._defaultDocumentBase = db;
                }
                if (i == 0) {
                    firstDocumentBase = db;
                }
            }
            catch (ConfigurationException e) {
                LoggingUtils.logException(this.getLogger(), (Exception)((Object)e));
            }
            catch (SDXException e) {
                // empty catch block
            }
            if (this._defaultDocumentBase != null) continue;
            this._defaultDocumentBase = firstDocumentBase;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addEntityCatalogs(Configuration[] catalogConfList) throws SDXException, ConfigurationException {
        SDXResolver resolver = null;
        String src = "";
        File srcFile = null;
        ServiceManager l_manager = super.getServiceManager();
        try {
            try {
                Object c = l_manager.lookup(EntityResolver.ROLE);
                if (c != null && c instanceof SDXResolver) {
                    resolver = (SDXResolver)((Object)c);
                }
                if (resolver == null) {
                    SDXException sdxE = new SDXException(null, 26, null, null);
                    String[] args = new String[]{src, sdxE.getMessage()};
                    throw new SDXException(this.getLogger(), 25, args, (Throwable)((Object)sdxE));
                }
                for (int i = 0; i < catalogConfList.length; ++i) {
                    Configuration conf = catalogConfList[i];
                    if (conf == null) continue;
                    src = conf.getAttribute("src");
                    ConfigurationUtils.checkConfAttributeValue("src", src, conf.getLocation());
                    srcFile = Utilities.resolveFile(null, conf.getLocation(), (Context)this.getContext(), src, false);
                    if (srcFile == null) continue;
                    resolver.addCatalog(srcFile.toURI().toURL());
                }
                Object var10_14 = null;
                if (resolver == null) return;
            }
            catch (ServiceException e) {
                throw new SDXException(this.getLogger(), 26, null, e);
            }
            catch (MalformedURLException e) {
                String[] args = new String[]{src, e.getMessage()};
                throw new SDXException(this.getLogger(), 25, args, e);
            }
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            if (resolver == null) throw throwable;
            l_manager.release(resolver);
            throw throwable;
        }
        l_manager.release((Object)resolver);
    }

    private void configureThesauri(Configuration configuration) {
        String elementName = Utilities.getElementName("Thesaurus");
        Configuration[] thConfList = new Configuration[configuration.getChild("thesauri", true).getChildren(elementName).length];
        thConfList = configuration.getChild("thesauri", true).getChildren(elementName);
        for (int i = 0; i < thConfList.length; ++i) {
            try {
                String thType = thConfList[i].getAttribute("type", "lucene");
                Object obj = Utilities.getObjectForClassName(this.getLog(), thType, "fr.gouv.culture.sdx.thesaurus.", thType, "Thesaurus");
                Class<?> l_objClass = obj.getClass();
                if (!(obj instanceof Thesaurus)) {
                    String[] args = new String[3];
                    args[0] = "Thesaurus";
                    if (l_objClass != null) {
                        args[1] = l_objClass.getName();
                    }
                    args[2] = thType;
                    throw new SDXException(this.getLogger(), 10, args, null);
                }
                SDXThesaurus th = (SDXThesaurus)obj;
                th = (SDXThesaurus)super.setUpSdxObject(th, thConfList[i]);
                th.init();
                Utilities.isObjectUnique(this._thesauri, null, (Object)th);
                this._thesauri.put(th.getId(), th);
                continue;
            }
            catch (ConfigurationException e) {
                String[] args = new String[]{thConfList[i].getLocation(), e.getMessage()};
                new SDXException(this.getLogger(), 41, args, e);
                continue;
            }
            catch (SDXException e) {
                // empty catch block
            }
        }
    }

    public void init() throws SDXException, ConfigurationException, ServiceException, ContextException {
        Utilities.checkDirectory(Utilities.getStringFromContext("sdx.application.dbsDirPath", (Context)super.getContext()), this.getLogger());
        if (this._isUsingSDXUserDataBase) {
            this._userDatabase = new UserDatabase(USER_DATABASE_ID);
            this._userDatabase = (UserDatabase)super.setUpSdxObject(this._userDatabase);
            this._userDatabase.configure((Configuration)new DefaultConfiguration("hack", ""));
            this._userDatabase.init();
            this.verifyDefaultAdminGroup();
        }
    }

    private void loadClasses(String appConfPath) throws ConfigurationException {
        String libPath = appConfPath + this.LIB_DIR_NAME;
        File libDir = new File(libPath);
        String classesPath = appConfPath + this.CLASSES_DIR_NAME;
        File classesDir = new File(classesPath);
        String classpath = "";
        DefaultContext context = super.getContext();
        try {
            if (libDir.exists() || classesDir.exists()) {
                classpath = (String)context.get((Object)"classpath");
                if (!classpath.endsWith(File.pathSeparator)) {
                    classpath = classpath + File.pathSeparator;
                }
                if (Utilities.checkString(classpath)) {
                    if (libDir.exists()) {
                        File[] libs = libDir.listFiles();
                        for (int i = 0; i < libs.length; ++i) {
                            classpath = classpath + libs[i].getAbsolutePath() + File.pathSeparator;
                        }
                    }
                    if (classesDir.exists()) {
                        classpath = classpath + classesDir.getAbsolutePath() + File.pathSeparator;
                    }
                }
                context.put((Object)"classpath", (Object)classpath);
            }
        }
        catch (ContextException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
    }

    public Logger getLogger() {
        return super.getLog();
    }

    public String getPath() {
        return this.path;
    }

    public String getDataDirPath() {
        return this.dataDir;
    }

    public Repository getRepository(String id) throws SDXException {
        if (!Utilities.checkString(id)) {
            return null;
        }
        Repository repo = (Repository)Utilities.getObjectFromContext(id, (Context)this._repositories);
        if (repo == null) {
            String[] args = new String[]{id, this.getId()};
            throw new SDXException(this.getLogger(), 1002, args, null);
        }
        return repo;
    }

    public DocumentBase getDocumentBase(String dbId) throws SDXException {
        if (!Utilities.checkString(dbId)) {
            return null;
        }
        DocumentBase db = null;
        db = (DocumentBase)this._documentBases.get(dbId);
        if (db == null) {
            String[] args = new String[]{dbId, this.getId()};
            throw new SDXException(this.getLogger(), 1001, args, null);
        }
        return db;
    }

    public Enumeration getDocumentBasesIds() {
        if (this._documentBases != null) {
            return this._documentBases.keys();
        }
        return null;
    }

    public DocumentBase getDefaultDocumentBase() {
        return this._defaultDocumentBase;
    }

    public SDXThesaurus getThesaurus(String id) throws SDXException {
        if (!Utilities.checkString(id)) {
            return null;
        }
        SDXThesaurus th = null;
        th = (SDXThesaurus)this._thesauri.get(id);
        if (th == null) {
            String[] args = new String[]{id, this.getId()};
            throw new SDXException(this.getLogger(), 1005, args, null);
        }
        return th;
    }

    public Searchable getSearchable(String id) {
        Searchable searchable = null;
        if (!Utilities.checkString(id)) {
            return null;
        }
        searchable = (Searchable)this._documentBases.get(id);
        if (searchable == null) {
            searchable = (Searchable)this._thesauri.get(id);
        }
        return searchable;
    }

    public boolean isUsingSDXUserDatabase() {
        return this._isUsingSDXUserDataBase;
    }

    public UserDatabase getUserDatabase() {
        return this._userDatabase;
    }

    public String getDefaultAdminGroupId() {
        String gid = null;
        try {
            if (this.getUserInformation(this._defaultAdminGroupId) != null) {
                gid = this._defaultAdminGroupId;
            }
        }
        catch (SDXException e) {
            LoggingUtils.logException(this.getLogger(), (Exception)((Object)e));
            gid = null;
        }
        return gid;
    }

    public String getDefaultAdminUserId() {
        String uid = null;
        try {
            if (this.getUserInformation(this._defaultAdminUserId) != null) {
                uid = this._defaultAdminUserId;
            }
        }
        catch (SDXException e) {
            uid = null;
        }
        return uid;
    }

    private void verifyDefaultAdminGroup() throws SDXException, ConfigurationException {
        if (!this._isUsingSDXUserDataBase) {
            return;
        }
        UserDatabase udb = this.getUserDatabase();
        if (udb != null && this._defaultAdminGroupConf != null) {
            String adminGroupId = this._defaultAdminGroupConf.getAttribute(this.ATTRIBUTE_GROUP_ID);
            ConfigurationUtils.checkConfAttributeValue(this.ATTRIBUTE_GROUP_ID, adminGroupId, this._defaultAdminGroupConf.getLocation());
            String adminUserId = this._defaultAdminGroupConf.getAttribute(this.ATTRIBUTE_USER_ID);
            ConfigurationUtils.checkConfAttributeValue(this.ATTRIBUTE_USER_ID, adminUserId, this._defaultAdminGroupConf.getLocation());
            String passwd = this._defaultAdminGroupConf.getAttribute(this.ATTRIBUTE_USER_PASSWORD, null);
            if (udb.getEntity(adminGroupId) == null) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = null;
                try {
                    builder = factory.newDocumentBuilder();
                    Document doc = null;
                    Element top = null;
                    doc = builder.newDocument();
                    top = doc.createElementNS("http://www.culture.gouv.fr/ns/sdx/sdx", "sdx:group");
                    doc.appendChild(top);
                    top.setAttribute("id", adminGroupId);
                    Group adminGroup = new Group();
                    adminGroup = (Group)super.setUpSdxObject(adminGroup);
                    adminGroup.setId(adminGroupId);
                    adminGroup.setPreferredFilename(adminGroupId + ".xml");
                    adminGroup.setContent(doc);
                    this.addIdentity(adminGroup, null, null, null, null);
                    this._defaultAdminGroupId = adminGroupId;
                    doc = builder.newDocument();
                    top = doc.createElementNS("http://www.culture.gouv.fr/ns/sdx/sdx", "sdx:user");
                    doc.appendChild(top);
                    top.setAttribute("id", adminUserId);
                    User adminUser = new User();
                    adminUser = (User)super.setUpSdxObject(adminUser);
                    adminUser.setId(adminUserId);
                    adminUser.setPreferredFilename(adminUserId + ".xml");
                    adminUser.setContent(doc);
                    this.addIdentity(adminUser, passwd, null, null, null);
                    this._defaultAdminUserId = adminUserId;
                    this.addMember(adminGroup, adminUserId);
                }
                catch (ParserConfigurationException e) {
                    throw new ConfigurationException(e.getMessage(), (Throwable)e);
                }
                catch (SAXException e) {
                    throw new ConfigurationException(e.getMessage(), (Throwable)e);
                }
                catch (ProcessingException e) {
                    throw new ConfigurationException(e.getMessage(), (Throwable)e);
                }
            }
            if (udb.getEntity(adminGroupId) != null) {
                this._defaultAdminGroupId = adminGroupId;
            }
            if (udb.getEntity(adminUserId) != null) {
                this._defaultAdminUserId = adminUserId;
            }
        }
    }

    public void addMember(Group group, String id) throws SDXException {
        if (!this._isUsingSDXUserDataBase) {
            return;
        }
        if (group == null || group.getId() == null || id == null) {
            return;
        }
        this._userDatabase.addMember(group, id);
        this.resetUserInformation(id);
    }

    public void addMembers(Group group, String[] ids) throws SDXException {
        if (!this._isUsingSDXUserDataBase) {
            return;
        }
        if (group == null || group.getId() == null || ids == null || ids.length == 0) {
            return;
        }
        for (int i = 0; i < ids.length; ++i) {
            this.addMember(group, ids[i]);
        }
    }

    public void replaceMembers(Group group, String[] ids) throws SDXException {
        if (!this._isUsingSDXUserDataBase) {
            return;
        }
        String[] members = this._userDatabase.getMembers(group.getId());
        if (members != null && members.length != 0) {
            for (int i = 0; i < members.length; ++i) {
                this.resetUserInformation(members[i]);
            }
        }
        this._userDatabase.deleteMembers(group);
        this.addMembers(group, ids);
    }

    public Hashtable getParents(String id) throws SDXException {
        if (!this._isUsingSDXUserDataBase) {
            return null;
        }
        if (id == null) {
            return null;
        }
        return this._userDatabase.getParents(id);
    }

    public String[] getMembers(String groupname) throws SDXException {
        if (!this._isUsingSDXUserDataBase) {
            return null;
        }
        if (groupname == null) {
            return null;
        }
        return this._userDatabase.getMembers(groupname);
    }

    public void addIdentity(Identity identity, String password, Repository repository, IndexParameters params, ContentHandler handler) throws SDXException, SAXException, ProcessingException {
        if (!this._isUsingSDXUserDataBase) {
            return;
        }
        if (identity == null) {
            throw new SDXException(this.getLogger(), 1004, null, null);
        }
        DocumentBase userDB = (DocumentBase)this._documentBases.get(USER_DOCUMENT_BASE_ID);
        if (userDB == null) {
            String[] args = new String[]{USER_DOCUMENT_BASE_ID, this.getId()};
            throw new SDXException(this.getLogger(), 1001, args, null);
        }
        userDB.index(identity, repository, params, handler);
        this._userDatabase.add(identity, this.encode(password));
        if (identity.getDocType() == "user") {
            this.resetUserInformation(identity.getId());
        }
    }

    public boolean changePassword(String username, String oldPass, String newPass) throws SDXException {
        if (!this._isUsingSDXUserDataBase) {
            return false;
        }
        if (this._userDatabase == null) {
            return false;
        }
        return this._userDatabase.changePassword(username, oldPass, newPass);
    }

    public void deleteIdentity(Identity identity) throws SDXException {
        if (!this._isUsingSDXUserDataBase) {
            return;
        }
        if (identity == null) {
            throw new SDXException(this.getLogger(), 1004, null, null);
        }
        Utilities.checkDocument(this.getLogger(), identity);
        DocumentBase userDB = (DocumentBase)this._documentBases.get(USER_DOCUMENT_BASE_ID);
        try {
            userDB.delete(identity, null);
        }
        catch (SAXException e) {
        }
        catch (ProcessingException processingException) {
            // empty catch block
        }
        this._userDatabase.delete(identity);
        if (identity.getDocType() == "user") {
            this.resetUserInformation(identity.getId());
        }
    }

    public boolean validateUser(String username, String password) throws SDXException {
        if (!this._isUsingSDXUserDataBase) {
            return false;
        }
        if (username == null) {
            return false;
        }
        return this._userDatabase.checkPassword(username, this.encode(password));
    }

    public boolean isMember(Identity identity, String groupName) throws SDXException {
        return this._userDatabase.isMember(identity, groupName);
    }

    private String encode(String password) {
        if (password == null) {
            return null;
        }
        return password;
    }

    public UserInformation getUserInformation(String username) throws SDXException {
        if (!this._isUsingSDXUserDataBase) {
            return null;
        }
        if (username == null) {
            username = "sdxAnonymous";
        }
        if (this._userInformations != null && this._userInformations.get(username) != null) {
            return (UserInformation)this._userInformations.get(username);
        }
        UserInformation userInfo = this._userDatabase.getUserInformation(super.getId(), username, super.getLocale(), this._defaultAdminGroupId);
        if (userInfo == null) {
            return null;
        }
        if (this._userInformations == null) {
            this._userInformations = new Hashtable();
        }
        this._userInformations.put(username, userInfo);
        return userInfo;
    }

    public UserInformation getUserInformation() throws SDXException {
        return this.getUserInformation(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void getUserDocument(String username, Hashtable groups, XMLConsumer consumer) throws SDXException {
        if (!this._isUsingSDXUserDataBase) {
            return;
        }
        Utilities.checkXmlConsumer(this.getLogger(), consumer);
        if (username == null || username.equals("sdxAnonymous")) {
            AnonymousUserInformation anon = (AnonymousUserInformation)this._userInformations.get("sdxAnonymous");
            try {
                if (anon == null) return;
                anon.toSAX((ContentHandler)consumer);
                return;
            }
            catch (SAXException e) {
                String[] args = new String[]{"sdxAnonymous", e.getMessage()};
                throw new SDXException(this.getLogger(), 1003, args, e);
            }
        } else if (groups != null && groups.size() > 0) {
            GroupInformationInserter gii = new GroupInformationInserter(groups, (ContentHandler)consumer);
            gii.enableLogging(this.getLogger());
            GroupInformationInserter pipe = gii;
            ((DocumentBase)this._documentBases.get(USER_DOCUMENT_BASE_ID)).getDocument(new XMLDocument(username), (XMLConsumer)pipe);
            return;
        } else {
            ((DocumentBase)this._documentBases.get(USER_DOCUMENT_BASE_ID)).getDocument(new XMLDocument(username), consumer);
        }
    }

    private void resetUserInformation(String username) {
        if (!this._isUsingSDXUserDataBase) {
            return;
        }
        if (username == null) {
            return;
        }
        if (this._userInformations == null) {
            this._userInformations = new Hashtable();
        } else if (this._userInformations.containsKey(username)) {
            this._userInformations.remove(username);
        }
    }

    public int getSessionObjectLimit() {
        return this.sessionObjectLimit;
    }

    protected String getClassNameSuffix() {
        return CLASS_NAME_SUFFIX;
    }

    protected boolean initToSax() {
        String appConfPath = this.getPath() + File.separator + APPLICATION_CONFIGURATION_DIRECTORY + File.separator;
        this._xmlizable_objects.put("ID", this.getId());
        this._xmlizable_objects.put("Path", this.getPath());
        this._xmlizable_objects.put("Encoding", this.getEncoding());
        this._xmlizable_objects.put("XML-Lang", this.getXmlLang());
        this._xmlizable_objects.put("Session_Object_Limit", Integer.toString(this.getSessionObjectLimit()));
        this._xmlizable_objects.put("System_Dir", this.dataDir);
        this._xmlizable_objects.put("Classes_Directory_Name", appConfPath + this.CLASSES_DIR_NAME);
        this._xmlizable_objects.put("Libraries_Directory_Name", appConfPath + this.LIB_DIR_NAME);
        this._xmlizable_objects.put("Databases_Directory_Name", appConfPath + this.DATABASES_DIR_NAME + File.separator);
        if (this._isUsingSDXUserDataBase) {
            this._xmlizable_objects.put("Users_Databases_Directory_Name", appConfPath + this.USERS_DIR_NAME + File.separator + "xml" + File.separator);
        }
        this._xmlizable_objects.put("Documentbases_Directory_Name", appConfPath + this.DOCUMENTBASES_DIR_NAME + File.separator);
        this.getClass();
        this._xmlizable_objects.put("Default_Documentbase_Type", "lucene");
        if (this._isUsingSDXUserDataBase) {
            this._xmlizable_objects.put("Users_Documentbases_Directory_Name", appConfPath + this.USERS_DIR_NAME + File.separator + this.USERS_DOCUMENTBASE_DIR_NAME + File.separator);
        }
        this._xmlizable_objects.put("Repositories_Directory_Name", appConfPath + this.REPOSITORIES_DIR_NAME + File.separator);
        this._xmlizable_objects.put("Thesauri_Directory_Name", appConfPath + this.THESAURI_DIR_NAME + File.separator);
        this.getClass();
        this._xmlizable_objects.put("Default_Thesaurus_Type", "lucene");
        this._xmlizable_objects.put("Default_Administrator_Group_ID", this.getDefaultAdminGroupId());
        this._xmlizable_objects.put("Default_Administrator_User_ID", this.getDefaultAdminUserId());
        this._xmlizable_objects.put("Default_DocumentBase", this.getDefaultDocumentBase().getId());
        this._xmlizable_objects.put("Default_Repositories", this._repositories);
        this._xmlizable_objects.put("Default_FieldLists", this._fieldLists);
        this._xmlizable_objects.put("Document_Bases", this._documentBases);
        this._xmlizable_objects.put("Thesauri", this._thesauri);
        return true;
    }

    protected void initVolatileObjectsToSax() {
    }

    public synchronized void optimize() {
        Enumeration dbIds = this.getDocumentBasesIds();
        while (dbIds.hasMoreElements()) {
            try {
                this.getDocumentBase((String)dbIds.nextElement()).optimize();
            }
            catch (SDXException e) {
                LoggingUtils.logException(this.getLogger(), (Exception)((Object)e));
            }
        }
    }

    public synchronized void optimize(String[] dbIds) {
        int i = 0;
        while (dbIds[i] != null) {
            try {
                this.getDocumentBase(dbIds[i]).optimize();
            }
            catch (SDXException e) {
                LoggingUtils.logException(this.getLogger(), (Exception)((Object)e));
            }
            ++i;
        }
    }

    public synchronized void optimize(String dbId) {
        try {
            this.getDocumentBase(dbId).optimize();
        }
        catch (SDXException e) {
            LoggingUtils.logException(this.getLogger(), (Exception)((Object)e));
        }
    }

    public synchronized void checkIntegrity() {
        Enumeration dbIds = this.getDocumentBasesIds();
        while (dbIds.hasMoreElements()) {
            try {
                this.getDocumentBase((String)dbIds.nextElement()).checkIntegrity();
            }
            catch (SDXException e) {
                LoggingUtils.logException(this.getLogger(), (Exception)((Object)e));
            }
        }
    }

    public synchronized void checkIntegrity(String[] dbIds) {
        int i = 0;
        while (dbIds[i] != null) {
            try {
                this.getDocumentBase(dbIds[i]).checkIntegrity();
            }
            catch (SDXException e) {
                LoggingUtils.logException(this.getLogger(), (Exception)((Object)e));
            }
            ++i;
        }
    }

    public synchronized void checkIntegrity(String dbId) {
        try {
            this.getDocumentBase(dbId).checkIntegrity();
        }
        catch (SDXException e) {
            LoggingUtils.logException(this.getLogger(), (Exception)((Object)e));
        }
    }

    public synchronized void saveApplication() {
        String backup_location = Utilities.getStringFromContext("sdx.application.backupDirPath", (Context)this.getContext());
        File save_dir = new File(backup_location + File.separator + "temp");
        if (!save_dir.exists()) {
            save_dir.mkdirs();
        }
        SaveParameters save_params = new SaveParameters("application", null, backup_location + File.separator + "temp", null);
        try {
            this.backup(save_params);
            ZipWrapper zw = new ZipWrapper();
            Calendar cal = Calendar.getInstance();
            SimpleDateFormat date = new SimpleDateFormat("yyyy-MM-dd_hh-mm-ss");
            String sar_name = this.getPath() + "-" + date.format(cal.getTime()) + ".sar";
            try {
                zw.zipDirectory(backup_location + File.separator + sar_name, backup_location + File.separator + "temp");
                IOWrapper iow = new IOWrapper();
                iow.deleteDirectory(backup_location + File.separator + "temp");
            }
            catch (SDXException ee) {
                String[] args = new String[]{this.getId(), ee.getMessage()};
                throw new SDXException(this.getLog(), 8204, args, (Throwable)((Object)ee));
            }
        }
        catch (SDXException e) {
            this.getLog().error(e.getMessage(), e.fillInStackTrace());
        }
    }

    public synchronized void loadApplication(String file_path) throws SDXException {
        File bk_dir;
        String[] files;
        String backup_location = Utilities.getStringFromContext("sdx.application.backupDirPath", (Context)this.getContext());
        String sar_path = file_path;
        if (!(sar_path != null && sar_path.endsWith(".sar") || (files = (bk_dir = new File(backup_location)).list()).length <= 0)) {
            Arrays.sort(files, new StringComparator());
            sar_path = backup_location + files[files.length - 1];
        }
        if (sar_path != null && sar_path.endsWith(".sar")) {
            File unzip_dir = new File(backup_location + File.separator + "temp");
            if (!unzip_dir.exists()) {
                unzip_dir.mkdirs();
            }
            try {
                ZipWrapper zw = new ZipWrapper();
                zw.unzipDirectory(sar_path, unzip_dir.getAbsolutePath());
            }
            catch (SDXException ee) {
                String[] args = new String[]{this.getId(), ee.getMessage()};
                throw new SDXException(this.getLog(), 8204, args, (Throwable)((Object)ee));
            }
            SaveParametersBuilder builder = new SaveParametersBuilder();
            SaveParameters save_conf = (SaveParameters)builder.buildFromFile(backup_location + File.separator + "temp", "info.xml");
            this.restore(save_conf);
            try {
                IOWrapper iow = new IOWrapper();
                iow.deleteDirectory(unzip_dir.getAbsolutePath());
            }
            catch (SDXException ee) {
                String[] args = new String[]{this.getId(), ee.getMessage()};
                throw new SDXException(this.getLog(), 8204, args, (Throwable)((Object)ee));
            }
        }
    }

    public void backup(SaveParameters save_config) throws SDXException {
        if (save_config != null) {
            if (save_config.isAllElementSelected()) {
                save_config.setAttribute("id", this.getId());
                SaveParameters saveparams = null;
                if (this._userDatabase != null) {
                    saveparams = new SaveParameters("userDatabase", save_config);
                    this.backupUserDatabase(saveparams);
                }
                if (this._documentBases != null && this._documentBases.size() > 0) {
                    saveparams = new SaveParameters(Utilities.getElementName("DocumentBase") + "s", save_config);
                    this.backupDocumentBases(saveparams);
                }
                if (this._thesauri != null && this._thesauri.size() > 0) {
                    saveparams = new SaveParameters("thesauri", save_config);
                    this.backupThesauri(saveparams);
                }
            }
            DefaultConfigurationSerializer DCserial = new DefaultConfigurationSerializer();
            try {
                String save_location = save_config.getStoreBasePath() + save_config.getStorePath();
                DCserial.serializeToFile(save_location + File.separator + "info.xml", (Configuration)save_config);
            }
            catch (IOException e) {
                throw new SDXException("Error accessing the save location.", e);
            }
            catch (SAXException e1) {
                throw new SDXException("Error editing the info.xml file", e1);
            }
            catch (ConfigurationException e2) {
                throw new SDXException("Error in the save configuration.", e2);
            }
        }
    }

    private void backupUserDatabase(SaveParameters save_config) throws SDXException {
        if (save_config != null && save_config.isAllElementSelected()) {
            this._userDatabase.backup(save_config);
        }
    }

    private void backupDocumentBases(SaveParameters save_config) throws SDXException {
        if (save_config != null) {
            String dbs_path = save_config.getStoreCompletePath() + File.separator + save_config.getName();
            if (save_config.isAllElementSelected()) {
                File dbs_dir = new File(dbs_path);
                if (!dbs_dir.exists()) {
                    dbs_dir.mkdir();
                }
                save_config.savePathInConfig(save_config.getName());
                Enumeration m_enum = this._documentBases.elements();
                while (m_enum.hasMoreElements()) {
                    DocumentBase db = (DocumentBase)m_enum.nextElement();
                    if (db == null) continue;
                    SaveParameters dbsave = new SaveParameters(Utilities.getElementName("DocumentBase"), save_config, save_config.getName());
                    dbsave.setUniqueID(save_config.getUniqueID());
                    db.backup(dbsave);
                }
            }
        }
    }

    private void backupThesauri(SaveParameters save_config) throws SDXException {
        if (save_config != null) {
            String thi_path = save_config.getStoreCompletePath() + File.separator + save_config.getName();
            if (save_config.isAllElementSelected()) {
                File thi_dir = new File(thi_path);
                if (!thi_dir.exists()) {
                    thi_dir.mkdir();
                }
                save_config.savePathInConfig(save_config.getName());
                Enumeration m_enum = this._thesauri.elements();
                while (m_enum.hasMoreElements()) {
                    SDXThesaurus th = (SDXThesaurus)m_enum.nextElement();
                    if (th == null) continue;
                    SaveParameters thsave = new SaveParameters(Utilities.getElementName("Thesaurus"), save_config, save_config.getName());
                    thsave.setUniqueID(save_config.getUniqueID());
                    th.backup(thsave);
                }
            }
        }
    }

    public void restore(SaveParameters save_config) throws SDXException {
        if (save_config != null && save_config.isAllElementSelected()) {
            if (!save_config.getAttribute("id", "").equals(this.getId())) {
                throw new SDXException("This application id don't match the one in \"info.xml\" in the backup file.");
            }
            String elementName = Utilities.getElementName("DocumentBase") + "s";
            SaveParameters saveparams = null;
            if (this._documentBases != null && this._documentBases.size() > 0) {
                saveparams = (SaveParameters)save_config.getChild(elementName);
                this.restoreDocumentBases(saveparams);
            }
            elementName = "thesauri";
            if (this._thesauri != null && this._thesauri.size() > 0) {
                saveparams = (SaveParameters)save_config.getChild(elementName);
                this.restoreThesauri(saveparams);
            }
        }
    }

    private void restoreUserDatabase(SaveParameters save_config) throws SDXException {
        if (save_config != null && save_config.isAllElementSelected()) {
            this._userDatabase.backup(save_config);
        }
    }

    public void restoreDocumentBases(SaveParameters save_config) throws SDXException {
        if (save_config != null) {
            String db_path = save_config.getStoreCompletePath();
            if (save_config.isAllElementSelected()) {
                File db_dir = new File(db_path);
                if (!db_dir.exists()) {
                    throw new SDXException(db_path + " not found.");
                }
                Enumeration m_enum = this._documentBases.elements();
                while (m_enum.hasMoreElements()) {
                    DocumentBase db = (DocumentBase)m_enum.nextElement();
                    if (db == null) continue;
                    SaveParameters dbsave = save_config.getSaveParametersById(db.getId());
                    db.restore(dbsave);
                }
            }
        }
    }

    public void restoreThesauri(SaveParameters save_config) throws SDXException {
        if (save_config != null) {
            String thi_path = save_config.getStoreCompletePath();
            if (save_config.isAllElementSelected()) {
                File thi_dir = new File(thi_path);
                if (!thi_dir.exists()) {
                    throw new SDXException(thi_path + " not found.");
                }
                Enumeration m_enum = this._thesauri.elements();
                while (m_enum.hasMoreElements()) {
                    SDXThesaurus th = (SDXThesaurus)m_enum.nextElement();
                    if (th == null) continue;
                    SaveParameters thsave = save_config.getSaveParametersById(th.getId());
                    th.restore(thsave);
                }
            }
        }
    }

    public SourceValidity getSourceValidity() {
        return new ApplicationSourceValidity(this);
    }
}

