/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.utils;

import fr.gouv.culture.sdx.utils.Utilities;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SAXUtils {
    public static String prefixNodeName(String prefix, String elemName) {
        if (!Utilities.checkString(elemName)) {
            return null;
        }
        String qualifiedElementName = "";
        if (Utilities.checkString(prefix)) {
            qualifiedElementName = qualifiedElementName + prefix + ":";
        }
        qualifiedElementName = qualifiedElementName + elemName;
        return qualifiedElementName;
    }

    public static void sendElement(ContentHandler handler, String uri, String localName, String qName, Attributes atts, String elemContent) throws SAXException {
        if (atts == null) {
            atts = new AttributesImpl();
        }
        handler.startElement(uri, localName, qName, atts);
        SAXUtils.sendElementContent(handler, elemContent);
        handler.endElement(uri, localName, qName);
    }

    public static void sendElementContent(ContentHandler handler, String content) throws SAXException {
        SAXUtils.sendElementContent(handler, content, false, null);
    }

    public static void sendElementContent(ContentHandler handler, String content, boolean escape) throws SAXException {
        SAXUtils.sendElementContent(handler, content, escape, null);
    }

    public static void sendElementContent(ContentHandler handler, String content, boolean escape, Character replace) throws SAXException {
        if (Utilities.checkString(content)) {
            char[] cs = content.toCharArray();
            if (escape) {
                int r = 32;
                if (replace != null) {
                    r = replace.charValue();
                }
                for (int i = 0; i < cs.length; ++i) {
                    char cc = cs[i];
                    if (cc == '\t' || cc == '\n' || cc == '\r' || cc >= ' ' && cc <= '\ud7ff' || cc >= '\ue000' && cc <= '\ufffd') continue;
                    cs[i] = r;
                }
            }
            handler.characters(cs, 0, cs.length);
        }
    }
}

