/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.utils.lucene;

import fr.gouv.culture.sdx.utils.Utilities;
import java.io.IOException;
import java.util.Hashtable;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class LuceneTools {
    protected LuceneTools() {
    }

    public static final void getTerms(Query query, Hashtable terms, boolean prohibited) throws IOException {
        if (query instanceof BooleanQuery) {
            LuceneTools.getTermsFromBooleanQuery((BooleanQuery)query, terms, prohibited);
        } else if (query instanceof PhraseQuery) {
            LuceneTools.getTermsFromPhraseQuery((PhraseQuery)query, terms);
        } else if (query instanceof TermQuery) {
            LuceneTools.getTermsFromTermQuery((TermQuery)query, terms);
        }
    }

    protected static final void getTermsFromBooleanQuery(BooleanQuery query, Hashtable terms, boolean prohibited) throws IOException {
        BooleanClause[] queryClauses = query.getClauses();
        for (int i = 0; i < queryClauses.length; ++i) {
            if (!prohibited && queryClauses[i].getOccur().equals(BooleanClause.Occur.MUST_NOT)) continue;
            LuceneTools.getTerms(queryClauses[i].getQuery(), terms, prohibited);
        }
    }

    protected static final void getTermsFromPhraseQuery(PhraseQuery query, Hashtable terms) {
        Term[] queryTerms = query.getTerms();
        if (query.getSlop() > 0) {
            return;
        }
        StringBuffer mTerms = new StringBuffer();
        for (int i = 0; i < queryTerms.length; ++i) {
            if (i != 0) {
                mTerms.append(" ");
            }
            mTerms.append(queryTerms[i].text());
        }
        terms.put(queryTerms[0].field() + "_" + mTerms.toString(), mTerms.toString());
    }

    protected static final void getTermsFromTermQuery(TermQuery query, Hashtable terms) {
        LuceneTools.getTermsFromTerm(query.getTerm(), terms);
    }

    protected static void getTermsFromTerm(Term term, Hashtable terms) {
        terms.put(term.field() + "_" + term.text(), term.text());
    }

    public static String getFieldNameFromKey(String key) {
        String fieldName = "";
        if (Utilities.checkString(key)) {
            fieldName = key.substring(0, key.indexOf("_"));
        }
        return fieldName;
    }
}

