/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene.query;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.search.lucene.DateField;
import fr.gouv.culture.sdx.search.lucene.Field;
import fr.gouv.culture.sdx.search.lucene.filter.Criteria;
import fr.gouv.culture.sdx.search.lucene.filter.Filter;
import fr.gouv.culture.sdx.search.lucene.query.AbstractResponse;
import fr.gouv.culture.sdx.search.lucene.query.Query;
import fr.gouv.culture.sdx.search.lucene.query.Results;
import fr.gouv.culture.sdx.search.lucene.query.SearchLocations;
import fr.gouv.culture.sdx.search.lucene.query.TermInfo;
import fr.gouv.culture.sdx.utils.Bits;
import fr.gouv.culture.sdx.utils.Date;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.logging.LoggingUtils;
import java.io.IOException;
import java.text.Collator;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeMap;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Terms
extends AbstractResponse
implements fr.gouv.culture.sdx.search.Terms {
    protected TreeMap termList;
    private String[] fieldFilters;
    private String[] valueFilters;
    private Filter filter;
    protected static Collator sortCollator;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setUp(SearchLocations sLocs, String field) throws SDXException {
        IndexReader reader;
        block19: {
            if (sLocs == null) {
                throw new SDXException(super.getLog(), 4000, null, null);
            }
            if (!Utilities.checkString(field)) {
                throw new SDXException(super.getLog(), 4200, null, null);
            }
            this.setFieldFilter(field);
            String internedfieldName = field.intern();
            super.setSearchLocations(sLocs);
            this.initCollator(this._searchLocations.getField(field));
            this.termList = new TreeMap(sortCollator);
            reader = null;
            TermEnum ts = null;
            try {
                block18: {
                    try {
                        reader = this._searchLocations.getReader();
                        if (reader == null) break block18;
                        ts = reader.terms(new Term(internedfieldName, ""));
                        boolean collecting = false;
                        if (ts == null) break block18;
                        do {
                            if (ts.term() != null && ts.term().field() == internedfieldName) {
                                collecting = true;
                                TermInfo ti = (TermInfo)this.termList.get(ts.term().text());
                                if (ti != null) {
                                    ti.update(reader, ts.term());
                                    continue;
                                }
                                ti = new TermInfo();
                                ti.enableLogging(super.getLog());
                                ti.setUp(reader, ts.term());
                                this.termList.put(ts.term().text(), ti);
                                continue;
                            }
                            if (collecting) break;
                        } while (ts.next());
                    }
                    catch (IOException e) {
                        String[] args = new String[]{e.getMessage()};
                        throw new SDXException(super.getLog(), 4201, args, e);
                    }
                }
                Object var9_10 = null;
                if (ts == null) break block19;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (ts != null) {
                    try {
                        ts.close();
                    }
                    catch (IOException e) {
                        String[] args = new String[]{e.getMessage()};
                        throw new SDXException(super.getLog(), 210, args, e);
                    }
                }
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException e) {
                    String[] args = new String[]{e.getMessage()};
                    throw new SDXException(super.getLog(), 211, args, e);
                }
            }
            try {}
            catch (IOException e) {
                String[] args = new String[]{e.getMessage()};
                throw new SDXException(super.getLog(), 210, args, e);
            }
            ts.close();
        }
        if (reader != null) {
            try {}
            catch (IOException e) {
                String[] args = new String[]{e.getMessage()};
                throw new SDXException(super.getLog(), 211, args, e);
            }
            reader.close();
        }
        super.setNbPages(this.countPages());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setUp(SearchLocations sLocs, String field, String str) throws SDXException {
        block25: {
            IndexReader reader;
            block23: {
                if (sLocs == null) {
                    throw new SDXException(super.getLog(), 4000, null, null);
                }
                if (!Utilities.checkString(field)) {
                    throw new SDXException(super.getLog(), 4200, null, null);
                }
                this.setFieldFilter(field);
                String internedfieldName = field.intern();
                if (str == null) {
                    this.setUp(sLocs, field);
                    return;
                }
                super.setSearchLocations(sLocs);
                this.initCollator(this._searchLocations.getField(field));
                this.termList = new TreeMap(sortCollator);
                reader = null;
                TermEnum ts = null;
                RE re = null;
                try {
                    re = Terms.getRE(str);
                }
                catch (RESyntaxException e) {
                    String[] args = new String[]{e.getMessage()};
                    throw new SDXException(null, 4201, args, e);
                }
                reader = this._searchLocations.getReader();
                if (reader == null) break block25;
                try {
                    block22: {
                        try {
                            ts = reader.terms(new Term(internedfieldName, ""));
                            Term t = null;
                            boolean collecting = false;
                            if (ts == null) break block22;
                            do {
                                if (ts.term() != null) {
                                    t = ts.term();
                                }
                                if (t != null && t.field() == internedfieldName) {
                                    collecting = true;
                                    String text = t.text();
                                    if (!re.match(text)) continue;
                                    TermInfo ti = (TermInfo)this.termList.get(text);
                                    if (ti != null) {
                                        ti.update(reader, ts.term());
                                        continue;
                                    }
                                    ti = new TermInfo();
                                    ti.enableLogging(super.getLog());
                                    ti.setUp(reader, ts.term());
                                    this.termList.put(text, ti);
                                    continue;
                                }
                                if (collecting) break;
                            } while (ts.next());
                        }
                        catch (IOException e) {
                            String[] args = new String[]{e.getMessage()};
                            throw new SDXException(null, 4201, args, e);
                        }
                    }
                    Object var13_16 = null;
                    if (ts == null) break block23;
                }
                catch (Throwable throwable) {
                    Object var13_17 = null;
                    if (ts != null) {
                        try {
                            ts.close();
                        }
                        catch (IOException e) {
                            String[] args = new String[]{e.getMessage()};
                            throw new SDXException(null, 210, args, e);
                        }
                    }
                    if (reader == null) throw throwable;
                    try {
                        reader.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        String[] args = new String[]{e.getMessage()};
                        throw new SDXException(null, 211, args, e);
                    }
                }
                try {}
                catch (IOException e) {
                    String[] args = new String[]{e.getMessage()};
                    throw new SDXException(null, 210, args, e);
                }
                ts.close();
            }
            if (reader != null) {
                try {}
                catch (IOException e) {
                    String[] args = new String[]{e.getMessage()};
                    throw new SDXException(null, 211, args, e);
                }
                reader.close();
            }
        }
        super.setNbPages(this.countPages());
    }

    protected void setFieldFilter(String field) {
        String[] fields = new String[]{field};
        this.fieldFilters = fields;
    }

    public void setUp(Results results, String field, String value) throws SDXException {
        this.setFieldFilter(field);
        String[] fields = new String[]{field};
        String[] values = new String[]{value};
        this.setUp(results, fields, values);
    }

    public void setUp(Results results, String[] fields, String[] values) throws SDXException {
        if (results != null) {
            super.setSearchLocations(results.getSearchLocations());
            if (this._searchLocations == null) {
                throw new SDXException(super.getLog(), 4000, null, null);
            }
            if (fields == null) {
                throw new SDXException(super.getLog(), 4200, null, null);
            }
            if (this._searchLocations.size() > 1) {
                LoggingUtils.logWarn(super.getLog(), 4504, null);
            }
            this.fieldFilters = fields;
            this.termList = this.getTerms(results.getHits(), fields, values);
            super.setNbPages(this.countPages());
        }
    }

    public void setUp(SearchLocations sLocs, Results sdxResults, String field, String value) throws SDXException {
        this.setUp(sLocs, sdxResults.getQuery(), field, value);
    }

    public void setUp(SearchLocations sLocs, Query sdxQuery, String field, String value) throws SDXException {
        if (sdxQuery == null || sdxQuery.getLuceneQuery() == null) {
            throw new SDXException(null, 4100, null, null);
        }
        this.setUp(sLocs, sdxQuery.getLuceneQuery(), field, value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setUp(SearchLocations sLocs, org.apache.lucene.search.Query luceneQuery, String field, String value) throws SDXException {
        QueryWrapperFilter qwf;
        block15: {
            if (sLocs == null) {
                throw new SDXException(super.getLog(), 4000, null, null);
            }
            if (!Utilities.checkString(field)) {
                throw new SDXException(super.getLog(), 4200, null, null);
            }
            this.setFieldFilter(field);
            String internedfieldName = field.intern();
            super.setSearchLocations(sLocs);
            if (this._searchLocations.size() > 1) {
                LoggingUtils.logWarn(super.getLog(), 4504, null);
            }
            this.initCollator(this._searchLocations.getField(field));
            this.termList = new TreeMap(sortCollator);
            try {
                try {
                    qwf = new QueryWrapperFilter(luceneQuery);
                }
                catch (Exception e) {
                    String[] args = new String[]{e.getMessage()};
                    throw new SDXException(null, 218, args, e);
                }
                Object var10_7 = null;
                luceneQuery = null;
            }
            catch (Throwable throwable) {
                Object var10_8 = null;
                luceneQuery = null;
                throw throwable;
            }
            IndexReader r = sLocs.getReader();
            try {
                try {
                    this.termList = this.getTerms(sLocs.getReader(), sLocs.getField(field), qwf.bits(r), value);
                }
                catch (Exception e) {
                    String[] args = new String[]{sLocs.getReader().directory().toString(), e.getMessage()};
                    throw new SDXException(null, 200, args, e);
                }
                Object var12_15 = null;
                if (r == null) break block15;
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                if (r != null) {
                    try {
                        r.close();
                        r = null;
                    }
                    catch (IOException e) {
                        String[] args = new String[]{e.getMessage()};
                        throw new SDXException(null, 211, args, e);
                    }
                }
                qwf = null;
                throw throwable;
            }
            try {}
            catch (IOException e) {
                String[] args = new String[]{e.getMessage()};
                throw new SDXException(null, 211, args, e);
            }
            r.close();
            r = null;
        }
        qwf = null;
        super.setNbPages(this.countPages());
    }

    public void setUp(SearchLocations sLocs, String[] fields, String[] values) throws SDXException {
        this.setUp(sLocs, fields, values, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setUp(SearchLocations sLocs, String[] fields, String[] values, int operator) throws SDXException {
        block12: {
            if (sLocs == null) {
                throw new SDXException(super.getLog(), 4000, null, null);
            }
            if (fields == null) {
                throw new SDXException(super.getLog(), 4200, null, null);
            }
            super.setSearchLocations(sLocs);
            if (sLocs.size() > 1) {
                LoggingUtils.logWarn(super.getLog(), 4504, null);
            }
            this.fieldFilters = fields;
            this.valueFilters = values;
            if (values == null) {
                values = new String[]{};
            }
            if (fields.length != values.length + 1) return;
            BitSet documentSet = null;
            IndexReader r = sLocs.getReader();
            if (fields.length > 1) {
                if (operator != 1 && operator != 0 && operator != 2) {
                    operator = 1;
                }
                this.filter = new Filter(operator);
                for (int i = 0; i < values.length; ++i) {
                    Criteria c = new Criteria();
                    c.enableLogging(super.getLog());
                    c.setUp(sLocs.getField(fields[i]), values[i]);
                    this.filter.add(c);
                }
                documentSet = this.filter.bits(r);
            }
            try {
                this.termList = this.getTerms(r, sLocs.getField(fields[fields.length - 1]), documentSet);
                Object var10_9 = null;
                if (r == null) break block12;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (r == null) throw throwable;
                try {
                    r.close();
                    throw throwable;
                }
                catch (IOException e) {
                    String[] args = new String[]{e.getMessage()};
                    throw new SDXException(null, 211, args, e);
                }
            }
            try {}
            catch (IOException e) {
                String[] args = new String[]{e.getMessage()};
                throw new SDXException(null, 211, args, e);
            }
            r.close();
        }
        super.setNbPages(this.countPages());
    }

    public void toSAX(ContentHandler hdl) throws SAXException {
        this.toSAX(hdl, -1);
    }

    public void toSAX(ContentHandler hdl, int page) throws SAXException {
        int sIdx;
        String sdxNsUri = "http://www.culture.gouv.fr/ns/sdx/sdx";
        String sdxNsPrefix = "sdx";
        if (page < 1) {
            page = 1;
        }
        if (page > super.getNbPages()) {
            page = super.getNbPages();
        }
        if ((sIdx = (page - 1) * super.getHitsPerPage()) < 0) {
            sIdx = 0;
        }
        int eIdx = page * super.getHitsPerPage() - 1;
        if (this.termList != null && eIdx >= this.termList.size()) {
            eIdx = this.termList.size() - 1;
        }
        String localName = "terms";
        String qName = sdxNsPrefix + ":" + localName;
        AttributesImpl atts = new AttributesImpl();
        if (this.fieldFilters != null && this.fieldFilters.length > 0) {
            atts.addAttribute("", "name", "name", "CDATA", this.fieldFilters[this.fieldFilters.length - 1]);
            atts.addAttribute("", "field", "field", "CDATA", this.fieldFilters[this.fieldFilters.length - 1]);
        }
        atts.addAttribute("", "qid", "qid", "CDATA", String.valueOf(super.getId()));
        atts.addAttribute("", "page", "page", "CDATA", String.valueOf(page));
        atts.addAttribute("", "hpp", "hpp", "CDATA", String.valueOf(super.getHitsPerPage()));
        atts.addAttribute("", "pages", "pages", "CDATA", String.valueOf(super.getNbPages()));
        if (this.termList != null) {
            atts.addAttribute("", "nb", "nb", "CDATA", String.valueOf(this.termList.size()));
        }
        atts.addAttribute("", "start", "start", "CDATA", String.valueOf(sIdx + 1));
        atts.addAttribute("", "end", "end", "CDATA", String.valueOf(eIdx + 1));
        atts.addAttribute("", "id", "id", "CDATA", String.valueOf(super.getId()));
        atts.addAttribute("", "currentPage", "currentPage", "CDATA", String.valueOf(page));
        atts.addAttribute("", "nbPages", "nbPages", "CDATA", String.valueOf(super.getNbPages()));
        hdl.startElement(sdxNsUri, localName, qName, atts);
        if (this.filter != null) {
            this.filter.toSAX(hdl);
        }
        if (super.getHitsPerPage() != 0 && this.termList != null) {
            Iterator it = this.termList.keySet().iterator();
            int i = 0;
            while (it.hasNext()) {
                if (++i > sIdx && i <= eIdx + 1) {
                    TermInfo term = (TermInfo)this.termList.get(it.next());
                    String subLocalName = "term";
                    String subQName = sdxNsPrefix + ":" + subLocalName;
                    AttributesImpl subAtts = new AttributesImpl();
                    subAtts.addAttribute("", "no", "no", "CDATA", String.valueOf(i));
                    String fieldname = term.getField();
                    int fieldType = -1;
                    try {
                        fieldType = this._searchLocations.getFieldType(fieldname);
                    }
                    catch (SDXException sdxE) {
                        throw new SAXException(sdxE.getMessage(), (Exception)((Object)sdxE));
                    }
                    String content = this._searchLocations != null && fieldType == 2 ? Date.formatDate(DateField.stringToDate(term.getContent())) : term.getContent();
                    String esc = null;
                    esc = Utilities.encodeURL(content, super.getEncoding());
                    subAtts.addAttribute("", "value", "value", "CDATA", content);
                    subAtts.addAttribute("", "escapedValue", "escapedValue", "CDATA", esc);
                    subAtts.addAttribute("", "field", "field", "CDATA", fieldname);
                    subAtts.addAttribute("", "docs", "docs", "CDATA", String.valueOf(term.getDocFrequency()));
                    if (term.getDocFrequency() == 1) {
                        subAtts.addAttribute("", "id", "id", "CDATA", term.getDocId());
                        subAtts.addAttribute("", "base", "base", "CDATA", term.getDbId());
                        subAtts.addAttribute("", "app", "app", "CDATA", term.getAppId());
                        subAtts.addAttribute("", "docId", "docId", "CDATA", term.getDocId());
                    }
                    subAtts.addAttribute("", "docFreq", "docFreq", "CDATA", String.valueOf(term.getDocFrequency()));
                    hdl.startElement(sdxNsUri, subLocalName, subQName, subAtts);
                    hdl.endElement(sdxNsUri, subLocalName, subQName);
                    continue;
                }
                if (i > eIdx + 1) break;
                it.next();
            }
        }
        hdl.endElement(sdxNsUri, localName, qName);
    }

    public TreeMap getList() {
        return this.termList;
    }

    private static RE getRE(String str) throws RESyntaxException {
        if (str == null) {
            return null;
        }
        StringBuffer st = new StringBuffer("^");
        block5: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '*': {
                    st.append("(.*)");
                    continue block5;
                }
                case '?': {
                    st.append("(.?)");
                    continue block5;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    st.append('\\');
                    st.append(c);
                    continue block5;
                }
                default: {
                    st.append(c);
                }
            }
        }
        st.append("$");
        return new RE(st.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TreeMap getTerms(IndexReader r, Field f, String pattern) throws SDXException {
        TreeMap<Object, TermInfo> ret = null;
        if (r == null) return ret;
        if (f == null) return ret;
        if (pattern == null) {
            return ret;
        }
        String internedfieldName = "";
        if (Utilities.checkString(f.getCode())) {
            internedfieldName = f.getCode().intern();
        }
        ret = f.getLocale() != null ? new TreeMap<Object, TermInfo>(Collator.getInstance(f.getLocale())) : new TreeMap(Collator.getInstance(new Locale("fr", "FR")));
        TermEnum ts = null;
        try {
            block14: {
                try {
                    RE re = Terms.getRE(pattern);
                    ts = r.terms(new Term(internedfieldName, ""));
                    boolean collecting = false;
                    if (ts == null) break block14;
                    do {
                        if (ts.term() != null && ts.term().field() == internedfieldName) {
                            collecting = true;
                            if (ts.term() == null || re == null || !re.match(ts.term().text())) continue;
                            TermInfo ti = (TermInfo)ret.get(ts.term().text());
                            if (ti != null) {
                                ti.update(r, ts.term());
                                continue;
                            }
                            ti = new TermInfo();
                            ti.setUp(r, ts.term());
                            ret.put(ts.term().text(), ti);
                            continue;
                        }
                        if (collecting) break;
                    } while (ts.next());
                }
                catch (RESyntaxException e) {
                    String[] args = new String[]{e.getMessage()};
                    throw new SDXException(null, 4202, args, e);
                }
                catch (IOException e) {
                    String[] args = new String[]{e.getMessage()};
                    throw new SDXException(null, 4202, args, e);
                }
            }
            Object var10_13 = null;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            try {
                if (ts == null) throw throwable;
                ts.close();
                throw throwable;
            }
            catch (IOException e) {
                String[] args = new String[]{f.getCode(), e.getMessage()};
                throw new SDXException(null, 210, args, e);
            }
        }
        try {}
        catch (IOException e) {
            String[] args = new String[]{f.getCode(), e.getMessage()};
            throw new SDXException(null, 210, args, e);
        }
        if (ts == null) return ret;
        ts.close();
        return ret;
    }

    private TreeMap getTerms(Hits hits, String[] fields, String[] values) throws SDXException {
        TreeMap ret = new TreeMap();
        if (hits == null || hits.length() == 0) {
            return ret;
        }
        Hashtable fieldMaps = new Hashtable();
        for (int i = 0; i < hits.length(); ++i) {
            try {
                Document hitDoc = hits.doc(i);
                if (hitDoc == null) continue;
                for (int j = 0; j < fields.length; ++j) {
                    Field f = this._searchLocations.getField(fields[j]);
                    String lfname = f.getCode();
                    if (f == null) continue;
                    TreeMap<Object, Object> map = null;
                    map = fieldMaps.size() > 0 && fieldMaps.containsKey(lfname) ? (TreeMap<Object, TermInfo>)fieldMaps.get(lfname) : (f.getCollator() == null ? new TreeMap(Collator.getInstance(new Locale("fr", "FR"))) : new TreeMap<Object, TermInfo>(f.getCollator()));
                    String[] fieldsValues = hitDoc.getValues(lfname);
                    if (fieldsValues != null) {
                        HashSet<String> termsCollected = new HashSet<String>();
                        for (int k = 0; k < fieldsValues.length; ++k) {
                            String lftext = fieldsValues[k];
                            if (!Utilities.checkString(lftext) || values != null && values.length != 0 && (j >= values.length || Utilities.checkString(values[j]) && !lftext.equals(values[j])) || termsCollected.contains(lftext)) continue;
                            TermInfo ti = (TermInfo)map.get(lftext);
                            if (ti != null) {
                                ti.update(lfname, lftext);
                            } else {
                                ti = new TermInfo();
                                ti.enableLogging(super.getLog());
                                ti.setUp(lfname, lftext);
                                ti.update(lfname, lftext);
                                ti.setDocId(hitDoc.getField("sdxdocid").stringValue());
                                ti.setDbId(hitDoc.getField("sdxdbid").stringValue());
                                ti.setAppId(hitDoc.getField("sdxappid").stringValue());
                                map.put(lftext, ti);
                            }
                            termsCollected.add(lftext);
                        }
                    }
                    if (map == null) continue;
                    fieldMaps.put(lfname, map);
                }
                continue;
            }
            catch (IOException e) {
                String[] args = new String[]{e.getMessage()};
                new SDXException(null, 4202, args, e);
            }
        }
        Enumeration maps = fieldMaps.elements();
        if (maps != null) {
            while (maps.hasMoreElements()) {
                TreeMap outmap = (TreeMap)maps.nextElement();
                ret.putAll(outmap);
            }
            maps = null;
        }
        return ret;
    }

    public TreeMap getTerms(IndexReader r, Field f, BitSet docs) throws SDXException {
        return this.getTerms(r, f, docs, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TreeMap getTerms(IndexReader r, Field f, BitSet docs, String str) throws SDXException {
        TreeMap<Object, TermInfo> treeMap;
        if (f == null) {
            return new TreeMap();
        }
        String internedfieldName = "";
        if (Utilities.checkString(f.getCode())) {
            internedfieldName = f.getCode().intern();
        }
        TreeMap<Object, TermInfo> ret = f.getCollator() == null ? new TreeMap(Collator.getInstance(new Locale("fr", "FR"))) : new TreeMap<Object, TermInfo>(f.getCollator());
        RE re = null;
        if (Utilities.checkString(str)) {
            try {
                re = Terms.getRE(str);
            }
            catch (RESyntaxException e) {
                String[] args = new String[]{e.getMessage()};
                throw new SDXException(null, 4201, args, e);
            }
        }
        TermEnum ts = null;
        try {
            try {
                ts = r.terms(new Term(internedfieldName, ""));
                boolean collecting = false;
                do {
                    if (ts.term() != null && ts.term().field() == internedfieldName) {
                        int nbDocs;
                        collecting = true;
                        BitSet termDocumentSet = Terms.getDocumentSet(r, ts.term());
                        if (docs != null) {
                            termDocumentSet.and(docs);
                        }
                        if ((nbDocs = Bits.countBits(termDocumentSet)) <= 0) continue;
                        String text = ts.term().text();
                        if (re != null && !re.match(text)) continue;
                        TermInfo ti = (TermInfo)ret.get(ts.term().text());
                        if (ti != null) {
                            ti.update(r, ts.term());
                            continue;
                        }
                        ti = new TermInfo();
                        ti.enableLogging(super.getLog());
                        ti.setUp(r, ts.term());
                        ret.put(ts.term().text(), ti);
                        continue;
                    }
                    if (collecting) break;
                } while (ts.next());
                treeMap = ret;
                Object var15_18 = null;
            }
            catch (IOException e) {
                String[] args = new String[]{e.getMessage()};
                throw new SDXException(null, 4202, args, e);
            }
        }
        catch (Throwable throwable) {
            Object var15_19 = null;
            try {
                if (ts == null) throw throwable;
                ts.close();
                throw throwable;
            }
            catch (IOException e2) {
                String[] args = new String[]{f.getCode(), e2.getMessage()};
                throw new SDXException(null, 210, args, e2);
            }
        }
        try {}
        catch (IOException e2) {
            String[] args = new String[]{f.getCode(), e2.getMessage()};
            throw new SDXException(null, 210, args, e2);
        }
        if (ts == null) return treeMap;
        ts.close();
        return treeMap;
    }

    public static BitSet getDocumentSet(IndexReader r, Term term) throws IOException {
        BitSet bits = new BitSet(r.numDocs());
        TermDocs docs = r.termDocs(term);
        while (docs.next()) {
            bits.set(docs.doc());
        }
        return bits;
    }

    public int countPages() {
        if (this.termList == null) {
            return 0;
        }
        if (this.termList.size() == 0) {
            return 0;
        }
        if (super.getHitsPerPage() == 0) {
            return 1;
        }
        float temp = (float)this.termList.size() / (float)super.getHitsPerPage();
        if (temp != (float)Math.round(temp)) {
            return (int)Math.round(Math.floor(temp) + 1.0);
        }
        return Math.round(temp);
    }

    public void setHitsPerPage(int nb) {
        if (nb < 0) {
            this.setAllHits();
        } else {
            super.setHitsPerPage(nb);
            super.setNbPages(this.countPages());
        }
    }

    protected void initCollator(Field field) {
        if (field != null) {
            sortCollator = field.getCollator();
        }
    }

    public void setAllHits() {
        if (this.termList != null) {
            super.setHitsPerPage(this.termList.size());
        }
        super.setNbPages(1);
    }

    protected String getClassNameSuffix() {
        return "Terms";
    }
}

