/*
 * Decompiled with CFR 0.152.
 */
package org.ahunt.simpleRowLog.launcher;

import java.awt.Graphics2D;
import java.awt.SplashScreen;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.grlea.log.DebugLevel;
import org.grlea.log.SimpleLogger;

public class SplashManager {
    private static final SimpleLogger log = new SimpleLogger(SplashManager.class);
    private static int topLeftX = 71;
    private static int topLeftY = 252;
    private static int width = 290;
    private static int height = 16;
    final SplashScreen splash;
    private boolean noSplash;
    private Graphics2D g;
    private BufferedImage progressbarOn;
    private BufferedImage progressbarOff;

    public SplashManager(int progress) {
        log.entry("SplashManager(int");
        this.splash = SplashScreen.getSplashScreen();
        if (this.splash == null) {
            log.debug("Splash screen is null.");
            this.noSplash = true;
            return;
        }
        this.g = this.splash.createGraphics();
        if (this.g == null) {
            log.debug("Couldn't create graphics.");
            this.noSplash = true;
            return;
        }
        try {
            this.progressbarOn = ImageIO.read(new File("img/splash/splash_progressBarOn.png"));
            this.progressbarOff = ImageIO.read(new File("img/splash/splash_progressBarOff.png"));
        }
        catch (Exception e) {
            log.debug("Progress images couldn't be loaded.");
            log.dbe(DebugLevel.L5_DEBUG, e);
            this.noSplash = true;
        }
        this.setProgress(progress);
    }

    public void setProgress(int progress) {
        if (this.noSplash) {
            return;
        }
        this.g.drawImage(this.progressbarOn, topLeftX, topLeftY, width * progress / 100, height, null);
        this.g.drawImage(this.progressbarOff, topLeftX + width * progress / 100, topLeftY, width - width * progress / 100, height, null);
        this.g.drawString(progress + "%", topLeftX + width / 2 - 10, topLeftY + height - 4);
        this.splash.update();
    }
}

