
#include "MainControl.h"

@implementation MainControl;

+ new: (id) _classid {
  self = [MainControl alloc];
  return [self init: _classid];
}

- init: (id)ctlClass {
  /* call our static class method that will create our control 
     object running with a thread tending it */
  jmethodID startGui = [ctlClass findStaticMethod: "startGUI" 
				 signature: "()LCtlPanel;"];
  [super init: ctlClass : [ctlClass callObjectStaticMethod: startGui]];

  _getState = 0;
  _setState = 0;
  _waitRun = 0;
  return self;
}

- (int) getState {
  jint state;

  if (_getState == 0) {
    _getState = [classid findMethod: "getState" signature: "()I"];
  }

  state = [self callIntMethod: _getState];
  return state;
}

- (void) waitRun {
  if (_waitRun == 0)
    _waitRun = [classid findMethod: "waitRUN" signature: "()V"];

  [self callVoidMethod: _waitRun];
}

- (void) setState: (int)state {
  if (_setState == 0)
    _setState = [classid findMethod: "setState" signature: "(I)V"];

  [self callVoidMethod: _setState : state];
}

@end
