//  Swarm library. Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; 
// without even the implied warranty of merchantability 
// or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

/*
Name:            RandomNumberGenerator.h
Description:     Common superclass for random number generators
Library:         random
Original Author: Sven Thommesen
Date:            1997-01-15
*/

/*
123456789|123456789|123456789|123456789|123456789|123456789|123456789|123456789|
*/

// THIS CLASS IS NOT MEANT TO BE INSTANTIATED !
// It is a superclass for actual generators.

#import <swarmobject/SwarmObject.h>
#import <random/RandomDefs.h>


@interface RandomNumberGenerator : SwarmObject //<RandomNumberGenerator>

{

// Parameters:

  unsigned unsignedMax;		// set by initState
  unsigned stateSize;		// set by initState

// Working variables:

  unsigned initialSeed;		// set by setStateFromSeed
  unsigned currentCount;	// set by setStateFromSeed & getUnsignedSample

}

// Methods conforming to protocol RandomNumberGenerator:

+create: (id) aZone setStateFromSeed: (unsigned) seed;
+createBegin: (id) aZone;
-setStateFromSeed: (unsigned) seed;
-createEnd;

-(unsigned) getUnsignedMax;
-(unsigned) getUnsignedSample;

// Methods conforming to protocol InternalState:

-(unsigned) getStateSize;

-(void) getState: (void *) stateBuf;
-(void) setState: (void *) stateBuf;

// Methods overridden by subclasses:

-initState;
-resetState;

// temporary methods:

- (void) describe: outStream;
-(int) verifySelf;

@end
