// Swarm library. Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

// Control Panel class, for use in GUIs. Controls the state of running
// activities, provides the "stop" and "go" buttons. Also handles updating
// the Tk event loop.

#import <swarmobject/SwarmObject.h>
#import <swarmgraph.h>

// these tokens are the various states of the ControlPanel. "getState"
// returns one of these four values.

@interface ControlPanel : SwarmObject {
#ifdef _TK_
  ButtonPanel * panel;
  id state;			 // uses activity.h symbols
#else
  CtlState state;		// current state (run/stop/step/time)
  id ctlObj;			// the proxy to the java control panel
#endif
}
#ifdef _TK_
-(ButtonPanel *) getPanel;
-doTkEvents;
#else
-checkState;
#endif

-createEnd;
-(CtlState) getState;
-setState: (CtlState) s;
-waitForControlEvent;

-setStateRunning;
-setStateStopped;
-setStateStepping;
-setStateQuit;
-setStateNextTime;

@end
