
#import <swarmgraph/global.h>

#include "JavaClass.h"
#include "JavaRaster.h"

@implementation JavaRaster;

+ newW: (int)w H: (int)h  {
  self = [JavaRaster alloc];
  [self initW: w H: h];
  return self;
}

- initW: (int)w H: (int)h  {

  // look up our class id
  id jRasterClass = [JavaClass new: "JavaJRaster" env: javaEnv];

  // call the constructor that takes a width and height
  jobject rasterobj = [jRasterClass construct: (int)w : (int)h];

  // establish the JavaObject of this class backed by this real object
  [super init: jRasterClass : rasterobj];

  _erase = 0;
  _drawPoint = 0;
  _fillRectangle = 0;
  _drawSelf = 0;

  return self;
}

-free {
  [super free];
  return self;
}

// erase our backing image
- erase {
  if (_erase == 0)
    _erase = [classid findMethod: "erase" signature: "()V"];

  [self callVoidMethod: _erase];
  return self;
}


- setWidth: (unsigned)w Height: (unsigned)h {
  if (_setSize == 0)
    _setSize = [classid findMethod: "setSize" signature: "(II)V"];

  [self callVoidMethod: _setSize: (int)w : (int)h];
  return self;
}


// draw a point on our backing image
- drawPointX: (int) x Y: (int) y Color: (PixelValue) c {
  if (_drawPoint == 0)
    _drawPoint = [classid findMethod: "drawPoint" signature: "(III)V"];

  [self callVoidMethod: _drawPoint : x : y : c];
  return self;
}

// draw a rectangle on our backing image
- fillRectangleX0: (int)x0 Y0: (int) y0 
	       X1: (int)x1 Y1: (int)y1 Color: (PixelValue)c {
  if (_fillRectangle == 0)
    _fillRectangle = [classid findMethod: "fillRectangle" 
			      signature: "(IIIII)V"];

  [self callVoidMethod: _fillRectangle : x0 : y0 : x1 : y1 : c];
  return self;
}


// update our image on the screen
- drawSelf {
  if (_drawSelf == 0)
    _drawSelf = [classid findMethod: "drawSelf" signature: "()V"];
  [self callVoidMethod: _drawSelf];
  return self;
}

@end
