
/*
 *  JavaObject:  encapsulate some random java object and provide some
 *  simple, common access to methods on that object
 */

#include "JavaClass.h"

@interface JavaObject : Object {
  JNIEnv * env;
  id classid;		/* this object's class */ 
  jobject this;		/* this object */
}

+ new: (id) _classid : (jobject) _this;

- init: (id) _classid : (jobject) _this;
- (jint) callIntMethod: (jmethodID) id;
- (void) callVoidMethod: (jmethodID) id;
- (void) callVoidMethod: (jmethodID) id : (int)val1;

@end

