// Market application. Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#include "define.h"
#include "extern.h"
#include <simtools.h>

void Initiate_agents(hombre agent[]) {
  /* Assigns predictors to be monitored by
     each agent. Other functions will later
     fill in predictor chosen and decision
     */
  
  int i,k, index, count; int flag[TOTPREDICTORS];
	
  for (i = 0; i < TOTPERSONS ; ++i) {
    /* for each agent */
    for (k = 0; k < TOTPREDICTORS ; ++k)  {
      /* reset predictor and heed flags	*/
      flag[k] = 0;
      agent[i].heed[k] = 0;
    }
    count = 1;					  /* Choose predictors	*/
    while (count <= MAXHEED) {		
      /* fetch a random index */
      index = [uniformIntRand getIntegerWithMin: 0L withMax: (TOTPREDICTORS-1)];
      if (flag[index] == 0)			  /* if not yet chosen */
	++count;				  /* choose it and */ 
      agent[i].heed[index] =	1;		  /* set heed-flag to 1. */
      flag[index] = 1;					
    }										/* Repeat until MAXHEED is reached */    
  }
}


void print_agent_predictors (hombre *agent) {
  int i,j;
		
  for (i = 0; i < TOTPERSONS ; ++i)	{	
    fprintf(ofp,"\n Agent % 2d	predictors:", i);
    for (j = 0; j< TOTPREDICTORS; ++j)
      if (agent[i].heed[j] == 1) fprintf(ofp, "  % 4d", j );	
  }
}

void Choose_Best_Predictors(prediction *forecast,hombre *guy) {

  /****** Takes in updated forecasts and for each guy chooses best forecaster *****/
  int i,j, best, index = 0;

  for (i=0; i < TOTPERSONS; ++i) {		  /* for each agent */
				 		
    best = TOTPREDICTORS +1;			  /* reset best indicator */
    for (j=0; j <TOTPREDICTORS; ++j) {		  /* choose best predictor */
      if (forecast[j].rank < best && guy[i].heed[j] == 1)
	best = forecast[j].rank, index = j;
    }
    guy[i].forecaster = index;			  /* record index of best predictor*/
  }
}

void Count_Predictor_Use (hombre *guy, int *use)	{
		int i,j, index;
		
		for (j=0; j < TOTPREDICTORS; ++j) use[j] = 0;	/* reset predictor use counter	*/
		
		for (i=0; i < TOTPERSONS; ++i)	{			/* 		for each agent						*/
		index = guy[i].forecaster;					/* record index of his active predictor		*/
		use[index]++;								/* count one more user for this predictor	*/ 
	}

}
/*------------------------------------------------------------------------------------*/
float Declare_New_Dividend(float old_dividend) {

  /* Create a new dividend from the old one making occasional jumps */

  float new_dividend;
  int prob;
  prob = [uniformIntRand getIntegerWithMin: 0L withMax: 100L];
  if (prob < 95) 
    new_dividend = old_dividend;
  else 
    new_dividend = old_dividend + NU * (2.0 * RANDOM - 1.0);
  if (new_dividend < 5.0)
    new_dividend = 21.0;
		 
  return new_dividend;
}
/*------------------------------------------------------------------------------------*/
float Make_New_Price(prediction *forecast, hombre *guy)	{

  /******* 		Get best forecasts and calculate the new price			 *******/
	
  int i,  index;
  float expect, new_price, av_expected_price, sum = 0.0;

  for (i=0; i < TOTPERSONS; ++i)	{				/* 		for each agent			*/
    index = guy[i].forecaster;					/* get index of active predictor			*/
    expect = forecast[index].numbers;			/* make best forecast			*/
    sum += expect;
  }
  av_expected_price = sum/TOTPERSONS;								
						
  new_price = Dividend + BETA*(av_expected_price);  	/*	The new price is formed		 */
  return new_price; 
		
}
/*------------------------------------------------------------------------------------*/
