
//  Swarm library. Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; 
// without even the implied warranty of merchantability 
// or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

/*
Name:            RandomDefs.h
Description:     Commonly used definitions and numbers
Library:         random
Original Author: Sven Thommesen
Date:            1997-01-15
*/

/*
123456789|123456789|123456789|123456789|123456789|123456789|123456789|123456789|
*/

#import <unistd.h>
#import <time.h>

#define TESTVALUE   99U
#define DEFAULTSEED 3216540789U
#define RANDOMSEED  ( getpid() * time(0) )

// The 'magic' numbers below are completely arbitrary!
// They are used by the getState/setState methods.

#define GENERATORMASK        1000001U
#define LAGFIBMASK             10000U
#define LCGGENMASK             20000U
#define ACGMAGIC             1010101U
#define SCGMAGIC             1010201U
#define SWB1MAGIC            1010311U
#define SWB2MAGIC            1010321U
#define SWB3MAGIC            1010331U
#define LCG1MAGIC            1020411U
#define LCG2MAGIC            1020421U
#define LCG3MAGIC            1020431U
#define PMMLCG1MAGIC         1020511U
#define PMMLCG2MAGIC         1020521U
#define PMMLCG3MAGIC         1020531U

#define DISTRIBUTIONMASK     2000002U
#define INTEGERDISTMASK        10000U
#define DOUBLEDISTMASK         20000U
#define UNIFORMMASK               10U

#define RANDOMBITMAGIC       2010112U
#define UNIFORMINTEGERMAGIC  2010212U
#define UNIFORMUNSIGNEDMAGIC 2010312U

#define UNIFORMDOUBLEMAGIC   2020412U
#define NORMALDISTMAGIC      2020502U
#define LOGNORMALDISTMAGIC   2020602U
#define EXPONENTIALDISTMAGIC 2020702U
#define GAMMADISTMAGIC       2020802U

// This union structure is used by the code
// that fills a double variable with two random bit values:

typedef union {
   double d;
   unsigned u[2];
} UnsignedOverlayDouble;

//------------------------------------------------------------------
