// Swarm library. Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#import <simtools/global.h>
#import <simtools/ControlPanel.h>
#import <swarmobject/probing.h>

#import <stdlib.h>
#import <time.h>
#import <activity.h>

id <PMMLCG1> randomGenerator;
id <UniformInteger> uniformIntRand;
id <UniformUnsigned> uniformUnsRand;
id <UniformDouble> uniformDblRand;
ProbeDisplayManager * probeDisplayManager;
int swarmGUIMode;

void
initSwarm(int argc, char ** argv) {
  int i ;

  initModule(activity);

  initProbing() ;

  randomGenerator = [PMMLCG1 createBegin: globalZone];
  [randomGenerator setStateFromSeed: 1234567890L ];
  randomGenerator = [randomGenerator createEnd];

  // Explicitly leave out the interval so that get{Type}WithMin:withMax:
  // can be used.
  uniformIntRand = [UniformInteger createBegin: globalZone];
  [uniformIntRand setGenerator: randomGenerator];
  uniformIntRand = [uniformIntRand createEnd];
  uniformUnsRand = [UniformUnsigned createBegin: globalZone];
  [uniformUnsRand setGenerator: randomGenerator];
  uniformUnsRand = [uniformUnsRand createEnd];
  uniformDblRand = [UniformDouble createBegin: globalZone];
  [uniformDblRand setGenerator: randomGenerator];
  uniformDblRand = [uniformDblRand createEnd];

  swarmGUIMode = 1;

  for(i = 1 ; i < argc ; i++)
    if( !strcmp(argv[i],"-batchmode") )
      swarmGUIMode = 0 ;

  // various states used in ControlPanel.
  defsymbol(ControlStateRunning);
  defsymbol(ControlStateStopped);
  defsymbol(ControlStateStepping);
  defsymbol(ControlStateQuit);
  defsymbol(ControlStateNextTime);
}


