
#import <swarmgraph/global.h>

#import <swarmgraph/JavaClass.h>
#import <swarmgraph/JavaBar.h>

@implementation JavaBar;

+ new {
  self = [JavaBar alloc];
  [self init];
  return self;
}

- init  {

  // look up our class id
  id jBarClass = [JavaClass new: "JavaJBar"];

  // call the constructor that takes a width and height
  jobject barobj = [jBarClass construct];

  // establish the JavaObject of this class backed by this real object
  [super init: jBarClass : barobj];

  _reset = 0;
  _addBar = 0;
  _update = 0;
  return self;
}

-free {
  [super free];
  return self;
}

// start a fresh graph
-reset {
  if (_reset == 0)
    _reset = [classid findMethod: "reset" signature: "()V"];

  [self callVoidMethod: _reset];
  return self;
}

// set the scale
-addBar: (char *)label value: (double)dval color: (char *)color {
fprintf(stderr, "ADDING BAR\n");
  if (_addBar == 0)
    _addBar = [classid findMethod: "addBar" signature: "(Ljava/lang/String;Ljava/lang/String;D)V"];

fprintf(stderr, "CALLING ADDING BAR %d\n", _addBar);
  [self callVoidMethod: _addBar S: label S: color D: dval];
fprintf(stderr, "done ADDING BAR\n");

  //  XXX until we figure out where it should really happen
  [self update];
  return self;
}

// start a fresh graph
-update {
  if (_update == 0)
    _update = [classid findMethod: "update" signature: "()V"];

  [self callVoidMethod: _update];
  return self;
}


@end
