
import java.awt.*;

class JavaJGraphElem {

  private static final int ARR_CHUNK = 1020;

  double x[];
  double y[];

  int arr_cnt, arr_max;

  Color color;

  JavaJGraphElem() {
    arr_cnt = 0;
    arr_max = ARR_CHUNK;
    x = new double[ARR_CHUNK];
    y = new double[ARR_CHUNK];

    color = Color.black;
  }

  public int arrCnt() {
    return arr_cnt;
  }

  public boolean hasIdx(int idx) {
    return idx < arr_cnt;
  }

  public double x(int idx) {
    return x[idx];
  }

  public double y(int idx) {
    return y[idx];
  }

  // make sure our data vector is of at least length "n"
  public synchronized void setLength(int n) {
    if (n > arr_max) {
      int new_size = arr_max;

      System.out.println("increasing array");
      while (new_size <= n)
	new_size += new_size;

      double new_x[] = new double[new_size];
      double new_y[] = new double[new_size];
      for (int i=0; i<arr_cnt; i++) {
	new_x[i] = x[i];
	new_y[i] = y[i];
      }

      x = new_x;
      y = new_y;
    }

    arr_cnt = n;
  }

  // manage our data values
  public synchronized void addData(double xval, double yval) {
    int idx = arr_cnt;

    setLength(idx+1);
    x[idx] = xval;
    y[idx] = yval;
  }

  // set the length of this vector
  public synchronized void setElemLen(int n) {
    int old_len = arr_cnt;

    setLength(n);

    // pad out extensions with zeros
    for (int i=old_len; i<n; i++) {
      x[i] = 0.0;
      y[i] = 0.0;
    }
  }

  public synchronized void setColor(String color) {
    if (color.equals("black"))
      this.color = Color.black;
    else if (color.equals("blue"))
      this.color = Color.blue;
    else if (color.equals("red"))
      this.color = Color.red;
    else if (color.equals("green"))
      this.color = Color.green;
    else if (color.equals("pink"))
      this.color = Color.pink;
  }

  public synchronized Color getColor() {
    return this.color;
  }

}
