
import java.awt.*;
import java.awt.event.*;

// JavaJFrame: a containter that holds various components
// that are added at particular locations

// use the FractionalLayoutManger that allows much more precise (and
// fragile) placement of components to line up with the expectations of
// the tk/tcl world

class JavaJFrame extends Frame 
  implements ComponentListener
{

  private int _w;
  private int _h;
  private FractionalLayout _layout;
  private Image _i;
  private Color _color;

  JavaJFrame(int w, int h) {
    super();
    setSize(w, h);

    _w = w;
    _h = h;
    _color = Color.black;

    _layout = new FractionalLayout();
    setLayout(_layout);

    // back up this frame with a memory image 
    _i = createImage(_w, _h);

    setVisible(true);
  }

  public Image bgImage() {
    return _i;
  }

  public void setSize(int w, int h) {
    super.setSize(w, h);
    Image i = createImage(w, h);
    if (_i != null) {
      // copy old image into this
    }
    _i = i;
  }

  public void placeObj(Component c, int x, int y) {

    // make a constraint that will stick the new object
    // at the desired location
    _layout.setConstraint(c, new OriginConstraint(0.0, x, 0.0, y));

    // add it to this container
    add(c);
    repaint();
  }

  public void moveObj(Component c, int x, int y) {
    _layout.setConstraint(c, new OriginConstraint(0.0, x, 0.0, y));
  }

  public void setColor(String color) {
    if (color.equals("blue"))
      _color = Color.blue;
    else if (color.equals("black"))
      _color = Color.black;
    else if (color.equals("red"))
      _color = Color.blue;
    else if (color.equals("green"))
      _color = Color.green;
    else if (color.equals("orange"))
      _color = Color.orange;
    else if (color.equals("white"))
      _color = Color.white;
    else
      _color = Color.pink;
  }

  public void drawLine(int fx, int fy, int tx, int ty) {
    Graphics g = _i.getGraphics();

    g.setColor(_color);
    g.drawLine(fx, fy, tx, ty);
    g.setColor(Color.black);

    paintAll(g);
    repaint();
  }

  public void update(Graphics g) {
    if (_i != null) {
      paintAll(_i.getGraphics());
      g.drawImage(_i, 0, 0, null);
    }
  }

  public void paint(Graphics g) {
    g.drawImage(_i, 0, 0, null);
  }

  public void componentResized(ComponentEvent e) {
    System.out.println("Mem: resized!!!");
  }
  public void componentMoved(ComponentEvent e) {
    System.out.println("Mem: moved!!!");
  }
  public void componentShown(ComponentEvent e) {
    System.out.println("Mem: shown!!!");
  }
  public void componentHidden(ComponentEvent e) {
  }


}

