/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.LambdaExp;
import gnu.expr.QuoteExp;
import gnu.expr.Special;
import gnu.expr.Target;
import gnu.mapping.Printable;
import java.io.PrintWriter;
import kawa.standard.Scheme;

public class ObjectExp
extends LambdaExp {
    public Expression[] supers;
    public LambdaExp initMethod;

    public ObjectExp() {
        this.type = null;
        this.setCanRead(true);
    }

    public ClassType compile(Compilation compilation) {
        ClassType classType = compilation.curClass;
        Method method = compilation.method;
        try {
            Object object2;
            Object object3;
            ClassType classType2;
            compilation.curClass = classType2 = this.getCompiledClassType(compilation);
            String string = this.getFile();
            if (string != null) {
                classType2.setSourceFile(string);
            }
            LambdaExp lambdaExp = compilation.curLambda;
            compilation.curLambda = this;
            this.allocFrame(compilation);
            if (this.getNeedsStaticLink() && lambdaExp.heapFrameLambda != this) {
                Variable variable;
                Variable variable2 = variable = lambdaExp.heapFrame != null ? lambdaExp.heapFrame : lambdaExp.closureEnv;
                if (variable != null) {
                    this.closureEnvField = this.staticLinkField = classType2.addField("closureEnv", variable.getType());
                }
            }
            compilation.generateConstructor(compilation.curClass, this);
            Declaration declaration = this.firstDecl();
            while (declaration != null) {
                if (declaration.getCanRead()) {
                    declaration.field = classType2.addField(declaration.getName(), declaration.getType(), 1);
                    declaration.setSimple(false);
                }
                declaration = declaration.nextDecl();
            }
            LambdaExp lambdaExp2 = this.firstChild;
            while (lambdaExp2 != null) {
                object3 = this.type;
                lambdaExp2.declareThis((ClassType)object3);
                object2 = lambdaExp2.getName();
                lambdaExp2.addMethodFor(compilation, null);
                lambdaExp2 = lambdaExp2.nextSibling;
            }
            object3 = this.firstChild;
            while (object3 != null) {
                Method method2 = compilation.method;
                LambdaExp lambdaExp3 = compilation.curLambda;
                compilation.method = ((LambdaExp)object3).getMainMethod();
                compilation.curClass = compilation.method.getDeclaringClass();
                compilation.curLambda = object3;
                compilation.method.initCode();
                ((LambdaExp)object3).allocChildClasses(compilation);
                ((LambdaExp)object3).allocParameters(compilation);
                ((LambdaExp)object3).enterFunction(compilation);
                object2 = compilation.method.getReturnType();
                ((LambdaExp)object3).body.compileWithPosition(compilation, Target.returnValue((Type)object2));
                ((LambdaExp)object3).compileEnd(compilation);
                ((LambdaExp)object3).compileChildMethods(compilation);
                compilation.method = method2;
                compilation.curClass = classType2;
                compilation.curLambda = lambdaExp3;
                object3 = ((LambdaExp)object3).nextSibling;
            }
            compilation.curLambda = lambdaExp;
            ClassType classType3 = classType2;
            Object var6_15 = null;
            compilation.curClass = classType;
            compilation.method = method;
            return classType3;
        }
        catch (Throwable throwable) {
            Object var6_16 = null;
            compilation.curClass = classType;
            compilation.method = method;
            throw throwable;
        }
    }

    public void compile(Compilation compilation, Target target) {
        super.compile(compilation, Target.pushObject);
        if (this.initMethod != null) {
            CodeAttr codeAttr = compilation.getCode();
            codeAttr.emitDup(1);
            codeAttr.emitInvokeVirtual(this.initMethod.getMainMethod());
        }
        target.compileFromStack(compilation, this.getCompiledClassType(compilation));
    }

    public ClassType getCompiledClassType(Compilation compilation) {
        if (this.getType().getName() == null) {
            String string = this.getName();
            if (string == null) {
                string = "object";
            }
            this.type.setName(compilation.generateClassName(string));
        }
        return this.type;
    }

    public String getJavaName() {
        return this.name == null ? "object" : Compilation.mangleName(this.name);
    }

    public Type getType() {
        if (this.type == null) {
            this.type = new ClassType();
            if (this.supers == null || this.supers.length == 0) {
                this.type.setSuper(Type.pointer_type);
            } else {
                ClassType[] classTypeArray;
                int n = this.supers.length;
                ClassType[] classTypeArray2 = new ClassType[n];
                int n2 = 0;
                int n3 = 0;
                while (n3 < n) {
                    classTypeArray = Scheme.exp2Type(this.supers[n3]);
                    if (classTypeArray == null || !(classTypeArray instanceof ClassType)) {
                        throw new Error("invalid super type");
                    }
                    ClassType classType = (ClassType)classTypeArray;
                    if ((classType.getModifiers() & 0x200) == 0) {
                        if (n2 < n3) {
                            throw new Error("duplicate superclass");
                        }
                        this.type.setSuper(classType);
                    } else {
                        classTypeArray2[n2++] = classType;
                    }
                    ++n3;
                }
                if (n2 > 0) {
                    if (n2 == n) {
                        classTypeArray = classTypeArray2;
                    } else {
                        classTypeArray = new ClassType[n2];
                        System.arraycopy(classTypeArray2, 0, classTypeArray, 0, n2);
                    }
                    this.type.setInterfaces(classTypeArray);
                }
                if (n2 == n) {
                    this.type.setSuper(Type.pointer_type);
                }
            }
        }
        return this.type;
    }

    public void print(PrintWriter printWriter) {
        Printable printable;
        printWriter.print("(#%object/");
        if (this.name != null) {
            printWriter.print(this.name);
            printWriter.print('/');
        }
        printWriter.print(this.id);
        printWriter.print("/ (");
        Printable printable2 = null;
        int n = 0;
        int n2 = 0;
        int n3 = this.keywords == null ? 0 : this.keywords.length;
        int n4 = this.defaultArgs == null ? 0 : this.defaultArgs.length - n3;
        Declaration declaration = this.firstDecl();
        while (declaration != null) {
            printable = n < this.min_args ? null : (n < this.min_args + n4 ? Special.optional : (this.max_args < 0 && n == this.min_args + n4 ? Special.rest : Special.key));
            if (n > 0) {
                printWriter.print(' ');
            }
            if (printable != printable2) {
                printWriter.print(printable);
                printWriter.print(' ');
            }
            Expression expression = null;
            if (printable == Special.optional || printable == Special.key) {
                expression = this.defaultArgs[n2++];
            }
            if (expression != null) {
                printWriter.print('(');
            }
            printWriter.print(declaration.getName());
            if (expression != null && expression != QuoteExp.falseExp) {
                printWriter.print(' ');
                expression.print(printWriter);
                printWriter.print(')');
            }
            ++n;
            printable2 = printable;
            declaration = declaration.nextDecl();
        }
        printWriter.print(") ");
        printable = this.firstChild;
        while (printable != null) {
            printWriter.println();
            printWriter.print("  method: ");
            printable.print(printWriter);
            printable = printable.nextSibling;
        }
        if (this.body == null) {
            printWriter.print("<null body>");
        } else {
            this.body.print(printWriter);
        }
        printWriter.print(")");
    }

    public String toString() {
        String string = "ObjectExp/" + this.name + '/' + this.id + '/';
        int n = this.getLine();
        if (n <= 0 && this.body != null) {
            n = this.body.getLine();
        }
        if (n > 0) {
            string = String.valueOf(string) + "l:" + n;
        }
        return string;
    }

    Object walk(ExpWalker expWalker) {
        return expWalker.walkObjectExp(this);
    }
}

