;; $Id: dbl1no.dsl,v 1.13 1999/02/22 21:05:08 nwalsh Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://nwalsh.com/docbook/dsssl/
;;

;; ----------------------------- Localization -----------------------------

;; Norsk Bokm\U-00E5;l localization. (a-ring)
;; Translated by Stig S. Bakken, ssb@guardian.no
;; Send changes to Norman Walsh, ndw@nwalsh.com

;; The generated text for cross references to elements.  See dblink.dsl
;; for a discussion of how substitution is performed on the %x
;; keywords.
;;

(define (no-appendix-xref-string gi-or-name)
  (if %chapter-autolabel%
      "&Appendix; %n"
      "tillegget kalt %t"))

(define (no-article-xref-string gi-or-name)
  (string-append %gentext-no-start-quote%
		 "%t"
		 %gentext-no-end-quote%))

(define (no-bibliography-xref-string gi-or-name)
  "%t")

(define (no-book-xref-string gi-or-name)
  "%t")

(define (no-chapter-xref-string gi-or-name)
  (if %chapter-autolabel%
      "&Chapter; %n"
      "kapittelet kalt %t"))

(define (no-equation-xref-string gi-or-name)
  "&Equation; %n")

(define (no-example-xref-string gi-or-name)
  "&Example; %n")

(define (no-figure-xref-string gi-or-name)
  "&Figure; %n")

(define (no-listitem-xref-string gi-or-name)
  "%n")

(define (no-part-xref-string gi-or-name)
  "&Part; %n")

(define (no-preface-xref-string gi-or-name)
  "%t")

(define (no-procedure-xref-string gi-or-name)
  "&Procedure; %n, %t")

(define (no-section-xref-string gi-or-name)
  (if %section-autolabel% 
      "&Section; %n" 
      "seksjonen kalt %t"))

(define (no-sect1-xref-string gi-or-name)
  (no-section-xref-string gi-or-name))

(define (no-sect2-xref-string gi-or-name)
  (no-section-xref-string gi-or-name))

(define (no-sect3-xref-string gi-or-name)
  (no-section-xref-string gi-or-name))

(define (no-sect4-xref-string gi-or-name)
  (no-section-xref-string gi-or-name))

(define (no-sect5-xref-string gi-or-name)
  (no-section-xref-string gi-or-name))

(define (no-step-xref-string gi-or-name)
  "&Step; %n")

(define (no-table-xref-string gi-or-name)
  "&Table; %n")

(define (no-default-xref-string gi-or-name)
  (let* ((giname (if (string? gi-or-name) gi-or-name (gi gi-or-name)))
	 (msg    (string-append "[&xrefto; "
				(if giname giname "&nonexistantelement;")
				" &unsupported;]"))
	 (err    (node-list-error msg (current-node))))
    msg))

(define (gentext-no-xref-strings gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
      ((equal? name (normalize "appendix")) (no-appendix-xref-string gind))
      ((equal? name (normalize "article"))  (no-article-xref-string gind))
      ((equal? name (normalize "bibliography")) (no-bibliography-xref-string gind))
      ((equal? name (normalize "book"))     (no-book-xref-string gind))
      ((equal? name (normalize "chapter"))  (no-chapter-xref-string gind))
      ((equal? name (normalize "equation")) (no-equation-xref-string gind))
      ((equal? name (normalize "example"))  (no-example-xref-string gind))
      ((equal? name (normalize "figure"))   (no-figure-xref-string gind))
      ((equal? name (normalize "listitem")) (no-listitem-xref-string gind))
      ((equal? name (normalize "part"))     (no-part-xref-string gind))
      ((equal? name (normalize "preface"))  (no-preface-xref-string gind))
      ((equal? name (normalize "procedure")) (no-procedure-xref-string gind))
      ((equal? name (normalize "sect1"))    (no-sect1-xref-string gind))
      ((equal? name (normalize "sect2"))    (no-sect2-xref-string gind))
      ((equal? name (normalize "sect3"))    (no-sect3-xref-string gind))
      ((equal? name (normalize "sect4"))    (no-sect4-xref-string gind))
      ((equal? name (normalize "sect5"))    (no-sect5-xref-string gind))
      ((equal? name (normalize "step"))     (no-step-xref-string gind))
      ((equal? name (normalize "table"))    (no-table-xref-string gind))
      (else (no-default-xref-string gind)))))

(define (no-auto-xref-indirect-connector before) 
  (literal " &in; "))

;; Should the TOC come first or last?
;;
(define %generate-no-toc-in-front% #t)

;; gentext-element-name returns the generated text that should be 
;; used to make reference to the selected element.
;;
(define no-abstract-name	"&Abstract;")
(define no-appendix-name	"&Appendix;")
(define no-article-name	"&Article;")
(define no-bibliography-name	"&Bibliography;")
(define no-book-name		"&Book;")
(define no-calloutlist-name   "")
(define no-caution-name	"&Caution;")
(define no-chapter-name	"&Chapter;")
(define no-copyright-name	"&Copyright;")
(define no-dedication-name	"&Dedication;")
(define no-edition-name	"&Edition;")
(define no-equation-name	"&Equation;")
(define no-example-name	"&Example;")
(define no-figure-name	"&Figure;")
(define no-glossary-name	"&Glossary;")
(define no-glosssee-name	"&GlossSee;")
(define no-glossseealso-name	"&GlossSeeAlso;")
(define no-important-name	"&Important;")
(define no-index-name		"&Index;")
(define no-setindex-name	"&SetIndex;")
(define no-isbn-name		"&ISBN;")
(define no-legalnotice-name	"")
(define no-msgaud-name	"&MsgAud;")
(define no-msglevel-name	"&MsgLevel;")
(define no-msgorig-name	"&MsgOrig;")
(define no-note-name		"&Note;")
(define no-part-name		"&Part;")
(define no-preface-name	"&Preface;")
(define no-procedure-name	"&Procedure;")
(define no-pubdate-name	"&Published;")
(define no-reference-name	"&Reference;")
(define no-refname-name	"&RefName;")
(define no-revhistory-name	"&RevHistory;")
(define no-revision-name	"&Revision;")
(define no-sect1-name		"&Section;")
(define no-sect2-name		"&Section;")
(define no-sect3-name		"&Section;")
(define no-sect4-name		"&Section;")
(define no-sect5-name		"&Section;")
(define no-simplesect-name	"&Section;")
(define no-seeie-name		"&See;")
(define no-seealsoie-name	"&Seealso;")
(define no-set-name		"&Set;")
(define no-sidebar-name	"&Sidebar;")
(define no-step-name		"&step;")
(define no-table-name		"&Table;")
(define no-tip-name		"&Tip;")
(define no-toc-name		"&TableofContents;")
(define no-warning-name	"&Warning;")

(define (gentext-no-element-name gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
     ((equal? name (normalize "abstract"))	no-abstract-name)
     ((equal? name (normalize "appendix"))	no-appendix-name)
     ((equal? name (normalize "article"))	no-article-name)
     ((equal? name (normalize "bibliography"))	no-bibliography-name)
     ((equal? name (normalize "book"))		no-book-name)
     ((equal? name (normalize "calloutlist"))	no-calloutlist-name)
     ((equal? name (normalize "caution"))	no-caution-name)
     ((equal? name (normalize "chapter"))	no-chapter-name)
     ((equal? name (normalize "copyright"))	no-copyright-name)
     ((equal? name (normalize "dedication"))	no-dedication-name)
     ((equal? name (normalize "edition"))	no-edition-name)
     ((equal? name (normalize "equation"))	no-equation-name)
     ((equal? name (normalize "example"))	no-example-name)
     ((equal? name (normalize "figure"))	no-figure-name)
     ((equal? name (normalize "glossary"))	no-glossary-name)
     ((equal? name (normalize "glosssee"))	no-glosssee-name)
     ((equal? name (normalize "glossseealso"))	no-glossseealso-name)
     ((equal? name (normalize "important"))	no-important-name)
     ((equal? name (normalize "index"))		no-index-name)
     ((equal? name (normalize "setindex"))	no-setindex-name)
     ((equal? name (normalize "isbn"))		no-isbn-name)
     ((equal? name (normalize "legalnotice"))	no-legalnotice-name)
     ((equal? name (normalize "msgaud"))	no-msgaud-name)
     ((equal? name (normalize "msglevel"))	no-msglevel-name)
     ((equal? name (normalize "msgorig"))	no-msgorig-name)
     ((equal? name (normalize "note"))		no-note-name)
     ((equal? name (normalize "part"))		no-part-name)
     ((equal? name (normalize "preface"))	no-preface-name)
     ((equal? name (normalize "procedure"))	no-procedure-name)
     ((equal? name (normalize "pubdate"))	no-pubdate-name)
     ((equal? name (normalize "reference"))	no-reference-name)
     ((equal? name (normalize "refname"))	no-refname-name)
     ((equal? name (normalize "revhistory"))	no-revhistory-name)
     ((equal? name (normalize "revision"))	no-revision-name)
     ((equal? name (normalize "sect1"))		no-sect1-name)
     ((equal? name (normalize "sect2"))		no-sect2-name)
     ((equal? name (normalize "sect3"))		no-sect3-name)
     ((equal? name (normalize "sect4"))		no-sect4-name)
     ((equal? name (normalize "sect5"))		no-sect5-name)
     ((equal? name (normalize "simplesect"))	no-simplesect-name)
     ((equal? name (normalize "seeie"))		no-seeie-name)
     ((equal? name (normalize "seealsoie"))	no-seealsoie-name)
     ((equal? name (normalize "set"))		no-set-name)
     ((equal? name (normalize "sidebar"))	no-sidebar-name)
     ((equal? name (normalize "step"))		no-step-name)
     ((equal? name (normalize "table"))		no-table-name)
     ((equal? name (normalize "tip"))		no-tip-name)
     ((equal? name (normalize "toc"))		no-toc-name)
     ((equal? name (normalize "warning"))	no-warning-name)
     (else (let* ((msg (string-append "&unexpectedelementname;: " name))
		  (err (node-list-error msg (current-node))))
	     msg)))))

;; gentext-element-name-space returns gentext-element-name with a 
;; trailing space, if gentext-element-name isn't "".
;;
(define (gentext-no-element-name-space giname)
  (string-with-space (gentext-element-name giname)))

;; gentext-intra-label-sep returns the seperator to be inserted
;; between multiple occurances of a label (or parts of a label)
;; for the specified element.  Most of these are for enumerated
;; labels like "Figure 2-4", but this function is used elsewhere
;; (e.g. REFNAME) with a little abuse.
;;

(define no-equation-intra-label-sep "-")
(define no-example-intra-label-sep "-")
(define no-figure-intra-label-sep "-")
(define no-procedure-intra-label-sep ".")
(define no-refentry-intra-label-sep ".")
(define no-reference-intra-label-sep ".")
(define no-refname-intra-label-sep ", ")
(define no-refsect1-intra-label-sep ".")
(define no-refsect2-intra-label-sep ".")
(define no-refsect3-intra-label-sep ".")
(define no-sect1-intra-label-sep ".")
(define no-sect2-intra-label-sep ".")
(define no-sect3-intra-label-sep ".")
(define no-sect4-intra-label-sep ".")
(define no-sect5-intra-label-sep ".")
(define no-step-intra-label-sep ".")
(define no-table-intra-label-sep "-")
(define no-_pagenumber-intra-label-sep "-")
(define no-default-intra-label-sep "")

(define (gentext-no-intra-label-sep gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
     ((equal? name (normalize "equation"))	no-equation-intra-label-sep)
     ((equal? name (normalize "example"))	no-example-intra-label-sep)
     ((equal? name (normalize "figure"))	no-figure-intra-label-sep)
     ((equal? name (normalize "procedure"))	no-procedure-intra-label-sep)
     ((equal? name (normalize "refentry"))	no-refentry-intra-label-sep)
     ((equal? name (normalize "reference"))	no-reference-intra-label-sep)
     ((equal? name (normalize "refname"))	no-refname-intra-label-sep)
     ((equal? name (normalize "refsect1"))	no-refsect1-intra-label-sep)
     ((equal? name (normalize "refsect2"))	no-refsect2-intra-label-sep)
     ((equal? name (normalize "refsect3"))	no-refsect3-intra-label-sep)
     ((equal? name (normalize "sect1"))		no-sect1-intra-label-sep)
     ((equal? name (normalize "sect2"))		no-sect2-intra-label-sep)
     ((equal? name (normalize "sect3"))		no-sect3-intra-label-sep)
     ((equal? name (normalize "sect4"))		no-sect4-intra-label-sep)
     ((equal? name (normalize "sect5"))		no-sect5-intra-label-sep)
     ((equal? name (normalize "step"))		no-step-intra-label-sep)
     ((equal? name (normalize "table"))		no-table-intra-label-sep)
     ((equal? name (normalize "_pagenumber"))	no-_pagenumber-intra-label-sep)
     (else no-default-intra-label-sep))))

;; gentext-label-title-sep returns the seperator to be inserted
;; between a label and the text following the label for the
;; specified element.  Most of these are for use between
;; enumerated labels and titles like "1. Chapter One Title", but
;; this function is used elsewhere (e.g. NOTE) with a little
;; abuse.
;;

(define no-abstract-label-title-sep ": ")
(define no-appendix-label-title-sep ". ")
(define no-caution-label-title-sep "")
(define no-chapter-label-title-sep ". ")
(define no-equation-label-title-sep ". ")
(define no-example-label-title-sep ". ")
(define no-figure-label-title-sep ". ")
(define no-footnote-label-title-sep ". ")
(define no-glosssee-label-title-sep ": ")
(define no-glossseealso-label-title-sep ": ")
(define no-important-label-title-sep ": ")
(define no-note-label-title-sep ": ")
(define no-orderedlist-label-title-sep ". ")
(define no-part-label-title-sep ". ")
(define no-procedure-label-title-sep ". ")
(define no-prefix-label-title-sep ". ")
(define no-refentry-label-title-sep "")
(define no-reference-label-title-sep ". ")
(define no-refsect1-label-title-sep ". ")
(define no-refsect2-label-title-sep ". ")
(define no-refsect3-label-title-sep ". ")
(define no-sect1-label-title-sep ". ")
(define no-sect2-label-title-sep ". ")
(define no-sect3-label-title-sep ". ")
(define no-sect4-label-title-sep ". ")
(define no-sect5-label-title-sep ". ")
(define no-seeie-label-title-sep " ")
(define no-seealsoie-label-title-sep " ")
(define no-step-label-title-sep ". ")
(define no-table-label-title-sep ". ")
(define no-tip-label-title-sep ": ")
(define no-warning-label-title-sep "")
(define no-default-label-title-sep "")

(define (gentext-no-label-title-sep gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
     ((equal? name (normalize "abstract")) no-abstract-label-title-sep)
     ((equal? name (normalize "appendix")) no-appendix-label-title-sep)
     ((equal? name (normalize "caution")) no-caution-label-title-sep)
     ((equal? name (normalize "chapter")) no-chapter-label-title-sep)
     ((equal? name (normalize "equation")) no-equation-label-title-sep)
     ((equal? name (normalize "example")) no-example-label-title-sep)
     ((equal? name (normalize "figure")) no-figure-label-title-sep)
     ((equal? name (normalize "footnote")) no-footnote-label-title-sep)
     ((equal? name (normalize "glosssee")) no-glosssee-label-title-sep)
     ((equal? name (normalize "glossseealso")) no-glossseealso-label-title-sep)
     ((equal? name (normalize "important")) no-important-label-title-sep)
     ((equal? name (normalize "note")) no-note-label-title-sep)
     ((equal? name (normalize "orderedlist")) no-orderedlist-label-title-sep)
     ((equal? name (normalize "part")) no-part-label-title-sep)
     ((equal? name (normalize "procedure")) no-procedure-label-title-sep)
     ((equal? name (normalize "prefix")) no-prefix-label-title-sep)
     ((equal? name (normalize "refentry")) no-refentry-label-title-sep)
     ((equal? name (normalize "reference")) no-reference-label-title-sep)
     ((equal? name (normalize "refsect1")) no-refsect1-label-title-sep)
     ((equal? name (normalize "refsect2")) no-refsect2-label-title-sep)
     ((equal? name (normalize "refsect3")) no-refsect3-label-title-sep)
     ((equal? name (normalize "sect1")) no-sect1-label-title-sep)
     ((equal? name (normalize "sect2")) no-sect2-label-title-sep)
     ((equal? name (normalize "sect3")) no-sect3-label-title-sep)
     ((equal? name (normalize "sect4")) no-sect4-label-title-sep)
     ((equal? name (normalize "sect5")) no-sect5-label-title-sep)
     ((equal? name (normalize "seeie")) no-seeie-label-title-sep)
     ((equal? name (normalize "seealsoie")) no-seealsoie-label-title-sep)
     ((equal? name (normalize "step")) no-step-label-title-sep)
     ((equal? name (normalize "table")) no-table-label-title-sep)
     ((equal? name (normalize "tip")) no-tip-label-title-sep)
     ((equal? name (normalize "warning")) no-warning-label-title-sep)
     (else no-default-label-title-sep))))

(define (no-set-label-number-format gind) "1")
(define (no-book-label-number-format gind) "1")
(define (no-prefix-label-number-format gind) "1")
(define (no-part-label-number-format gind) "I")
(define (no-chapter-label-number-format gind) "1")
(define (no-appendix-label-number-format gind) "A")
(define (no-reference-label-number-format gind) "I")
(define (no-example-label-number-format gind) "1")
(define (no-figure-label-number-format gind) "1")
(define (no-table-label-number-format gind) "1")
(define (no-procedure-label-number-format gind) "1")
(define (no-step-label-number-format gind) "1")
(define (no-refsect1-label-number-format gind) "1")
(define (no-refsect2-label-number-format gind) "1")
(define (no-refsect3-label-number-format gind) "1")
(define (no-sect1-label-number-format gind) "1")
(define (no-sect2-label-number-format gind) "1")
(define (no-sect3-label-number-format gind) "1")
(define (no-sect4-label-number-format gind) "1")
(define (no-sect5-label-number-format gind) "1")
(define (no-default-label-number-format gind) "1")

(define (no-label-number-format gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
     ((equal? name (normalize "set")) (no-set-label-number-format gind))
     ((equal? name (normalize "book")) (no-book-label-number-format gind))
     ((equal? name (normalize "prefix")) (no-prefix-label-number-format gind))
     ((equal? name (normalize "part")) (no-part-label-number-format gind))
     ((equal? name (normalize "chapter")) (no-chapter-label-number-format gind))
     ((equal? name (normalize "appendix")) (no-appendix-label-number-format gind))
     ((equal? name (normalize "reference")) (no-reference-label-number-format gind))
     ((equal? name (normalize "example")) (no-example-label-number-format gind))
     ((equal? name (normalize "figure")) (no-figure-label-number-format gind))
     ((equal? name (normalize "table")) (no-table-label-number-format gind))
     ((equal? name (normalize "procedure")) (no-procedure-label-number-format gind))
     ((equal? name (normalize "step")) (no-step-label-number-format gind))
     ((equal? name (normalize "refsect1")) (no-refsect1-label-number-format gind))
     ((equal? name (normalize "refsect2")) (no-refsect2-label-number-format gind))
     ((equal? name (normalize "refsect3")) (no-refsect3-label-number-format gind))
     ((equal? name (normalize "sect1")) (no-sect1-label-number-format gind))
     ((equal? name (normalize "sect2")) (no-sect2-label-number-format gind))
     ((equal? name (normalize "sect3")) (no-sect3-label-number-format gind))
     ((equal? name (normalize "sect4")) (no-sect4-label-number-format gind))
     ((equal? name (normalize "sect5")) (no-sect5-label-number-format gind))
     (else (no-default-label-number-format gind)))))

(define ($lot-title-no$ gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond ((equal? name (normalize "table"))    "&ListofTables;")
	  ((equal? name (normalize "example"))  "&ListofExamples;")
	  ((equal? name (normalize "figure"))   "&ListofFigures;")
	  ((equal? name (normalize "equation")) "&ListofEquations;")
	  (else (let* ((msg (string-append "&ListofUnknown;: " name))
		       (err (node-list-error msg (current-node))))
		  msg)))))

(define %gentext-no-start-quote%  (dingbat "ldquo"))

(define %gentext-no-end-quote%  (dingbat "rdquo"))

(define %gentext-no-start-nested-quote%  (dingbat "lsquo"))

(define %gentext-no-end-nested-quote%  (dingbat "rsquo"))

(define %gentext-no-by% "&by;") ;; e.g. Copyright 1997 "by" A. Nonymous
                           ;; Authored "by" Jane Doe

(define %gentext-no-edited-by% "&Editedby;")
                           ;; "Edited by" Jane Doe

(define %gentext-no-page% "")

(define %gentext-no-and% "&and;")

(define %gentext-no-bibl-pages% "&Pgs;")

(define %gentext-no-endnotes% "&Notes;")

(define %gentext-no-table-endnotes% "&TableNotes;:")

(define %gentext-no-index-see% "&See;")

(define %gentext-no-index-seealso% "&SeeAlso;")

