/********************************************************************/
/* time.c  - run a program and display time / memory stats at exit */

#include <windows.h>
#include <stdio.h>
#include <time.h>
#include <process.h>
#include <signal.h>

/*==================================================================*/
/* Function: getmem */
/* Purpose: get current ram/swapfile load */

unsigned getmem(void)
{
    MEMORYSTATUS mem;
    mem.dwLength = sizeof(MEMORYSTATUS);
    GlobalMemoryStatus(&mem);
    return (unsigned)
        ((mem.dwTotalPhys - mem.dwAvailPhys)
        + (mem.dwTotalPageFile - mem.dwAvailPageFile));
}

/*==================================================================*/
/* Function: run_process */
/* Purpose: low level process spawn, optionally wait for completion */

int run_process(char *cmd, const char *dir, int wait, unsigned *ret, unsigned *pm)
{
    PROCESS_INFORMATION pi;
    STARTUPINFO si;

    memset(&si, 0, sizeof si);
    si.cb = sizeof si;
    if (FALSE == CreateProcess(NULL, cmd, NULL, NULL,
            TRUE, NORMAL_PRIORITY_CLASS, NULL, dir, &si, &pi))
        return -1;

    if (wait) {
        DWORD retcode = 0;
        for (;;) {
            DWORD w = WaitForSingleObject(pi.hProcess, 100);
            unsigned m = getmem();
            if (m > *pm)
                *pm = m;
            if (WAIT_TIMEOUT != w)
                break;
        }
        GetExitCodeProcess(pi.hProcess, &retcode);
        *ret = retcode;
    }

    CloseHandle(pi.hThread);
    CloseHandle(pi.hProcess);
    return 0;
}

/*==================================================================*/
int main(int argc, const char **argv)
{
    unsigned char *cmd;
    unsigned mm, m1, m2, cc, c1, c2, rc;
    int i, r, c, m, s, t, h;

    if (argc < 2) {
        fprintf(stderr, "usage: time <program> [<arguments ...>]\n");
        return 1;
    }

    cmd = GetCommandLine();
    /* remove itself from command line */
    for (cmd += (i = *cmd=='\"');
        (unsigned char)*cmd > ' ' - i && *cmd++!='\"';);
    for (;*cmd==' ';cmd++);

    c1 = clock();
    m1 = m2 = getmem();
    r = run_process(cmd, NULL, 1, &rc, &m2);
    c2 = clock();

    if (r == -1) {
        fprintf(stderr, "time: command not found: '%s'\n", cmd);
        return 1;
    }

    mm = m2 - m1;
    cc = c2 - c1;
    if (cc < 0)
        cc = 0;
    cc /= 10;

    t = cc % 100;
    c = cc / 100;

    s = c;
    m = s / 60;
    s = s % 60;
    h = m / 60;
    m = m % 60;

    mm /= 100000;
    printf("time: %u.%02u seconds (%d:%02d:%02d)"
        //" - memory: %u.%1u MB"
        "\n", c, t, h, m, s
        //, mm / 10, mm % 10
        );

    return rc;
}

/*==================================================================*/
