/*
 * Decompiled with CFR 0.152.
 */
package org.treebind;

import java.lang.reflect.Method;
import java.util.Iterator;
import org.treebind.DefaultPipeElementImplementation;
import org.treebind.JavaClassName;
import org.treebind.JavaMethodName;
import org.treebind.JavaObject2XmlSaxPipe;
import org.treebind.Name;
import org.treebind.Names;
import org.treebind.Sink;
import org.treebind.Source;

public class JavaObjectSource
extends DefaultPipeElementImplementation
implements Source {
    Sink sink;

    public JavaObjectSource() {
    }

    public JavaObjectSource(JavaObject2XmlSaxPipe pipe) {
        super(pipe);
    }

    public Name getNature(Method method, Object value, boolean iterated) {
        return new JavaClassName(value);
    }

    public Name getRole(Method method, Object value, boolean iterated) {
        return new JavaMethodName(method, iterated);
    }

    public Sink getSink() {
        return this.sink;
    }

    void pourObject(Method method, Object value, boolean iterated) throws Exception {
        if (!value.getClass().getName().startsWith("java.")) {
            this.pourObject(this.getRole(method, value, iterated), value, iterated);
        } else if (value.getClass().getName().startsWith("java.lang.") && !value.getClass().getName().equals("java.lang.Class")) {
            this.sink.addLeaf(this.getRole(method, value, iterated), this.getNature(method, value, iterated), value);
        } else {
            Iterator iterator;
            try {
                iterator = (Iterator)value;
            }
            catch (Exception e) {
                iterator = null;
            }
            if (iterator != null) {
                while (iterator.hasNext()) {
                    Object item = iterator.next();
                    this.pourObject(method, item, true);
                }
            }
        }
    }

    void pourObject(Name role, Object value, boolean iterated) throws Exception {
        this.sink.startProperty(role, this.getNature(null, value, iterated));
        this.pourSubObjects(value);
        this.sink.endProperty();
    }

    public void pourObject(Object object) throws Exception {
        this.pourObject(Names.root, object, false);
    }

    void pourSubObjects(Object object) throws Exception {
        Class<?> klass = object.getClass();
        Method[] methods = klass.getMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if (method.getName().startsWith("get") && method.getParameterTypes().length == 0) {
                Object value;
                try {
                    value = method.invoke(object, null);
                }
                catch (Exception e) {
                    value = null;
                }
                if (value != null) {
                    this.pourObject(method, value, false);
                }
            }
            ++i;
        }
    }

    public void setSink(Sink sink) {
        this.sink = sink;
    }
}

