/*
 * Decompiled with CFR 0.152.
 */
package org.treebind;

import com.hp.hpl.jena.rdf.model.LiteralRequiredException;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Selector;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;
import org.treebind.DefaultPipeElementImplementation;
import org.treebind.Name;
import org.treebind.Names;
import org.treebind.Pipe;
import org.treebind.RdfResourceName;
import org.treebind.Sink;
import org.treebind.Source;

public class JenaRdfSource
extends DefaultPipeElementImplementation
implements Source {
    Model model = null;
    Set resources;
    Sink sink;

    public JenaRdfSource() {
    }

    public JenaRdfSource(Pipe pipe) {
        super(pipe);
    }

    public Sink getSink() {
        return this.sink;
    }

    private String getType(Resource resource) {
        SimpleSelector selector = new SimpleSelector(resource, RDF.type, null);
        StmtIterator iter = this.model.listStatements((Selector)selector);
        if (iter.hasNext()) {
            Statement statement = iter.nextStatement();
            return statement.getResource().getURI().toString();
        }
        return null;
    }

    public void parse(Reader reader) throws Exception {
        this.model = ModelFactory.createDefaultModel();
        this.model.read(reader, "http://treebind.org/defaultBase/");
    }

    public void parse(String uri) throws Exception {
        this.model = ModelFactory.createDefaultModel();
        this.model.read(uri);
    }

    public void parseString(String rdfString) throws Exception {
        StringReader reader = new StringReader(rdfString);
        this.parse(reader);
    }

    private void pourBranch(Resource resource, Name role) throws Exception {
        String type = this.getType(resource);
        Name nature = type != null ? new RdfResourceName(type) : role;
        this.sink.startProperty(role, nature);
        if (type != null) {
            nature = new RdfResourceName(type);
            this.sink.startProperty(RdfResourceName.type, RdfResourceName.type);
            this.sink.addLeaf(RdfResourceName.URI, Names.literal, type);
            this.sink.endProperty();
        }
        if (resource.getURI() != null) {
            this.pourLeaf(resource.getURI(), RdfResourceName.URI);
        }
        SimpleSelector selector = new SimpleSelector(resource, null, null);
        StmtIterator iter = this.model.listStatements((Selector)selector);
        while (iter.hasNext()) {
            Statement statement = iter.nextStatement();
            if (statement.getPredicate().equals((Object)RDF.type)) continue;
            RdfResourceName subRole = new RdfResourceName(statement.getPredicate().getURI());
            try {
                String value = statement.getLiteral().toString();
                this.pourLeaf(value, subRole);
            }
            catch (LiteralRequiredException e) {
                Resource subResource = statement.getResource();
                this.pourBranch(subResource, subRole);
            }
        }
        this.sink.endProperty();
    }

    private void pourLeaf(String value, Name role) throws Exception {
        this.sink.addLeaf(role, Names.literal, value);
    }

    public void pourModelFromType(RdfResourceName type) throws Exception {
        this.resources = new HashSet();
        SimpleSelector selector = new SimpleSelector(null, RDF.type, (RDFNode)this.model.createResource(type.getFullName()));
        StmtIterator iter = this.model.listStatements((Selector)selector);
        while (iter.hasNext()) {
            Statement statement = iter.nextStatement();
            this.pourBranch(statement.getSubject(), Names.root);
        }
    }

    public void pourModelFromType(String type) throws Exception {
        this.pourModelFromType(new RdfResourceName(type));
    }

    public void setSink(Sink sink) {
        this.sink = sink;
    }
}

