/*
 * Decompiled with CFR 0.152.
 */
package org.treebind;

import java.io.DataInputStream;
import java.io.StringBufferInputStream;
import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.util.LDIF;
import netscape.ldap.util.LDIFAttributeContent;
import netscape.ldap.util.LDIFContent;
import netscape.ldap.util.LDIFRecord;
import org.treebind.DefaultPipeElementImplementation;
import org.treebind.LdapName;
import org.treebind.LdifException;
import org.treebind.Names;
import org.treebind.Pipe;
import org.treebind.Sink;
import org.treebind.Source;

public class LdapSource
extends DefaultPipeElementImplementation
implements Source {
    Sink sink;

    public LdapSource() {
    }

    public LdapSource(Pipe pipe) {
        super(pipe);
    }

    public Sink getSink() {
        return this.sink;
    }

    public void parseLdifString(String ldifString) throws Exception {
        StringBufferInputStream is = new StringBufferInputStream(ldifString);
        DataInputStream stream = new DataInputStream(is);
        LDIF ldif = new LDIF(stream);
        this.pour(ldif);
    }

    public void pour(LDAPAttribute ldapAttribute) throws Exception {
        String attributeName = ldapAttribute.getName();
        Enumeration enumValues = ldapAttribute.getStringValues();
        while (enumValues.hasMoreElements()) {
            String value = (String)enumValues.nextElement();
            this.sink.addLeaf(new LdapName(attributeName), Names.literal, value);
        }
    }

    public void pour(LDAPEntry ldapEntry) throws Exception {
        this.sink.startProperty(LdapName.ENTRY, LdapName.ENTRY);
        this.sink.addLeaf(LdapName.DN, Names.literal, ldapEntry.getDN());
        LDAPAttribute objectClass = ldapEntry.getAttribute("objectClass");
        if (objectClass == null) {
            objectClass = ldapEntry.getAttribute("objectclass");
        }
        if (objectClass != null) {
            this.pour(objectClass);
        }
        LDAPAttributeSet ldapAttributeSet = ldapEntry.getAttributeSet();
        Enumeration enumAttributes = ldapAttributeSet.getAttributes();
        while (enumAttributes.hasMoreElements()) {
            LDAPAttribute ldapAttribute = (LDAPAttribute)enumAttributes.nextElement();
            if (ldapAttribute.getName().toLowerCase().equals("objectclass")) continue;
            this.pour(ldapAttribute);
        }
        this.sink.endProperty();
    }

    public void pour(LDAPSearchResults ldapSearchResults) throws Exception {
        this.sink.startProperty(LdapName.SEARCHRESULTS, LdapName.SEARCHRESULTS);
        while (ldapSearchResults.hasMoreElements()) {
            LDAPEntry ldapEntry = ldapSearchResults.next();
            this.pour(ldapEntry);
        }
        this.sink.endProperty();
    }

    public void pour(LDIF ldif) throws Exception {
        this.sink.startProperty(LdapName.LDIF, LdapName.LDIF);
        LDIFRecord ldifRecord = ldif.nextRecord();
        while (ldifRecord != null) {
            this.pour(ldifRecord);
            ldifRecord = ldif.nextRecord();
        }
        this.sink.endProperty();
    }

    public void pour(LDIFRecord ldifRecord) throws Exception {
        LDIFContent ldifContent = ldifRecord.getContent();
        if (ldifContent.getType() == 0) {
            this.sink.startProperty(LdapName.LDIFRECORD, LdapName.LDIFRECORD);
            this.sink.addLeaf(LdapName.DN, Names.literal, ldifRecord.getDN());
            LDIFAttributeContent ldifAttributeContent = (LDIFAttributeContent)ldifContent;
            LDAPAttribute[] ldapAttributes = ldifAttributeContent.getAttributes();
            int i = 0;
            while (i < ldapAttributes.length) {
                if ("objectclass".equals(ldapAttributes[i].getName().toLowerCase())) {
                    this.pour(ldapAttributes[i]);
                    break;
                }
                ++i;
            }
            i = 0;
            while (i < ldapAttributes.length) {
                if (!"objectclass".equals(ldapAttributes[i].getName().toLowerCase())) {
                    this.pour(ldapAttributes[i]);
                }
                ++i;
            }
        } else {
            throw new LdifException("LdapSource only supports LDIF attribute contents.");
        }
        this.sink.endProperty();
    }

    public void setSink(Sink sink) {
        this.sink = sink;
    }
}

