/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Pack;
import com.izforge.izpack.panels.PacksPanelInterface;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;

class PacksModel
extends AbstractTableModel {
    private List packs;
    private List packsToInstall;
    private PacksPanelInterface panel;
    private LocaleDatabase langpack;
    private int[] checkValues;
    Map namesObj;
    Map namesPos;

    public PacksModel(List packs, List packsToInstall, PacksPanelInterface panel) {
        this.packs = packs;
        this.packsToInstall = packsToInstall;
        this.panel = panel;
        this.langpack = panel.getLangpack();
        this.checkValues = new int[packs.size()];
        this.reverseDeps();
        this.initvalues();
    }

    private void reverseDeps() {
        Pack pack;
        int i;
        this.namesObj = new HashMap();
        for (i = 0; i < this.packs.size(); ++i) {
            pack = (Pack)this.packs.get(i);
            this.namesObj.put(pack.name, pack);
        }
        for (i = 0; i < this.packs.size(); ++i) {
            pack = (Pack)this.packs.get(i);
            List deps = pack.dependencies;
            for (int j = 0; deps != null && j < deps.size(); ++j) {
                String name = (String)deps.get(j);
                Pack parent = (Pack)this.namesObj.get(name);
                parent.addRevDep(pack.name);
            }
        }
    }

    private void initvalues() {
        Pack pack;
        int i;
        this.namesPos = new HashMap();
        for (i = 0; i < this.packs.size(); ++i) {
            pack = (Pack)this.packs.get(i);
            this.namesPos.put(pack.name, new Integer(i));
        }
        for (i = 0; i < this.packs.size(); ++i) {
            pack = (Pack)this.packs.get(i);
            if (!this.packsToInstall.contains(pack)) continue;
            this.checkValues[i] = 1;
        }
        for (i = 0; i < this.packs.size(); ++i) {
            pack = (Pack)this.packs.get(i);
            if (this.checkValues[i] != 0) continue;
            List deps = pack.revDependencies;
            for (int j = 0; deps != null && j < deps.size(); ++j) {
                String name = (String)deps.get(j);
                int pos = this.getPos(name);
                this.checkValues[pos] = -2;
            }
        }
        for (i = 0; i < this.packs.size(); ++i) {
            pack = (Pack)this.packs.get(i);
            if (!pack.required) continue;
            this.propRequirement(pack.name);
        }
    }

    private void propRequirement(String name) {
        int pos = this.getPos(name);
        this.checkValues[pos] = -1;
        List deps = ((Pack)this.packs.get((int)pos)).dependencies;
        for (int i = 0; deps != null && i < deps.size(); ++i) {
            String s = (String)deps.get(i);
            this.propRequirement(s);
        }
    }

    private int getPos(String name) {
        return (Integer)this.namesPos.get(name);
    }

    public int getRowCount() {
        return this.packs.size();
    }

    public int getColumnCount() {
        return 3;
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Integer.class;
            }
        }
        return String.class;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.checkValues[rowIndex] < 0) {
            return false;
        }
        return columnIndex == 0;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Pack pack = (Pack)this.packs.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return new Integer(this.checkValues[rowIndex]);
            }
            case 1: {
                if (this.langpack == null || pack.id == null || pack.id.equals("")) {
                    return pack.name;
                }
                return this.langpack.getString(pack.id);
            }
            case 2: {
                return Pack.toByteUnitsString((int)pack.nbytes);
            }
        }
        return null;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0 && aValue instanceof Integer) {
            Pack pack = (Pack)this.packs.get(rowIndex);
            if ((Integer)aValue == 1) {
                this.checkValues[rowIndex] = 1;
                this.updateDeps();
                int bytes = this.panel.getBytes();
                bytes = (int)((long)bytes + pack.nbytes);
                this.panel.setBytes(bytes);
            } else {
                this.checkValues[rowIndex] = 0;
                this.updateDeps();
                int bytes = this.panel.getBytes();
                bytes = (int)((long)bytes - pack.nbytes);
                this.panel.setBytes(bytes);
            }
            this.fireTableDataChanged();
            this.refreshPacksToInstall();
            this.panel.showSpaceRequired();
        }
    }

    private void refreshPacksToInstall() {
        this.packsToInstall.clear();
        for (int i = 0; i < this.packs.size(); ++i) {
            Object pack = this.packs.get(i);
            if (Math.abs(this.checkValues[i]) != 1) continue;
            this.packsToInstall.add(pack);
        }
    }

    private void updateDeps() {
        int i;
        int[] statusArray = new int[this.packs.size()];
        for (i = 0; i < statusArray.length; ++i) {
            statusArray[i] = 0;
        }
        this.dfs(statusArray);
        for (i = 0; i < statusArray.length; ++i) {
            if (statusArray[i] == 0 && this.checkValues[i] < 0) {
                int n = i;
                this.checkValues[n] = this.checkValues[n] + 2;
            }
            if (statusArray[i] != 1 || this.checkValues[i] < 0) continue;
            this.checkValues[i] = -2;
        }
        for (i = 0; i < this.packs.size(); ++i) {
            Pack pack = (Pack)this.packs.get(i);
            if (!pack.required) continue;
            this.propRequirement(pack.name);
        }
    }

    private int dfs(int[] status) {
        for (int i = 0; i < this.packs.size(); ++i) {
            boolean wipe;
            for (int j = 0; j < this.packs.size(); ++j) {
                ((Pack)this.packs.get((int)j)).color = 0;
            }
            Pack pack = (Pack)this.packs.get(i);
            if (this.dfsVisit(pack, status, wipe = false) == 0) continue;
            return -1;
        }
        return 0;
    }

    private int dfsVisit(Pack u, int[] status, boolean wipe) {
        List deps;
        u.color = 1;
        int check = this.checkValues[this.getPos(u.name)];
        if (Math.abs(check) != 1) {
            wipe = true;
        }
        if ((deps = u.revDependencies) != null) {
            for (int i = 0; i < deps.size(); ++i) {
                int result;
                String name = (String)deps.get(i);
                Pack v = (Pack)this.namesObj.get(name);
                if (wipe) {
                    status[this.getPos((String)v.name)] = 1;
                }
                if (v.color != 0 || (result = this.dfsVisit(v, status, wipe)) == 0) continue;
                return result;
            }
        }
        u.color = 2;
        return 0;
    }
}

