/*
 * Decompiled with CFR 0.152.
 */
package processing.app.preproc;

import com.oroinc.text.regex.MalformedPatternException;
import com.oroinc.text.regex.MatchResult;
import com.oroinc.text.regex.Pattern;
import com.oroinc.text.regex.PatternMatcherInput;
import com.oroinc.text.regex.Perl5Compiler;
import com.oroinc.text.regex.Perl5Matcher;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import processing.app.Preferences;
import processing.app.Sketch;
import processing.core.PApplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdePreprocessor {
    public int prototypeCount = 0;
    public int headerCount = 1;
    List prototypes;
    ArrayList<String> programImports;
    ArrayList<String> codeFolderImports;
    String indent;
    PrintStream stream;
    String program;
    String buildPath;
    String name;

    public PdePreprocessor() {
        int n = Preferences.getInteger("editor.tabs.size");
        char[] cArray = new char[n];
        Arrays.fill(cArray, ' ');
        this.indent = new String(cArray);
    }

    public int writePrefix(String string, String string2, String string3, String[] stringArray) throws FileNotFoundException {
        this.buildPath = string2;
        this.name = string3;
        string = string + "\n";
        String string4 = Sketch.scrubComments(string);
        if (Preferences.getBoolean("preproc.substitute_unicode")) {
            string = PdePreprocessor.substituteUnicode(string);
        }
        String string5 = "^\\s*#include\\s+[<\"](\\S+)[\">]";
        this.programImports = new ArrayList();
        String[][] stringArray2 = PApplet.matchAll((String)string, (String)string5);
        if (stringArray2 != null) {
            for (int i = 0; i < stringArray2.length; ++i) {
                this.programImports.add(stringArray2[i][1]);
            }
        }
        this.codeFolderImports = new ArrayList();
        this.prototypes = new ArrayList();
        try {
            this.prototypes = this.prototypes(string);
        }
        catch (MalformedPatternException malformedPatternException) {
            System.out.println("Internal error while pre-processing; not generating function prototypes.\n\n" + (Object)((Object)malformedPatternException));
        }
        this.prototypeCount = this.prototypes.size();
        this.program = string;
        File file = new File(string2, this.name + ".cpp");
        this.stream = new PrintStream(new FileOutputStream(file));
        return this.headerCount + this.prototypeCount;
    }

    static String substituteUnicode(String string) {
        int n;
        char[] cArray = string.toCharArray();
        int n2 = 0;
        for (n = 0; n < cArray.length; ++n) {
            if (cArray[n] <= '\u007f') continue;
            ++n2;
        }
        if (n2 != 0) {
            n = 0;
            char[] cArray2 = new char[cArray.length + n2 * 5];
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] < '\u0080') {
                    cArray2[n++] = cArray[i];
                    continue;
                }
                if (cArray[i] == '\u00a0') {
                    cArray2[n++] = 32;
                    continue;
                }
                char c = cArray[i];
                cArray2[n++] = 92;
                cArray2[n++] = 117;
                char[] cArray3 = Integer.toHexString(c).toCharArray();
                for (int j = 0; j < 4 - cArray3.length; ++j) {
                    cArray2[n++] = 48;
                }
                System.arraycopy(cArray3, 0, cArray2, n, cArray3.length);
                n += cArray3.length;
            }
            string = new String(cArray2, 0, n);
        }
        return string;
    }

    public String write() throws Exception {
        this.writeProgram(this.stream, this.program, this.prototypes);
        this.writeFooter(this.stream);
        this.stream.close();
        return this.name;
    }

    protected void writeProgram(PrintStream printStream, String string, List list) {
        int n = this.firstStatement(string);
        printStream.print(string.substring(0, n));
        printStream.print("#include \"WProgram.h\"\n");
        for (int i = 0; i < list.size(); ++i) {
            printStream.print(list.get(i) + "\n");
        }
        printStream.print(string.substring(n));
    }

    protected void writeFooter(PrintStream printStream) throws Exception {
    }

    public ArrayList<String> getExtraImports() {
        return this.programImports;
    }

    public int firstStatement(String string) {
        PatternMatcherInput patternMatcherInput = new PatternMatcherInput(string);
        Perl5Compiler perl5Compiler = new Perl5Compiler();
        Perl5Matcher perl5Matcher = new Perl5Matcher();
        Pattern pattern = null;
        try {
            pattern = perl5Compiler.compile("\\s+|(/\\*[^*]*(?:\\*(?!/)[^*]*)*\\*/)|(//.*?$)|(#(?:\\\\\\n|.)*)", 8);
        }
        catch (MalformedPatternException malformedPatternException) {
            throw new RuntimeException("Internal error in firstStatement()", malformedPatternException);
        }
        int n = 0;
        while (perl5Matcher.matchesPrefix(patternMatcherInput, pattern)) {
            n = perl5Matcher.getMatch().endOffset(0);
            patternMatcherInput.setCurrentOffset(n);
        }
        return n;
    }

    public String strip(String string) throws MalformedPatternException {
        Perl5Compiler perl5Compiler = new Perl5Compiler();
        Perl5Matcher perl5Matcher = new Perl5Matcher();
        Pattern pattern = perl5Compiler.compile("('.')|(\"(?:[^\"\\\\]|\\\\.)*\")|(/\\*[^*]*(?:\\*(?!/)[^*]*)*\\*/)|(//.*?$)|(^\\s*#.*?$)", 8);
        while (perl5Matcher.contains(string, pattern)) {
            MatchResult matchResult = perl5Matcher.getMatch();
            string = string.substring(0, matchResult.beginOffset(0)) + " " + string.substring(matchResult.endOffset(0));
        }
        return string;
    }

    private String collapseBraces(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '{') {
                if (n == 0) {
                    stringBuffer.append(string.substring(n2, i + 1));
                }
                ++n;
            }
            if (string.charAt(i) != '}' || --n != 0) continue;
            n2 = i;
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    public List prototypes(String string) throws MalformedPatternException {
        string = this.collapseBraces(this.strip(string));
        PatternMatcherInput patternMatcherInput = new PatternMatcherInput(string);
        Perl5Compiler perl5Compiler = new Perl5Compiler();
        Perl5Matcher perl5Matcher = new Perl5Matcher();
        Pattern pattern = perl5Compiler.compile("[\\w\\[\\]\\*]+\\s+[\\[\\]\\*\\w\\s]+\\([,\\[\\]\\*\\w\\s]*\\)(?=\\s*\\{)");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (perl5Matcher.contains(patternMatcherInput, pattern)) {
            arrayList.add(perl5Matcher.getMatch().group(0) + ";");
        }
        return arrayList;
    }
}

